/*
<media-theme-yt>
  <video
    slot="media"
    src="https://stream.mux.com/fXNzVtmtWuyz00xnSrJg4OJH6PyNo6D02UzmgeKGkP5YQ/high.mp4"
  ></video>
</media-theme-yt>
*/

import 'media-chrome';
import { globalThis } from 'media-chrome/dist/utils/server-safe-globals.js';
import { MediaThemeElement } from 'media-chrome/dist/media-theme-element.js';
import 'media-chrome/dist/menu/index.js';

const template = globalThis.document?.createElement?.('template');
if (template) {
  template.innerHTML = /*html*/`
    <style>
      media-controller {
        font-size: 13px;
        font-family: Roboto, Arial, sans-serif;
        --media-font-family: Roboto, helvetica neue, segoe ui, arial, sans-serif;
        -webkit-font-smoothing: antialiased;
        --media-secondary-color: transparent;
        --media-menu-background: rgba(28, 28, 28, 0.9);
        --media-control-hover-background: var(--media-secondary-color);
        --media-range-track-height: 3px;
        --media-range-thumb-height: 13px;
        --media-range-thumb-width: 13px;
        --media-range-thumb-border-radius: 13px;
        --media-preview-thumbnail-border: 2px solid #fff;
        --media-preview-thumbnail-border-radius: 2px;
        --media-preview-time-margin: 5px 0 0;
        --media-tooltip-display: none;
      }

      /* The biggest size controller is tied to going fullscreen
          instead of a player width */
      media-controller[mediaisfullscreen] {
        font-size: 17px;
        --media-range-thumb-height: 20px;
        --media-range-thumb-width: 20px;
        --media-range-thumb-border-radius: 10px;
        --media-range-track-height: 4px;
      }

      .yt-button {
        position: relative;
        display: inline-block;
        width: 36px;
        padding: 0 2px;
        height: 100%;
        opacity: 0.9;
        transition: opacity 0.1s cubic-bezier(0.4, 0, 1, 1);
      }
      [breakpointmd] .yt-button {
        width: 48px;
      }
      [mediaisfullscreen] .yt-button {
        width: 54px;
      }

      .yt-button svg {
        height: 100%;
        width: 100%;
        fill: var(--media-primary-color, #fff);
        fill-rule: evenodd;
      }

      .svg-shadow {
        stroke: #000;
        stroke-opacity: 0.15;
        stroke-width: 2px;
        fill: none;
      }
    </style>

    <media-controller
      breakpoints="md:480"
      defaultsubtitles="{{defaultsubtitles}}"
      defaultduration="{{defaultduration}}"
      gesturesdisabled="{{disabled}}"
      hotkeys="{{hotkeys}}"
      nohotkeys="{{nohotkeys}}"
      defaultstreamtype="on-demand"
    >
      <slot name="media" slot="media"></slot>
      <slot name="poster" slot="poster"></slot>

      <!-- Gradient -->
      <style>
        .yt-gradient-bottom {
          padding-top: 37px;
          position: absolute;
          width: 100%;
          height: 170px;
          bottom: 0;
          pointer-events: none;
          background-position: bottom;
          background-repeat: repeat-x;
          background-image: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAACqCAYAAABsziWkAAAAAXNSR0IArs4c6QAAAQVJREFUOE9lyNdHBQAAhfHb3nvvuu2997jNe29TJJEkkkgSSSSJJJJEEkkiifRH5jsP56Xz8PM5gcC/xfDEmjhKxEOCSaREEiSbFEqkQppJpzJMJiWyINvkUCIX8kw+JQqg0BRRxaaEEqVQZsopUQGVpooS1VBjglStqaNEPTSYRko0QbNpoUQrtJl2qsN0UqILuk0PJXqhz/RTYgAGzRA1bEYoMQpjZpwSExAyk5SYgmkzQ82aOUqEIWKilJiHBbNIiSVYhhVYhTVYhw3YhC3Yhh3YhT3YhwM4hCM4hhM4hTM4hwu4hCu4hhu4hTu4hwd4hCd4hhd4hTd4hw/4hC/4hh/4/QM2/id28uIEJAAAAABJRU5ErkJggg==');
        }
      </style>
      <div class="yt-gradient-bottom"></div>

      <!-- Settings Menu -->
      <style>
        media-settings-menu {
          position: absolute;
          border-radius: 12px;
          right: 12px;
          bottom: 61px;
          z-index: 70;
          will-change: width, height;
          text-shadow: 0 0 2px rgba(0, 0, 0, 0.5);
          transition: opacity 0.1s cubic-bezier(0, 0, 0.2, 1);
          user-select: none;
          --media-settings-menu-min-width: 220px;
        }
        [mediaisfullscreen] media-settings-menu {
          --media-settings-menu-min-width: 320px;
          right: 24px;
          bottom: 70px;
        }
        media-settings-menu-item {
          height: 40px;
          font-size: 13px;
          font-weight: 500;
          padding-top: 0;
          padding-bottom: 0;
        }

        [mediaisfullscreen] media-settings-menu-item {
          font-size: 20px;
          height: 50px;
        }
      </style>
      <media-settings-menu hidden anchor="auto">
        <media-settings-menu-item>
          Playback Speed
          <media-playback-rate-menu slot="submenu" hidden>
            <div slot="title">Playback Speed</div>
          </media-playback-rate-menu>
        </media-settings-menu-item>
        <media-settings-menu-item>
          Quality
          <media-rendition-menu slot="submenu" hidden>
            <div slot="title">Quality</div>
          </media-rendition-menu>
        </media-settings-menu-item>
        <media-settings-menu-item>
          Subtitles/CC
          <media-captions-menu slot="submenu" hidden>
            <div slot="title">Subtitles/CC</div>
          </media-captions-menu>
        </media-settings-menu-item>
      </media-settings-menu>

      <!-- Time Range / Progress Bar -->
      <style>
        media-time-range {
          position: absolute;
          bottom: 36px;
          width: 100%;
          height: 5px;
          --media-range-track-transition: height 0.1s linear;
          --media-range-track-background: rgba(255, 255, 255, 0.2);
          --media-range-track-pointer-background: rgba(255, 255, 255, 0.5);
          --media-time-range-buffered-color: rgba(255, 255, 255, 0.4);
          --media-range-bar-color: var(--media-accent-color, rgb(229, 9, 20));
          --media-range-thumb-border-radius: 13px;
          --media-range-thumb-background: var(--media-accent-color, #f00);
          --media-range-thumb-transition: transform 0.1s linear;
          --media-range-thumb-transform: scale(0) translate(0%, 0%);
        }
        media-time-range:hover {
          --media-range-track-height: 5px;
          --media-range-thumb-transform: scale(1) translate(0%, 0%);
        }
        [breakpointmd] media-time-range {
          bottom: 47px;
        }
        [mediaisfullscreen] media-time-range {
          bottom: 52.5px;
          height: 8px;
        }
        [mediaisfullscreen] media-time-range:hover {
          --media-range-track-height: 8px;
        }
      </style>
      <media-time-range>
        <media-preview-thumbnail slot="preview"></media-preview-thumbnail>
        <media-preview-time-display slot="preview"></media-preview-time-display>
      </media-time-range>

      <!-- Control Bar -->
      <style>
        media-control-bar {
          position: absolute;
          height: 36px;
          line-height: 36px;
          bottom: 0;
          left: 12px;
          right: 12px;
        }
        [breakpointmd] media-control-bar {
          height: 48px;
          line-height: 48px;
        }
        [mediaisfullscreen] media-control-bar {
          height: 54px;
          line-height: 54px;
        }
      </style>
      <media-control-bar>
        <!-- Play/Pause -->
        <style>
          media-play-button {
            --media-button-icon-width: 30px;
            padding: 6px 10px;
          }

          media-play-button :is(#play-p1, #play-p2, #pause-p1, #pause-p2) {
            transition: clip-path 0.25s ease-in;
          }

          /* Slow down the play icon part hiding slightly
              to achieve the morphing look a little better */
          media-play-button:not([mediapaused]) #play-p2,
          media-play-button:not([mediapaused]) #play-p2 {
            transition: clip-path 0.35s ease-in;
          }

          /* Show icon */
          media-play-button :is(#pause-p1, #pause-p2),
          media-play-button[mediapaused] :is(#play-p1, #play-p2) {
            clip-path: inset(0);
          }

          /* Hide icon wth clip path mask */
          media-play-button #play-p1 {
            clip-path: inset(0 100% 0 0);
          }
          media-play-button #play-p2 {
            clip-path: inset(0 20% 0 100%);
          }
          media-play-button[mediapaused] #pause-p1 {
            clip-path: inset(50% 0 50% 0);
          }
          media-play-button[mediapaused] #pause-p2 {
            clip-path: inset(50% 0 50% 0);
          }
        </style>
        <media-play-button mediapaused class="yt-button">
          <svg slot="icon" viewBox="0 0 36 36">
            <use class="svg-shadow" xlink:href="#icon-play"></use>
            <g id="icon-play">
              <path id="play-p1" d="M18.5 14L12 10V26L18.5 22V14Z" />
              <path id="play-p2" d="M18 13.6953L25 18L18 22.3086V13.6953Z" />
              <path id="pause-p1" d="M16 10H12V26H16V10Z" />
              <path id="pause-p2" d="M21 10H25V26H21V10Z" />
            </g>
          </svg>
        </media-play-button>

        <!-- Volume/Mute -->
        <style>
          media-mute-button :is(#icon-muted, #icon-volume) {
            transition: clip-path 0.3s ease-out;
          }
          media-mute-button #icon-muted {
            clip-path: inset(0 0 100% 0);
          }
          media-mute-button[mediavolumelevel='off'] #icon-muted {
            clip-path: inset(0);
          }
          media-mute-button #icon-volume {
            clip-path: inset(0);
          }
          media-mute-button[mediavolumelevel='off'] #icon-volume {
            clip-path: inset(100% 0 0 0);
          }

          media-mute-button #volume-high,
          media-mute-button[mediavolumelevel='off'] #volume-high {
            opacity: 1;
            transition: opacity 0.3s;
          }
          media-mute-button[mediavolumelevel='low'] #volume-high,
          media-mute-button[mediavolumelevel='medium'] #volume-high {
            opacity: 0.2;
          }

          media-volume-range {
            height: 36px;
            --media-range-track-background: rgba(255, 255, 255, 0.2);
          }

          media-mute-button + media-volume-range {
            width: 0;
            overflow: hidden;
            transition: width 0.2s ease-in;
          }

          /* Expand volume control in all relevant states */
          media-mute-button:hover + media-volume-range,
          media-mute-button:focus + media-volume-range,
          media-mute-button:focus-within + media-volume-range,
          media-volume-range:hover,
          media-volume-range:focus,
          media-volume-range:focus-within {
            width: 70px;
          }
        </style>
        <media-mute-button class="yt-button">
          <svg slot="icon" viewBox="0 0 36 36">
            <g id="icon-volume">
              <path id="speaker" d="M13 15H9V21H13L18 26V10L13 15Z" />
              <path
                id="volume-low"
                d="M20 22.0323C21.4818 21.2959 22.5 19.7669 22.5 18C22.5 16.2332 21.4818 14.7041 20 13.9678V22.0323Z"
              />
              <path
                id="volume-high"
                d="M20 9.22302V11.2899C22.8915 12.1505 25 14.829 25 18C25 21.171 22.8915 23.8495 20 24.7101V26.777C24.008 25.8675 27 22.2832 27 18C27 13.7168 24.008 10.1325 20 9.22302Z"
              />
            </g>
            <g id="icon-muted">
              <path
                d="M10.2207 8.80817L8.80762 10.2213L13.2929 14.7065L13 14.9995H9V20.9995H13L18 25.9995V19.4136L22.1922 23.6058C21.5401 24.0942 20.8 24.4715 20 24.7096V26.7764C21.3453 26.4712 22.5761 25.8646 23.6177 25.0314L25.7782 27.1918L27.1924 25.7776L27.1913 25.7766L27.1902 25.7776L10.2207 8.80817Z"
              />
              <path
                d="M25.8817 22.3478C26.5944 21.0589 27 19.5766 27 17.9995C27 13.7163 24.008 10.132 20 9.22247V11.2894C22.8915 12.1499 25 14.8284 25 17.9995C25 19.0177 24.7826 19.9851 24.3917 20.8578L25.8817 22.3478Z"
              />
              <path
                d="M22.4139 18.88C22.4704 18.5952 22.5 18.3008 22.5 17.9995C22.5 16.2326 21.4818 14.7036 20 13.9672V16.4661L22.4139 18.88Z"
              />
              <path d="M18 14.4661V9.99945L15.7667 12.2328L18 14.4661Z" />
            </g>
          </svg>
        </media-mute-button>
        <media-volume-range></media-volume-range>

        <!-- Time Display -->
        <style>
          media-time-display {
            padding-top: 6px;
            padding-bottom: 6px;
            font-size: 13px;
          }

          [mediaisfullscreen] media-time-display {
            font-size: 20px;
          }
        </style>
        <media-time-display showduration></media-time-display>

        <!-- Control Spacer -->
        <style>
          .control-spacer {
            flex-grow: 1;
          }
        </style>
        <span class="control-spacer"></span>

        <!-- Subtitles/CC Button -->
        <style>
          media-captions-button {
            position: relative;
          }

          /* Disble the captions button when no subtitles are available */
          media-captions-button:not([mediasubtitleslist]) svg {
            opacity: 0.3;
          }

          media-captions-button[mediasubtitleslist]:after {
            content: '';
            display: block;
            position: absolute;
            width: 0;
            height: 3px;
            border-radius: 3px;
            background-color: #f00;
            bottom: 19%;
            left: 50%;
            transition: all 0.1s cubic-bezier(0, 0, 0.2, 1), width 0.1s cubic-bezier(0, 0, 0.2, 1);
          }

          media-captions-button[mediasubtitleslist][aria-checked='true']:after {
            left: 25%;
            width: 50%;
            transition: left 0.25s cubic-bezier(0, 0, 0.2, 1), width 0.25s cubic-bezier(0, 0, 0.2, 1);
          }

          media-captions-button[mediasubtitleslist][aria-checked='true']:after {
            left: 25%;
            width: 50%;

            transition: left 0.25s cubic-bezier(0, 0, 0.2, 1), width 0.25s cubic-bezier(0, 0, 0.2, 1);
          }
        </style>
        <media-captions-button class="yt-button">
          <svg slot="icon" viewBox="0 0 36 36">
            <use class="svg-shadow" xlink:href="#cc-icon"></use>
            <path
              id="cc-icon"
              d="M9 13.4124C9 12.0801 10.0801 11 11.4124 11H24.5876C25.9199 11 27 12.0801 27 13.4124V22.5876C27 23.9199 25.9199 25 24.5876 25H11.4124C10.0801 25 9 23.9199 9 22.5876V13.4124ZM12 16.1134C12 15.4985 12.4985 15 13.1134 15H15.8866C16.5015 15 17 15.4985 17 16.1134V19.8866C17 20.5015 16.5015 21 15.8866 21H13.1134C12.4985 21 12 20.5015 12 19.8866V16.1134ZM13.5517 16.4545H15.4483V19.5455H13.5517V16.4545ZM17 17H15.4483V19H17V17ZM20.1134 15C19.4985 15 19 15.4985 19 16.1134V19.8866C19 20.5015 19.4985 21 20.1134 21H22.8866C23.5015 21 24 20.5015 24 19.8866V16.1134C24 15.4985 23.5015 15 22.8866 15H20.1134ZM22.4483 16.4545H20.5517V19.5455H22.4483V16.4545ZM22.4483 17H24V19H22.4483V17Z"
            />
          </svg>
        </media-captions-button>

        <!-- Settings Menu Button -->
        <style>
          media-settings-menu-button svg {
            transition: transform 0.1s cubic-bezier(0.4, 0, 1, 1);
            transform: rotateZ(0deg);
          }
          media-settings-menu-button[aria-expanded='true'] svg {
            transform: rotateZ(30deg);
          }
        </style>
        <media-settings-menu-button class="yt-button">
          <svg slot="icon" viewBox="0 0 36 36">
            <use class="svg-shadow" xlink:href="#settings-icon"></use>
            <path
              id="settings-icon"
              d="M11.8153 12.0477L14.2235 12.9602C14.6231 12.6567 15.0599 12.3996 15.5258 12.1971L15.9379 9.66561C16.5985 9.50273 17.2891 9.41632 18 9.41632C18.7109 9.41632 19.4016 9.50275 20.0622 9.66566L20.4676 12.1555C20.9584 12.3591 21.418 12.6227 21.8372 12.9372L24.1846 12.0477C25.1391 13.0392 25.8574 14.2597 26.249 15.6186L24.3196 17.1948C24.3531 17.4585 24.3704 17.7272 24.3704 18C24.3704 18.2727 24.3531 18.5415 24.3196 18.8051L26.249 20.3814C25.8574 21.7403 25.1391 22.9607 24.1846 23.9522L21.8372 23.0628C21.4179 23.3772 20.9584 23.6408 20.4676 23.8445L20.0622 26.3343C19.4016 26.4972 18.7109 26.5836 18 26.5836C17.2891 26.5836 16.5985 26.4972 15.9379 26.3344L15.5258 23.8029C15.0599 23.6003 14.6231 23.3433 14.2236 23.0398L11.8154 23.9523C10.8609 22.9608 10.1426 21.7404 9.75098 20.3815L11.7633 18.7375C11.7352 18.4955 11.7208 18.2495 11.7208 18C11.7208 17.7505 11.7352 17.5044 11.7633 17.2625L9.75098 15.6185C10.1426 14.2596 10.8609 13.0392 11.8153 12.0477ZM18 20.75C19.5188 20.75 20.75 19.5188 20.75 18C20.75 16.4812 19.5188 15.25 18 15.25C16.4812 15.25 15.25 16.4812 15.25 18C15.25 19.5188 16.4812 20.75 18 20.75Z"
            />
          </svg>
        </media-settings-menu-button>

        <!-- PIP/Mini Player Button -->
        <media-pip-button class="yt-button">
          <svg slot="icon" viewBox="0 0 36 36">
            <use class="svg-shadow" xlink:href="#pip-icon"></use>
            <path d="M25 17H17V23H25V17Z" />
            <path
              id="pip-icon"
              d="M7 11C7 9.89543 7.89545 9 9 9H27.0161C28.1207 9 29.0161 9.89543 29.0161 11V24.8837C29.0161 25.9883 28.1207 26.8837 27.0162 26.8837H9C7.89545 26.8837 7 25.9883 7 24.8837V11ZM9 11H27V25H9V11Z"
            />
          </svg>
        </media-pip-button>

        <!-- Fullscreen Button -->
        <style>
          /* Having trouble getting @property to work in the shadow dom
             to clean this up. Like https://codepen.io/luwes/pen/oNRyZyx */

          media-fullscreen-button path {
            translate: 0% 0%;
          }
          media-fullscreen-button:hover path {
            animation: 0.35s up-left-bounce cubic-bezier(0.34, 1.56, 0.64, 1);
          }
          media-fullscreen-button:hover .urbounce {
            animation-name: up-right-bounce;
          }
          media-fullscreen-button:hover .dlbounce {
            animation-name: down-left-bounce;
          }
          media-fullscreen-button:hover .drbounce {
            animation-name: down-right-bounce;
          }

          @keyframes up-left-bounce {
            0% {
              translate: 0 0;
            }
            50% {
              translate: -4% -4%;
            }
          }
          @keyframes up-right-bounce {
            0% {
              translate: 0 0;
            }
            50% {
              translate: 4% -4%;
            }
          }
          @keyframes down-left-bounce {
            0% {
              translate: 0 0;
            }
            50% {
              translate: -4% 4%;
            }
          }
          @keyframes down-right-bounce {
            0% {
              translate: 0 0;
            }
            50% {
              translate: 4% 4%;
            }
          }
        </style>
        <media-fullscreen-button class="yt-button">
          <svg slot="enter" viewBox="0 0 36 36">
            <use class="svg-shadow" xlink:href="#fs-enter-paths"></use>
            <g id="fs-enter-paths">
              <path class="ulbounce" d="M11 15H9V9H15V11H11V15Z" />
              <path class="urbounce" d="M21 11L21 9L27 9L27 15L25 15L25 11L21 11Z" />
              <path class="dlbounce" d="M15 25L15 27L9 27L9 21L11 21L11 25L15 25Z" />
              <path class="drbounce" d="M25 21L27 21L27 27L21 27L21 25L25 25L25 21Z" />
            </g>
          </svg>
          <svg slot="exit" viewBox="0 0 36 36">
            <use class="svg-shadow" xlink:href="#fs-exit-paths"></use>
            <g id="fs-exit-paths">
              <path class="drbounce" d="M14 9L16 9L16 16L9 16L9 14L14 14L14 9Z" />
              <path class="dlbounce" d="M27 14L27 16L20 16L20 9L22 9L22 14L27 14Z" />
              <path class="urbounce" d="M9 22L9 20L16 20L16 27L14 27L14 22L9 22Z" />
              <path class="ulbounce" d="M22 27H20V20H27V22H22V27Z" />
            </g>
          </svg>
        </media-fullscreen-button>
      </media-control-bar>
    </media-controller>

  `;
}

class MediaThemeYtElement extends MediaThemeElement {
  static template = template;
}

if (globalThis.customElements && !globalThis.customElements.get('media-theme-yt')) {
  globalThis.customElements.define('media-theme-yt', MediaThemeYtElement);
}

export default MediaThemeYtElement;
