import { isObject } from 'motion-utils';

/**
 * Checks if an element is an SVG element in a way
 * that works across iframes
 */
function isSVGElement(element) {
    return isObject(element) && "ownerSVGElement" in element;
}

export { isSVGElement };
//# sourceMappingURL=is-svg-element.mjs.map
