import { frame, cancelFrame } from '../frameloop/frame.mjs';
import { numberValueTypes } from '../value/types/maps/number.mjs';
import { getValueAsType } from '../value/types/utils/get-as-type.mjs';

class MotionValueState {
    constructor() {
        this.latest = {};
        this.values = new Map();
    }
    set(name, value, render, computed, useDefaultValueType = true) {
        const existingValue = this.values.get(name);
        if (existingValue) {
            existingValue.onRemove();
        }
        const onChange = () => {
            const v = value.get();
            if (useDefaultValueType) {
                this.latest[name] = getValueAsType(v, numberValueTypes[name]);
            }
            else {
                this.latest[name] = v;
            }
            render && frame.render(render);
        };
        onChange();
        const cancelOnChange = value.on("change", onChange);
        computed && value.addDependent(computed);
        const remove = () => {
            cancelOnChange();
            render && cancelFrame(render);
            this.values.delete(name);
            computed && value.removeDependent(computed);
        };
        this.values.set(name, { value, onRemove: remove });
        return remove;
    }
    get(name) {
        return this.values.get(name)?.value;
    }
    destroy() {
        for (const value of this.values.values()) {
            value.onRemove();
        }
    }
}

export { MotionValueState };
//# sourceMappingURL=MotionValueState.mjs.map
