import ___default from 'lodash';
import { has, union, getOr } from 'lodash/fp';

const SINGLE_TYPE = 'singleType';
const COLLECTION_TYPE = 'collectionType';
const ID_ATTRIBUTE = 'id';
const DOC_ID_ATTRIBUTE = 'documentId';
const PUBLISHED_AT_ATTRIBUTE = 'publishedAt';
const FIRST_PUBLISHED_AT_ATTRIBUTE = 'firstPublishedAt';
const CREATED_BY_ATTRIBUTE = 'createdBy';
const UPDATED_BY_ATTRIBUTE = 'updatedBy';
const CREATED_AT_ATTRIBUTE = 'createdAt';
const UPDATED_AT_ATTRIBUTE = 'updatedAt';
const constants = {
    ID_ATTRIBUTE,
    DOC_ID_ATTRIBUTE,
    PUBLISHED_AT_ATTRIBUTE,
    FIRST_PUBLISHED_AT_ATTRIBUTE,
    CREATED_BY_ATTRIBUTE,
    UPDATED_BY_ATTRIBUTE,
    CREATED_AT_ATTRIBUTE,
    UPDATED_AT_ATTRIBUTE,
    SINGLE_TYPE,
    COLLECTION_TYPE
};
const getTimestamps = (model)=>{
    const attributes = [];
    if (has(CREATED_AT_ATTRIBUTE, model.attributes)) {
        attributes.push(CREATED_AT_ATTRIBUTE);
    }
    if (has(UPDATED_AT_ATTRIBUTE, model.attributes)) {
        attributes.push(UPDATED_AT_ATTRIBUTE);
    }
    return attributes;
};
const getCreatorFields = (model)=>{
    const attributes = [];
    if (has(CREATED_BY_ATTRIBUTE, model.attributes)) {
        attributes.push(CREATED_BY_ATTRIBUTE);
    }
    if (has(UPDATED_BY_ATTRIBUTE, model.attributes)) {
        attributes.push(UPDATED_BY_ATTRIBUTE);
    }
    return attributes;
};
const getNonWritableAttributes = (model)=>{
    if (!model) return [];
    const nonWritableAttributes = ___default.reduce(model.attributes, (acc, attr, attrName)=>attr.writable === false ? acc.concat(attrName) : acc, []);
    return ___default.uniq([
        ID_ATTRIBUTE,
        DOC_ID_ATTRIBUTE,
        ...getTimestamps(model),
        ...nonWritableAttributes
    ]);
};
const getWritableAttributes = (model)=>{
    if (!model) return [];
    return ___default.difference(Object.keys(model.attributes), getNonWritableAttributes(model));
};
const isWritableAttribute = (model, attributeName)=>{
    return getWritableAttributes(model).includes(attributeName);
};
const getNonVisibleAttributes = (model)=>{
    const nonVisibleAttributes = ___default.reduce(model.attributes, (acc, attr, attrName)=>attr.visible === false ? acc.concat(attrName) : acc, []);
    return ___default.uniq([
        ID_ATTRIBUTE,
        DOC_ID_ATTRIBUTE,
        PUBLISHED_AT_ATTRIBUTE,
        ...getTimestamps(model),
        ...nonVisibleAttributes
    ]);
};
const getVisibleAttributes = (model)=>{
    return ___default.difference(___default.keys(model.attributes), getNonVisibleAttributes(model));
};
const isVisibleAttribute = (model, attributeName)=>{
    return getVisibleAttributes(model).includes(attributeName);
};
const getOptions = (model)=>___default.assign({
        draftAndPublish: false
    }, ___default.get(model, 'options', {}));
const hasDraftAndPublish = (model)=>___default.get(model, 'options.draftAndPublish', false) === true;
const hasFirstPublishedAtField = (model)=>strapi.config.get('features.future.experimental_firstPublishedAt', false) && hasDraftAndPublish(model);
const isDraft = (data, model)=>hasDraftAndPublish(model) && ___default.get(data, PUBLISHED_AT_ATTRIBUTE) === null;
const isSchema = (data)=>{
    return typeof data === 'object' && data !== null && 'modelType' in data && typeof data.modelType === 'string' && [
        'component',
        'contentType'
    ].includes(data.modelType);
};
const isComponentSchema = (data)=>{
    return isSchema(data) && data.modelType === 'component';
};
const isContentTypeSchema = (data)=>{
    return isSchema(data) && data.modelType === 'contentType';
};
const isSingleType = ({ kind = COLLECTION_TYPE })=>kind === SINGLE_TYPE;
const isCollectionType = ({ kind = COLLECTION_TYPE })=>kind === COLLECTION_TYPE;
const isKind = (kind)=>(model)=>model.kind === kind;
const getStoredPrivateAttributes = (model)=>union(strapi?.config?.get('api.responses.privateAttributes', []) ?? [], getOr([], 'options.privateAttributes', model));
const getPrivateAttributes = (model)=>{
    return ___default.union(getStoredPrivateAttributes(model), ___default.keys(___default.pickBy(model.attributes, (attr)=>!!attr.private)));
};
const isPrivateAttribute = (model, attributeName)=>{
    if (model?.attributes?.[attributeName]?.private === true) {
        return true;
    }
    return getStoredPrivateAttributes(model).includes(attributeName);
};
const isScalarAttribute = (attribute)=>{
    return attribute && ![
        'media',
        'component',
        'relation',
        'dynamiczone'
    ].includes(attribute.type);
};
const getDoesAttributeRequireValidation = (attribute)=>{
    return attribute.required || attribute.unique || Object.prototype.hasOwnProperty.call(attribute, 'max') || Object.prototype.hasOwnProperty.call(attribute, 'min') || Object.prototype.hasOwnProperty.call(attribute, 'maxLength') || Object.prototype.hasOwnProperty.call(attribute, 'minLength');
};
const isMediaAttribute = (attribute)=>attribute?.type === 'media';
const isRelationalAttribute = (attribute)=>attribute?.type === 'relation';
const HAS_RELATION_REORDERING = [
    'manyToMany',
    'manyToOne',
    'oneToMany'
];
const hasRelationReordering = (attribute)=>isRelationalAttribute(attribute) && HAS_RELATION_REORDERING.includes(attribute.relation);
const isComponentAttribute = (attribute)=>[
        'component',
        'dynamiczone'
    ].includes(attribute?.type);
const isDynamicZoneAttribute = (attribute)=>!!attribute && attribute.type === 'dynamiczone';
const isMorphToRelationalAttribute = (attribute)=>{
    return !!attribute && isRelationalAttribute(attribute) && attribute.relation?.startsWith?.('morphTo');
};
const getComponentAttributes = (schema)=>{
    return ___default.reduce(schema.attributes, (acc, attr, attrName)=>{
        if (isComponentAttribute(attr)) acc.push(attrName);
        return acc;
    }, []);
};
const getMediaAttributes = (schema)=>{
    return ___default.reduce(schema.attributes, (acc, attr, attrName)=>{
        if (isMediaAttribute(attr)) acc.push(attrName);
        return acc;
    }, []);
};
const getScalarAttributes = (schema)=>{
    return ___default.reduce(schema.attributes, (acc, attr, attrName)=>{
        if (isScalarAttribute(attr)) acc.push(attrName);
        return acc;
    }, []);
};
const getRelationalAttributes = (schema)=>{
    return ___default.reduce(schema.attributes, (acc, attr, attrName)=>{
        if (isRelationalAttribute(attr)) acc.push(attrName);
        return acc;
    }, []);
};
/**
 * Checks if an attribute is of type `type`
 * @param {object} attribute
 * @param {string} type
 */ const isTypedAttribute = (attribute, type)=>{
    return ___default.has(attribute, 'type') && attribute.type === type;
};
/**
 *  Returns a route prefix for a contentType
 * @param {object} contentType
 * @returns {string}
 */ const getContentTypeRoutePrefix = (contentType)=>{
    return isSingleType(contentType) ? ___default.kebabCase(contentType.info.singularName) : ___default.kebabCase(contentType.info.pluralName);
};

export { constants, getComponentAttributes, getContentTypeRoutePrefix, getCreatorFields, getDoesAttributeRequireValidation, getMediaAttributes, getNonVisibleAttributes, getNonWritableAttributes, getOptions, getPrivateAttributes, getRelationalAttributes, getScalarAttributes, getTimestamps, getVisibleAttributes, getWritableAttributes, hasDraftAndPublish, hasFirstPublishedAtField, hasRelationReordering, isCollectionType, isComponentAttribute, isComponentSchema, isContentTypeSchema, isDraft, isDynamicZoneAttribute, isKind, isMediaAttribute, isMorphToRelationalAttribute, isPrivateAttribute, isRelationalAttribute, isScalarAttribute, isSchema, isSingleType, isTypedAttribute, isVisibleAttribute, isWritableAttribute };
//# sourceMappingURL=content-types.mjs.map
