import { errors } from '@strapi/utils';
type SortOrder = 'ASC' | 'DESC';
type SortKey = 'createdAt' | 'name' | 'updatedAt';
type ComparisonOperators<T> = {
    [operator: string]: T | T[] | boolean;
};
export type FilterCondition<T> = {
    [field: string]: T | ComparisonOperators<T> | FilterCondition<T>;
};
type Filters<T> = {
    [logicOperator: string]: FilterCondition<T>[];
};
export type Query = {
    _q?: string;
    folderPath?: string;
    folder?: null | number | {
        id: number;
    };
    page?: string | number | {
        id: string | number;
    };
    pageSize?: string | number;
    pagination?: {
        pageSize: number;
    };
    sort?: `${SortKey}:${SortOrder}`;
    filters?: Filters<string | number | boolean>;
    state?: boolean;
};
type FileFormat = {
    name: string;
    hash: string;
    ext: string;
    mime: string;
    path: null | string;
    width: number;
    height: number;
    size: number;
    sizeInBytes: number;
    url: string;
};
export interface File {
    id: number;
    name: string;
    alternativeText?: string | null;
    caption?: string | null;
    width?: number | null;
    height?: number | null;
    formats?: Record<string, FileFormat> | {
        thumbnail: {
            url: string;
        };
    } | null;
    hash: string;
    ext?: string;
    mime?: string;
    size?: number;
    sizeInBytes?: number;
    url?: string;
    previewUrl?: string | null;
    path?: string | null;
    provider?: string;
    provider_metadata?: Record<string, unknown> | null;
    isUrlSigned?: boolean;
    folder?: number | string | null;
    folderPath?: string;
    related?: {
        id: string | number;
        __type: string;
        __pivot: {
            field: string;
        };
    }[];
    createdAt?: string;
    updatedAt?: string;
    createdBy?: number;
    publishedAt?: string;
    updatedBy?: number;
    isLocal?: boolean;
}
export interface RawFile extends Blob {
    size: number;
    lastModified: number;
    name: string;
    type: string;
}
export interface Pagination {
    page: number;
    pageSize: number;
    pageCount: number;
    total: number;
}
/**
 * GET /upload/files - Get files
 */
export declare namespace GetFiles {
    interface Request {
        body: {};
        query: {
            page?: string;
            pageSize?: string;
            folder: number | null;
            sort?: `${SortKey}:${SortOrder}`;
        };
    }
    interface Response {
        data: {
            results: File[];
            pagination: Pagination;
        };
        error?: errors.ApplicationError | errors.NotFoundError;
    }
}
/**
 * GET /upload/files/:id - Get specific file
 */
export declare namespace GetFile {
    interface Request {
        params: {
            id: number;
        };
        query: {};
    }
    interface Response {
        data: File;
        error?: errors.ApplicationError | errors.NotFoundError;
    }
}
/**
 * POST /upload/actions/bulk-delete - Delete Files
 */
export declare namespace BulkDeleteFiles {
    interface Request {
        body: {
            fileIds: number[];
        };
    }
    interface Response {
        data: {
            data: {
                files: File[];
                folders: [];
            };
        };
        error?: errors.ApplicationError | errors.ValidationError;
    }
}
/**
 * POST /upload/actions/bulk-move - Move Files
 */
export declare namespace BulkMoveFiles {
    interface Request {
        body: {
            fileIds: number[];
            destinationFolderId: number;
        };
    }
    interface Response {
        data: {
            data: {
                files: File[];
                folders: [];
            };
        };
        error?: errors.ApplicationError | errors.ValidationError;
    }
}
/**
 * DELETE /upload/files/:id - Delete a specific asset
 */
export declare namespace DeleteFile {
    interface Request {
        params: {
            id: number;
        };
        query: {};
    }
    interface Response {
        data: File;
        error?: errors.ApplicationError | errors.NotFoundError;
    }
}
/**
 * POST /upload - Create a file
 */
export declare namespace CreateFile {
    interface Request {
        body: FormData;
        files: File[];
    }
    interface Response {
        data: File[];
        error?: errors.ApplicationError | errors.ValidationError;
    }
}
/**
 * POST /upload?id=:id - Update asset
 */
export declare namespace UpdateFile {
    interface Request {
        body: FormData;
        params: {
            id: number;
        };
    }
    interface Response {
        data: File;
        error?: errors.ApplicationError | errors.ValidationError;
    }
}
/**
 * POST /upload/actions/bulk-update - Bulk update files
 */
export declare namespace BulkUpdateFiles {
    interface Request {
        body: {
            updates: Array<{
                id: number;
                fileInfo: {
                    name?: string;
                    alternativeText?: string | null;
                    caption?: string | null;
                    folder?: number | null;
                };
            }>;
        };
    }
    interface Response {
        data: File[];
        error?: errors.ApplicationError | errors.ValidationError;
    }
}
export {};
