import type { Core } from '@strapi/types';
export type SecurityConfig = {
    allowedTypes?: string[];
    deniedTypes?: string[];
};
type UploadValidationError = {
    code: 'MIME_TYPE_NOT_ALLOWED' | 'VALIDATION_ERROR' | 'UNKNOWN_ERROR';
    message: string;
    details: Record<string, any>;
};
type ValidationResult = {
    isValid: boolean;
    error?: UploadValidationError;
};
type ErrorDetail = {
    file: any;
    originalIndex: number;
    error: UploadValidationError;
};
export declare function detectMimeType(file: any): Promise<string | undefined>;
export declare function isMimeTypeAllowed(mimeType: string, config: SecurityConfig): boolean;
export declare function extractFileInfo(file: any): {
    fileName: any;
    declaredMimeType: any;
};
export declare function validateFile(file: any, config: SecurityConfig, strapi: Core.Strapi): Promise<ValidationResult>;
export declare function validateFiles(files: any, strapi: Core.Strapi): Promise<ValidationResult[]>;
export declare function enforceUploadSecurity(files: any, strapi: Core.Strapi): Promise<{
    validFiles: any[];
    validFileNames: string[];
    errors: Array<ErrorDetail>;
}>;
export {};
//# sourceMappingURL=mime-validation.d.ts.map