import type { Core } from '@strapi/types';
import type { File, InputFile, UploadableFile, FileInfo } from '../types';
import type { ViewConfiguration } from '../controllers/validation/admin/configureView';
import type { Settings } from '../controllers/validation/admin/settings';
type User = {
    id: string | number;
};
type ID = string | number;
type CommonOptions = {
    user?: User;
};
declare const _default: ({ strapi }: {
    strapi: Core.Strapi;
}) => {
    formatFileInfo: ({ filename, type, size }: {
        filename: string;
        type: string;
        size: number;
    }, fileInfo?: Partial<FileInfo>, metas?: {
        refId?: ID;
        ref?: string;
        field?: string;
        path?: string;
        tmpWorkingDirectory?: string;
    }) => Promise<Omit<UploadableFile, 'getStream'>>;
    upload: ({ data, files, }: {
        data: Record<string, unknown>;
        files: InputFile[];
    }, opts?: CommonOptions) => Promise<any[]>;
    updateFileInfo: (id: ID, { name, alternativeText, caption, folder }: FileInfo, opts?: CommonOptions) => Promise<any>;
    replace: (id: ID, { data, file }: {
        data: {
            fileInfo: FileInfo;
        };
        file: InputFile;
    }, opts?: CommonOptions) => Promise<any>;
    findOne: (id: ID, populate?: {}) => Promise<any>;
    findMany: (query?: any) => Promise<File[]>;
    findPage: (query?: any) => Promise<{
        results: any;
        pagination: {
            page: number;
            pageSize: number;
            pageCount: number;
            total: number;
        };
    }>;
    remove: (file: File) => Promise<any>;
    getSettings: () => Promise<import("yup/lib/object").AssertsShape<{
        sizeOptimization: import("yup/lib/boolean").RequiredBooleanSchema<boolean | undefined, Record<string, any>>;
        responsiveDimensions: import("yup/lib/boolean").RequiredBooleanSchema<boolean | undefined, Record<string, any>>;
        autoOrientation: import("yup").BooleanSchema<boolean | undefined, Record<string, any>, boolean | undefined>;
        aiMetadata: import("yup").BooleanSchema<boolean, Record<string, any>, boolean>;
    }> | null>;
    setSettings: (value: Settings) => Promise<void>;
    getConfiguration: () => Promise<import("yup/lib/object").AssertsShape<{
        pageSize: import("yup/lib/number").RequiredNumberSchema<number | undefined, Record<string, any>>;
        sort: import("yup/lib/mixed").MixedSchema<any, Record<string, any>, any>;
    }> | null>;
    setConfiguration: (value: ViewConfiguration) => Promise<void>;
    /**
     * exposed for testing only
     * @internal
     */
    _uploadImage: (fileData: UploadableFile) => Promise<void>;
};
export default _default;
//# sourceMappingURL=upload.d.ts.map