export declare const services: {
    provider: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        checkFileSize(file: import("../types").UploadableFile): Promise<void>;
        upload(file: import("../types").UploadableFile): Promise<void>;
    };
    upload: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        formatFileInfo: ({ filename, type, size }: {
            filename: string;
            type: string;
            size: number;
        }, fileInfo?: Partial<import("../types").FileInfo>, metas?: {
            refId?: (string | number) | undefined;
            ref?: string | undefined;
            field?: string | undefined;
            path?: string | undefined;
            tmpWorkingDirectory?: string | undefined;
        }) => Promise<Omit<import("../types").UploadableFile, "getStream">>;
        upload: ({ data, files, }: {
            data: Record<string, unknown>;
            files: import("../types").InputFile[];
        }, opts?: {
            user?: {
                id: string | number;
            } | undefined;
        } | undefined) => Promise<any[]>;
        updateFileInfo: (id: string | number, { name, alternativeText, caption, folder }: import("../types").FileInfo, opts?: {
            user?: {
                id: string | number;
            } | undefined;
        } | undefined) => Promise<any>;
        replace: (id: string | number, { data, file }: {
            data: {
                fileInfo: import("../types").FileInfo;
            };
            file: import("../types").InputFile;
        }, opts?: {
            user?: {
                id: string | number;
            } | undefined;
        } | undefined) => Promise<any>;
        findOne: (id: string | number, populate?: {}) => Promise<any>;
        findMany: (query?: any) => Promise<import("../types").File[]>;
        findPage: (query?: any) => Promise<{
            results: any;
            pagination: {
                page: number;
                pageSize: number;
                pageCount: number;
                total: number;
            };
        }>;
        remove: (file: import("../types").File) => Promise<any>;
        getSettings: () => Promise<import("yup/lib/object").AssertsShape<{
            sizeOptimization: import("yup/lib/boolean").RequiredBooleanSchema<boolean | undefined, Record<string, any>>;
            responsiveDimensions: import("yup/lib/boolean").RequiredBooleanSchema<boolean | undefined, Record<string, any>>;
            autoOrientation: import("yup").BooleanSchema<boolean | undefined, Record<string, any>, boolean | undefined>;
            aiMetadata: import("yup").BooleanSchema<boolean, Record<string, any>, boolean>;
        }> | null>;
        setSettings: (value: import("yup/lib/object").AssertsShape<{
            sizeOptimization: import("yup/lib/boolean").RequiredBooleanSchema<boolean | undefined, Record<string, any>>;
            responsiveDimensions: import("yup/lib/boolean").RequiredBooleanSchema<boolean | undefined, Record<string, any>>;
            autoOrientation: import("yup").BooleanSchema<boolean | undefined, Record<string, any>, boolean | undefined>;
            aiMetadata: import("yup").BooleanSchema<boolean, Record<string, any>, boolean>;
        }>) => Promise<void>;
        getConfiguration: () => Promise<import("yup/lib/object").AssertsShape<{
            pageSize: import("yup/lib/number").RequiredNumberSchema<number | undefined, Record<string, any>>;
            sort: import("yup/lib/mixed").MixedSchema<any, Record<string, any>, any>;
        }> | null>;
        setConfiguration: (value: import("yup/lib/object").AssertsShape<{
            pageSize: import("yup/lib/number").RequiredNumberSchema<number | undefined, Record<string, any>>;
            sort: import("yup/lib/mixed").MixedSchema<any, Record<string, any>, any>;
        }>) => Promise<void>;
        _uploadImage: (fileData: import("../types").UploadableFile) => Promise<void>;
    };
    folder: {
        create: (folderData: Pick<import("../types").Folder, "name" | "parent">, opts?: {
            user: {
                id: string | number;
            };
        } | undefined) => Promise<any>;
        exists: (params?: {}) => Promise<boolean>;
        deleteByIds: (ids?: never[]) => Promise<{
            folders: any[];
            totalFolderNumber: number;
            totalFileNumber: number;
        }>;
        update: (id: number, { name, parent, }: {
            name: string;
            parent: number | null;
        }, { user }: {
            user: {
                id: string | number;
            };
        }) => Promise<any>;
        setPathIdAndPath: (folder: Pick<import("../types").Folder, "parent">) => Promise<Pick<import("../types").Folder, "parent"> & {
            pathId: number;
            path: string;
        }>;
        getStructure: () => Promise<number[] & (Partial<import("../types").Folder> & {
            children: (Partial<import("../types").Folder> & any)[];
        })[]>;
    };
    file: {
        getFolderPath: (folderId?: number | null | undefined) => Promise<any>;
        deleteByIds: (ids?: number[]) => Promise<any[]>;
        signFileUrls: (file: import("../types").File) => Promise<import("../types").File>;
    };
    weeklyMetrics: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        computeMetrics(): Promise<{
            assetNumber: number;
            folderNumber: number;
            averageDepth: number;
            maxDepth: number;
            averageDeviationDepth: number;
        }>;
        sendMetrics(): Promise<void>;
        ensureWeeklyStoredCronSchedule(): Promise<string>;
        registerCron(): Promise<void>;
    };
    metrics: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        trackUsage(event: string, properties?: Record<string, any> | undefined): Promise<boolean>;
        sendUploadPluginMetrics(): Promise<void>;
    };
    'image-manipulation': {
        isFaultyImage: (file: import("../types").UploadableFile) => Promise<unknown>;
        isOptimizableImage: (file: import("../types").UploadableFile) => Promise<boolean | undefined>;
        isResizableImage: (file: import("../types").UploadableFile) => Promise<boolean | undefined>;
        isImage: (file: import("../types").UploadableFile) => Promise<boolean | undefined>;
        getDimensions: (file: import("../types").UploadableFile) => Promise<{
            width: number | null;
            height: number | null;
        }>;
        generateResponsiveFormats: (file: import("../types").UploadableFile) => Promise<({
            key: string;
            file: import("../types").UploadableFile;
        } | undefined)[]>;
        generateThumbnail: (file: import("../types").UploadableFile) => Promise<import("../types").UploadableFile | null>;
        optimize: (file: import("../types").UploadableFile) => Promise<import("../types").UploadableFile>;
        generateFileName: (name: string) => string;
    };
    'api-upload-folder': {
        getAPIUploadFolder: () => Promise<any>;
    };
    extensions: {
        signFileUrlsOnDocumentService: () => Promise<void>;
    };
    aiMetadata: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        isEnabled(): Promise<boolean>;
        processFiles(files: import("../types").InputFile[]): Promise<({
            altText: string;
            caption: string;
        } | null)[]>;
    };
};
//# sourceMappingURL=index.d.ts.map