/// <reference types="koa" />
import { register } from './register';
import { bootstrap } from './bootstrap';
declare const _default: () => {
    register: typeof register;
    bootstrap: typeof bootstrap;
    config: {
        default: {
            enabled: boolean;
            provider: string;
            sizeLimit: number;
            actionOptions: {};
        };
        validator(): void;
    };
    routes: {
        admin: {
            type: string;
            routes: {
                method: string;
                path: string;
                handler: string;
                config: {
                    policies: (string | {
                        name: string;
                        config: {
                            actions: string[];
                        };
                    })[];
                };
            }[];
        };
        'content-api': () => {
            type: "content-api";
            routes: import("@strapi/types/dist/core").RouteInput[];
        };
        viewConfiguration: {
            type: string;
            routes: {
                method: string;
                path: string;
                handler: string;
                config: {
                    policies: (string | {
                        name: string;
                        config: {
                            actions: string[];
                        };
                    })[];
                };
            }[];
        };
    };
    controllers: {
        'admin-file': {
            find(ctx: import("koa").Context): Promise<import("koa").Context | {
                results: any;
                pagination: {
                    page: number;
                    pageSize: number;
                    pageCount: number;
                    total: number;
                };
            }>;
            findOne(ctx: import("koa").Context): Promise<void>;
            destroy(ctx: import("koa").Context): Promise<void>;
        };
        'admin-folder': {
            findOne(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            find(ctx: import("koa").Context): Promise<void>;
            create(ctx: import("koa").Context): Promise<void>;
            update(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            getStructure(ctx: import("koa").Context): Promise<void>;
        };
        'admin-folder-file': {
            deleteMany(ctx: import("koa").Context): Promise<void>;
            moveMany(ctx: import("koa").Context): Promise<void>;
        };
        'admin-settings': {
            updateSettings(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            getSettings(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
        };
        'admin-upload': {
            bulkUpdateFileInfo(ctx: import("koa").Context): Promise<void>;
            updateFileInfo(ctx: import("koa").Context): Promise<void>;
            replaceFile(ctx: import("koa").Context): Promise<void>;
            uploadFiles(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            upload(ctx: import("koa").Context): Promise<void>;
        };
        'content-api': ({ strapi }: {
            strapi: import("@strapi/types/dist/core").Strapi;
        }) => {
            find(ctx: import("koa").Context): Promise<void>;
            findOne(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            destroy(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            updateFileInfo(ctx: import("koa").Context): Promise<void>;
            replaceFile(ctx: import("koa").Context): Promise<void>;
            uploadFiles(ctx: import("koa").Context): Promise<void>;
            upload(ctx: import("koa").Context): Promise<void>;
        };
        'view-configuration': {
            updateViewConfiguration(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            findViewConfiguration(ctx: import("koa").Context): Promise<void>;
        };
    };
    contentTypes: {
        file: {
            schema: {
                collectionName: string;
                info: {
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                    description: string;
                };
                options: {};
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                };
                attributes: {
                    name: {
                        type: "string";
                        configurable: false;
                        required: true;
                    };
                    alternativeText: {
                        type: "text";
                        configurable: false;
                    };
                    caption: {
                        type: "text";
                        configurable: false;
                    };
                    width: {
                        type: "integer";
                        configurable: false;
                    };
                    height: {
                        type: "integer";
                        configurable: false;
                    };
                    formats: {
                        type: "json";
                        configurable: false;
                    };
                    hash: {
                        type: "string";
                        configurable: false;
                        required: true;
                    };
                    ext: {
                        type: "string";
                        configurable: false;
                    };
                    mime: {
                        type: "string";
                        configurable: false;
                        required: true;
                    };
                    size: {
                        type: "decimal";
                        configurable: false;
                        required: true;
                    };
                    url: {
                        type: "text";
                        configurable: false;
                        required: true;
                    };
                    previewUrl: {
                        type: "text";
                        configurable: false;
                    };
                    provider: {
                        type: "string";
                        configurable: false;
                        required: true;
                    };
                    provider_metadata: {
                        type: "json";
                        configurable: false;
                    };
                    related: {
                        type: "relation";
                        relation: "morphToMany";
                        configurable: false;
                    };
                    folder: {
                        type: "relation";
                        relation: "manyToOne";
                        target: "plugin::upload.folder";
                        inversedBy: string;
                        private: true;
                    };
                    folderPath: {
                        type: "string";
                        minLength: number;
                        required: true;
                        private: true;
                        searchable: false;
                    };
                };
                indexes: {
                    name: string;
                    columns: string[];
                    type: null;
                }[];
            };
        };
        folder: {
            schema: {
                collectionName: string;
                info: {
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                };
                options: {};
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                };
                attributes: {
                    name: {
                        type: "string";
                        minLength: number;
                        required: true;
                    };
                    pathId: {
                        type: "integer";
                        unique: true;
                        required: true;
                    };
                    parent: {
                        type: "relation";
                        relation: "manyToOne";
                        target: "plugin::upload.folder";
                        inversedBy: string;
                    };
                    children: {
                        type: "relation";
                        relation: "oneToMany";
                        target: "plugin::upload.folder";
                        mappedBy: string;
                    };
                    files: {
                        type: "relation";
                        relation: "oneToMany";
                        target: "plugin::upload.file";
                        mappedBy: string;
                    };
                    path: {
                        type: "string";
                        minLength: number;
                        required: true;
                    };
                };
                indexes: {
                    name: string;
                    columns: string[];
                    type: string;
                }[];
            };
        };
    };
    services: {
        provider: ({ strapi }: {
            strapi: import("@strapi/types/dist/core").Strapi;
        }) => {
            checkFileSize(file: import("./types").UploadableFile): Promise<void>;
            upload(file: import("./types").UploadableFile): Promise<void>;
        };
        upload: ({ strapi }: {
            strapi: import("@strapi/types/dist/core").Strapi;
        }) => {
            formatFileInfo: ({ filename, type, size }: {
                filename: string;
                type: string;
                size: number;
            }, fileInfo?: Partial<import("./types").FileInfo>, metas?: {
                refId?: (string | number) | undefined;
                ref?: string | undefined;
                field?: string | undefined;
                path?: string | undefined;
                tmpWorkingDirectory?: string | undefined;
            }) => Promise<Omit<import("./types").UploadableFile, "getStream">>;
            upload: ({ data, files, }: {
                data: Record<string, unknown>;
                files: import("./types").InputFile[];
            }, opts?: {
                user?: {
                    id: string | number;
                } | undefined;
            } | undefined) => Promise<any[]>;
            updateFileInfo: (id: string | number, { name, alternativeText, caption, folder }: import("./types").FileInfo, opts?: {
                user?: {
                    id: string | number;
                } | undefined;
            } | undefined) => Promise<any>;
            replace: (id: string | number, { data, file }: {
                data: {
                    fileInfo: import("./types").FileInfo;
                };
                file: import("./types").InputFile;
            }, opts?: {
                user?: {
                    id: string | number;
                } | undefined;
            } | undefined) => Promise<any>;
            findOne: (id: string | number, populate?: {}) => Promise<any>;
            findMany: (query?: any) => Promise<import("./types").File[]>;
            findPage: (query?: any) => Promise<{
                results: any;
                pagination: {
                    page: number;
                    pageSize: number;
                    pageCount: number;
                    total: number;
                };
            }>;
            remove: (file: import("./types").File) => Promise<any>;
            getSettings: () => Promise<import("yup/lib/object").AssertsShape<{
                sizeOptimization: import("yup/lib/boolean").RequiredBooleanSchema<boolean | undefined, Record<string, any>>;
                responsiveDimensions: import("yup/lib/boolean").RequiredBooleanSchema<boolean | undefined, Record<string, any>>;
                autoOrientation: import("yup").BooleanSchema<boolean | undefined, Record<string, any>, boolean | undefined>;
                aiMetadata: import("yup").BooleanSchema<boolean, Record<string, any>, boolean>;
            }> | null>;
            setSettings: (value: import("yup/lib/object").AssertsShape<{
                sizeOptimization: import("yup/lib/boolean").RequiredBooleanSchema<boolean | undefined, Record<string, any>>;
                responsiveDimensions: import("yup/lib/boolean").RequiredBooleanSchema<boolean | undefined, Record<string, any>>;
                autoOrientation: import("yup").BooleanSchema<boolean | undefined, Record<string, any>, boolean | undefined>;
                aiMetadata: import("yup").BooleanSchema<boolean, Record<string, any>, boolean>;
            }>) => Promise<void>;
            getConfiguration: () => Promise<import("yup/lib/object").AssertsShape<{
                pageSize: import("yup/lib/number").RequiredNumberSchema<number | undefined, Record<string, any>>;
                sort: import("yup/lib/mixed").MixedSchema<any, Record<string, any>, any>;
            }> | null>;
            setConfiguration: (value: import("yup/lib/object").AssertsShape<{
                pageSize: import("yup/lib/number").RequiredNumberSchema<number | undefined, Record<string, any>>;
                sort: import("yup/lib/mixed").MixedSchema<any, Record<string, any>, any>;
            }>) => Promise<void>;
            _uploadImage: (fileData: import("./types").UploadableFile) => Promise<void>;
        };
        folder: {
            create: (folderData: Pick<import("./types").Folder, "name" | "parent">, opts?: {
                user: {
                    id: string | number;
                };
            } | undefined) => Promise<any>;
            exists: (params?: {}) => Promise<boolean>;
            deleteByIds: (ids?: never[]) => Promise<{
                folders: any[];
                totalFolderNumber: number;
                totalFileNumber: number;
            }>;
            update: (id: number, { name, parent, }: {
                name: string;
                parent: number | null;
            }, { user }: {
                user: {
                    id: string | number;
                };
            }) => Promise<any>;
            setPathIdAndPath: (folder: Pick<import("./types").Folder, "parent">) => Promise<Pick<import("./types").Folder, "parent"> & {
                pathId: number;
                path: string;
            }>;
            getStructure: () => Promise<number[] & (Partial<import("./types").Folder> & {
                children: (Partial<import("./types").Folder> & any)[];
            })[]>;
        };
        file: {
            getFolderPath: (folderId?: number | null | undefined) => Promise<any>;
            deleteByIds: (ids?: number[]) => Promise<any[]>;
            signFileUrls: (file: import("./types").File) => Promise<import("./types").File>;
        };
        weeklyMetrics: ({ strapi }: {
            strapi: import("@strapi/types/dist/core").Strapi;
        }) => {
            computeMetrics(): Promise<{
                assetNumber: number;
                folderNumber: number;
                averageDepth: number;
                maxDepth: number;
                averageDeviationDepth: number;
            }>;
            sendMetrics(): Promise<void>;
            ensureWeeklyStoredCronSchedule(): Promise<string>;
            registerCron(): Promise<void>;
        };
        metrics: ({ strapi }: {
            strapi: import("@strapi/types/dist/core").Strapi;
        }) => {
            trackUsage(event: string, properties?: Record<string, any> | undefined): Promise<boolean>;
            sendUploadPluginMetrics(): Promise<void>;
        };
        'image-manipulation': {
            isFaultyImage: (file: import("./types").UploadableFile) => Promise<unknown>;
            isOptimizableImage: (file: import("./types").UploadableFile) => Promise<boolean | undefined>;
            isResizableImage: (file: import("./types").UploadableFile) => Promise<boolean | undefined>;
            isImage: (file: import("./types").UploadableFile) => Promise<boolean | undefined>;
            getDimensions: (file: import("./types").UploadableFile) => Promise<{
                width: number | null;
                height: number | null;
            }>;
            generateResponsiveFormats: (file: import("./types").UploadableFile) => Promise<({
                key: string;
                file: import("./types").UploadableFile;
            } | undefined)[]>;
            generateThumbnail: (file: import("./types").UploadableFile) => Promise<import("./types").UploadableFile | null>;
            optimize: (file: import("./types").UploadableFile) => Promise<import("./types").UploadableFile>;
            generateFileName: (name: string) => string;
        };
        'api-upload-folder': {
            getAPIUploadFolder: () => Promise<any>;
        };
        extensions: {
            signFileUrlsOnDocumentService: () => Promise<void>;
        };
        aiMetadata: ({ strapi }: {
            strapi: import("@strapi/types/dist/core").Strapi;
        }) => {
            isEnabled(): Promise<boolean>;
            processFiles(files: import("./types").InputFile[]): Promise<({
                altText: string;
                caption: string;
            } | null)[]>;
        };
    };
};
export default _default;
//# sourceMappingURL=index.d.ts.map