/// <reference types="koa" />
export declare const controllers: {
    'admin-file': {
        find(ctx: import("koa").Context): Promise<import("koa").Context | {
            results: any;
            pagination: {
                page: number;
                pageSize: number;
                pageCount: number;
                total: number;
            };
        }>;
        findOne(ctx: import("koa").Context): Promise<void>;
        destroy(ctx: import("koa").Context): Promise<void>;
    };
    'admin-folder': {
        findOne(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
        find(ctx: import("koa").Context): Promise<void>;
        create(ctx: import("koa").Context): Promise<void>;
        update(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
        getStructure(ctx: import("koa").Context): Promise<void>;
    };
    'admin-folder-file': {
        deleteMany(ctx: import("koa").Context): Promise<void>;
        moveMany(ctx: import("koa").Context): Promise<void>;
    };
    'admin-settings': {
        updateSettings(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
        getSettings(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
    };
    'admin-upload': {
        bulkUpdateFileInfo(ctx: import("koa").Context): Promise<void>;
        updateFileInfo(ctx: import("koa").Context): Promise<void>;
        replaceFile(ctx: import("koa").Context): Promise<void>;
        uploadFiles(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
        upload(ctx: import("koa").Context): Promise<void>;
    };
    'content-api': ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        find(ctx: import("koa").Context): Promise<void>;
        findOne(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
        destroy(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
        updateFileInfo(ctx: import("koa").Context): Promise<void>;
        replaceFile(ctx: import("koa").Context): Promise<void>;
        uploadFiles(ctx: import("koa").Context): Promise<void>;
        upload(ctx: import("koa").Context): Promise<void>;
    };
    'view-configuration': {
        updateViewConfiguration(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
        findViewConfiguration(ctx: import("koa").Context): Promise<void>;
    };
};
//# sourceMappingURL=index.d.ts.map