'use strict';

var utils = require('@strapi/utils');
var fp = require('lodash/fp');
var index = require('../../../utils/index.js');

const fileInfoSchema = utils.yup.object({
    name: utils.yup.string().nullable(),
    alternativeText: utils.yup.string().nullable(),
    caption: utils.yup.string().nullable(),
    folder: utils.yup.strapiID().nullable().test('folder-exists', 'the folder does not exist', async (folderId)=>{
        if (fp.isNil(folderId)) {
            return true;
        }
        const exists = await index.getService('folder').exists({
            id: folderId
        });
        return exists;
    })
});
const uploadSchema = utils.yup.object({
    fileInfo: fileInfoSchema
});
const multiUploadSchema = utils.yup.object({
    fileInfo: utils.yup.array().of(fileInfoSchema)
});
const validateUploadBody = (data = {}, isMulti = false)=>{
    const schema = isMulti ? multiUploadSchema : uploadSchema;
    return utils.validateYupSchema(schema, {
        strict: false
    })(data);
};
const bulkUpdatesSchema = utils.yup.object({
    updates: utils.yup.array().of(utils.yup.object({
        id: utils.yup.number().required(),
        fileInfo: fileInfoSchema.required()
    })).min(1).required()
});
const validateBulkUpdateBody = utils.validateYupSchema(bulkUpdatesSchema);

exports.validateBulkUpdateBody = validateBulkUpdateBody;
exports.validateUploadBody = validateUploadBody;
//# sourceMappingURL=upload.js.map
