'use strict';

var index = require('./utils/index.js');
var constants = require('./constants.js');

async function bootstrap({ strapi: strapi1 }) {
    const defaultConfig = {
        settings: {
            sizeOptimization: true,
            responsiveDimensions: true,
            autoOrientation: false,
            aiMetadata: true
        },
        view_configuration: {
            pageSize: 10,
            sort: constants.ALLOWED_SORT_STRINGS[0]
        }
    };
    for (const [key, defaultValue] of Object.entries(defaultConfig)){
        // set plugin store
        const configurator = strapi1.store({
            type: 'plugin',
            name: 'upload',
            key
        });
        const config = await configurator.get({});
        if (config && Object.keys(defaultValue).every((key)=>Object.prototype.hasOwnProperty.call(config, key))) {
            continue;
        }
        // if the config does not exist or does not have all the required keys
        // set from the defaultValue ensuring all required settings are present
        await configurator.set({
            value: Object.assign(defaultValue, config || {})
        });
    }
    await registerPermissionActions();
    await registerWebhookEvents();
    await index.getService('weeklyMetrics').registerCron();
    index.getService('metrics').sendUploadPluginMetrics();
    index.getService('extensions').signFileUrlsOnDocumentService();
}
const registerWebhookEvents = async ()=>Object.entries(constants.ALLOWED_WEBHOOK_EVENTS).forEach(([key, value])=>{
        strapi.get('webhookStore').addAllowedEvent(key, value);
    });
const registerPermissionActions = async ()=>{
    const actions = [
        {
            section: 'plugins',
            displayName: 'Access the Media Library',
            uid: 'read',
            pluginName: 'upload'
        },
        {
            section: 'plugins',
            displayName: 'Create (upload)',
            uid: 'assets.create',
            subCategory: 'assets',
            pluginName: 'upload'
        },
        {
            section: 'plugins',
            displayName: 'Update (crop, details, replace) + delete',
            uid: 'assets.update',
            subCategory: 'assets',
            pluginName: 'upload'
        },
        {
            section: 'plugins',
            displayName: 'Download',
            uid: 'assets.download',
            subCategory: 'assets',
            pluginName: 'upload'
        },
        {
            section: 'plugins',
            displayName: 'Copy link',
            uid: 'assets.copy-link',
            subCategory: 'assets',
            pluginName: 'upload'
        },
        {
            section: 'plugins',
            displayName: 'Configure view',
            uid: 'configure-view',
            pluginName: 'upload'
        },
        {
            section: 'settings',
            displayName: 'Access the Media Library settings page',
            uid: 'settings.read',
            category: 'media library',
            pluginName: 'upload'
        }
    ];
    await strapi.service('admin::permission').actionProvider.registerMany(actions);
};

exports.bootstrap = bootstrap;
//# sourceMappingURL=bootstrap.js.map
