import { SVGProps } from 'react';
import { DefaultTheme } from 'styled-components';
interface IconProps extends Omit<SVGProps<SVGSVGElement>, 'fill' | 'stroke'> {
    /**
     * @default "currentColor"
     */
    fill?: keyof DefaultTheme['colors'] | string;
    stroke?: keyof DefaultTheme['colors'] | string;
}
type IconComponent = React.FC<IconProps>;
export declare const FILE_TYPE_ICON_COMPONENT_MAP: Record<string, IconComponent>;
export declare const DEFAULT_FILE_ICON: IconComponent;
export declare const getFileIconComponent: (docType?: string) => IconComponent;
export {};
