'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var ee = require('@strapi/admin/strapi-admin/ee');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var isEqual = require('lodash/isEqual');
var reactIntl = require('react-intl');
var reactQuery = require('react-query');
var constants = require('../../constants.js');
var useSettings = require('../../hooks/useSettings.js');
require('byte-size');
require('date-fns');
var getTrad = require('../../utils/getTrad.js');
require('qs');
require('../../utils/typeFromMime.js');
require('../../utils/urlYupSchema.js');
var init = require('./init.js');
var reducer = require('./reducer.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

// TODO: find a better naming convention for the file that was an index file before
const SettingsPage = ()=>{
    const { formatMessage } = reactIntl.useIntl();
    const { toggleNotification } = strapiAdmin.useNotification();
    const { put } = strapiAdmin.useFetchClient();
    const [{ initialData, modifiedData }, dispatch] = React__namespace.useReducer(reducer.reducer, reducer.initialState, init.init);
    const { data, isLoading, refetch } = useSettings.useSettings();
    const isAIAvailable = ee.useAIAvailability();
    React__namespace.useEffect(()=>{
        if (data) {
            dispatch({
                type: 'GET_DATA_SUCCEEDED',
                data
            });
        }
    }, [
        data
    ]);
    const isSaveButtonDisabled = isEqual(initialData, modifiedData);
    const { mutateAsync, isLoading: isSubmitting } = reactQuery.useMutation(async (body)=>{
        const { data } = await put('/upload/settings', body);
        return data;
    }, {
        onSuccess () {
            refetch();
            toggleNotification({
                type: 'success',
                message: formatMessage({
                    id: 'notification.form.success.fields'
                })
            });
        },
        onError (err) {
            toggleNotification({
                type: 'danger',
                message: err.message || formatMessage({
                    id: 'notification.error'
                })
            });
        }
    });
    const handleSubmit = async (e)=>{
        e.preventDefault();
        if (isSaveButtonDisabled) {
            return;
        }
        await mutateAsync(modifiedData);
    };
    const handleChange = ({ target: { name, value } })=>{
        dispatch({
            type: 'ON_CHANGE',
            keys: name,
            value
        });
    };
    if (isLoading) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Loading, {});
    }
    return /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Page.Main, {
        tabIndex: -1,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Title, {
                children: formatMessage({
                    id: getTrad.getTrad('page.title'),
                    defaultMessage: 'Settings - Media Library'
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsxs("form", {
                onSubmit: handleSubmit,
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Header, {
                        title: formatMessage({
                            id: getTrad.getTrad('settings.header.label'),
                            defaultMessage: 'Media Library'
                        }),
                        primaryAction: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                            disabled: isSaveButtonDisabled,
                            loading: isSubmitting,
                            type: "submit",
                            startIcon: /*#__PURE__*/ jsxRuntime.jsx(icons.Check, {}),
                            size: "S",
                            children: formatMessage({
                                id: 'global.save',
                                defaultMessage: 'Save'
                            })
                        }),
                        subtitle: formatMessage({
                            id: getTrad.getTrad('settings.sub-header.label'),
                            defaultMessage: 'Configure the settings for the Media Library'
                        })
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Content, {
                        children: /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Root, {
                            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                direction: "column",
                                alignItems: "stretch",
                                gap: 4,
                                children: [
                                    isAIAvailable && /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                        background: "neutral0",
                                        padding: 6,
                                        shadow: "filterShadow",
                                        hasRadius: true,
                                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                            direction: "column",
                                            alignItems: "stretch",
                                            gap: 1,
                                            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Grid.Root, {
                                                gap: 6,
                                                children: [
                                                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Grid.Item, {
                                                        col: 8,
                                                        xs: 12,
                                                        direction: "column",
                                                        alignItems: "stretch",
                                                        children: [
                                                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                                                gap: 2,
                                                                children: [
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                                                        color: "alternative700",
                                                                        children: /*#__PURE__*/ jsxRuntime.jsx(icons.Sparkle, {})
                                                                    }),
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                                                        variant: "delta",
                                                                        tag: "h2",
                                                                        children: formatMessage({
                                                                            id: getTrad.getTrad('settings.form.aiMetadata.label'),
                                                                            defaultMessage: 'Generate AI captions and alt texts automatically on upload!'
                                                                        })
                                                                    })
                                                                ]
                                                            }),
                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                                                paddingTop: 1,
                                                                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                                                    variant: "pi",
                                                                    textColor: "neutral600",
                                                                    children: formatMessage({
                                                                        id: getTrad.getTrad('settings.form.aiMetadata.description'),
                                                                        defaultMessage: 'Enable this feature to save time, optimize your SEO and increase accessibility by letting our AI generate captions and alternative texts for you.'
                                                                    })
                                                                })
                                                            })
                                                        ]
                                                    }),
                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                                        col: 4,
                                                        xs: 12,
                                                        direction: "column",
                                                        alignItems: "end",
                                                        justifyContent: 'center',
                                                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Root, {
                                                            name: "aiMetadata",
                                                            minWidth: "200px",
                                                            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Toggle, {
                                                                checked: modifiedData?.aiMetadata,
                                                                offLabel: formatMessage({
                                                                    id: 'app.components.ToggleCheckbox.disabled-label',
                                                                    defaultMessage: 'Disabled'
                                                                }),
                                                                onLabel: formatMessage({
                                                                    id: 'app.components.ToggleCheckbox.enabled-label',
                                                                    defaultMessage: 'Enabled'
                                                                }),
                                                                onChange: (e)=>{
                                                                    handleChange({
                                                                        target: {
                                                                            name: 'aiMetadata',
                                                                            value: e.target.checked
                                                                        }
                                                                    });
                                                                }
                                                            })
                                                        })
                                                    })
                                                ]
                                            })
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                        background: "neutral0",
                                        padding: 6,
                                        shadow: "filterShadow",
                                        hasRadius: true,
                                        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                            direction: "column",
                                            alignItems: "stretch",
                                            gap: 4,
                                            children: [
                                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                                        variant: "delta",
                                                        tag: "h2",
                                                        children: formatMessage({
                                                            id: getTrad.getTrad('settings.blockTitle'),
                                                            defaultMessage: 'Asset management'
                                                        })
                                                    })
                                                }),
                                                /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Grid.Root, {
                                                    gap: 6,
                                                    children: [
                                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                                            col: 6,
                                                            xs: 12,
                                                            direction: "column",
                                                            alignItems: "stretch",
                                                            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
                                                                hint: formatMessage({
                                                                    id: getTrad.getTrad('settings.form.responsiveDimensions.description'),
                                                                    defaultMessage: 'Enabling this option will generate multiple formats (small, medium and large) of the uploaded asset.'
                                                                }),
                                                                name: "responsiveDimensions",
                                                                children: [
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                                                                        children: formatMessage({
                                                                            id: getTrad.getTrad('settings.form.responsiveDimensions.label'),
                                                                            defaultMessage: 'Responsive friendly upload'
                                                                        })
                                                                    }),
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Toggle, {
                                                                        checked: modifiedData?.responsiveDimensions,
                                                                        offLabel: formatMessage({
                                                                            id: 'app.components.ToggleCheckbox.off-label',
                                                                            defaultMessage: 'Off'
                                                                        }),
                                                                        onLabel: formatMessage({
                                                                            id: 'app.components.ToggleCheckbox.on-label',
                                                                            defaultMessage: 'On'
                                                                        }),
                                                                        onChange: (e)=>{
                                                                            handleChange({
                                                                                target: {
                                                                                    name: 'responsiveDimensions',
                                                                                    value: e.target.checked
                                                                                }
                                                                            });
                                                                        }
                                                                    }),
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Hint, {})
                                                                ]
                                                            })
                                                        }),
                                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                                            col: 6,
                                                            xs: 12,
                                                            direction: "column",
                                                            alignItems: "stretch",
                                                            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
                                                                hint: formatMessage({
                                                                    id: getTrad.getTrad('settings.form.sizeOptimization.description'),
                                                                    defaultMessage: 'Enabling this option will reduce the image size and slightly reduce its quality.'
                                                                }),
                                                                name: "sizeOptimization",
                                                                children: [
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                                                                        children: formatMessage({
                                                                            id: getTrad.getTrad('settings.form.sizeOptimization.label'),
                                                                            defaultMessage: 'Size optimization'
                                                                        })
                                                                    }),
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Toggle, {
                                                                        checked: modifiedData?.sizeOptimization,
                                                                        offLabel: formatMessage({
                                                                            id: 'app.components.ToggleCheckbox.off-label',
                                                                            defaultMessage: 'Off'
                                                                        }),
                                                                        onLabel: formatMessage({
                                                                            id: 'app.components.ToggleCheckbox.on-label',
                                                                            defaultMessage: 'On'
                                                                        }),
                                                                        onChange: (e)=>{
                                                                            handleChange({
                                                                                target: {
                                                                                    name: 'sizeOptimization',
                                                                                    value: e.target.checked
                                                                                }
                                                                            });
                                                                        }
                                                                    }),
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Hint, {})
                                                                ]
                                                            })
                                                        }),
                                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                                            col: 6,
                                                            xs: 12,
                                                            direction: "column",
                                                            alignItems: "stretch",
                                                            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
                                                                hint: formatMessage({
                                                                    id: getTrad.getTrad('settings.form.autoOrientation.description'),
                                                                    defaultMessage: 'Enabling this option will automatically rotate the image according to EXIF orientation tag.'
                                                                }),
                                                                name: "autoOrientation",
                                                                children: [
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                                                                        children: formatMessage({
                                                                            id: getTrad.getTrad('settings.form.autoOrientation.label'),
                                                                            defaultMessage: 'Auto orientation'
                                                                        })
                                                                    }),
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Toggle, {
                                                                        checked: modifiedData?.autoOrientation,
                                                                        offLabel: formatMessage({
                                                                            id: 'app.components.ToggleCheckbox.off-label',
                                                                            defaultMessage: 'Off'
                                                                        }),
                                                                        onLabel: formatMessage({
                                                                            id: 'app.components.ToggleCheckbox.on-label',
                                                                            defaultMessage: 'On'
                                                                        }),
                                                                        onChange: (e)=>{
                                                                            handleChange({
                                                                                target: {
                                                                                    name: 'autoOrientation',
                                                                                    value: e.target.checked
                                                                                }
                                                                            });
                                                                        }
                                                                    }),
                                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Hint, {})
                                                                ]
                                                            })
                                                        })
                                                    ]
                                                })
                                            ]
                                        })
                                    })
                                ]
                            })
                        })
                    })
                ]
            })
        ]
    });
};
const ProtectedSettingsPage = ()=>/*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Protect, {
        permissions: constants.PERMISSIONS.settings,
        children: /*#__PURE__*/ jsxRuntime.jsx(SettingsPage, {})
    });

exports.ProtectedSettingsPage = ProtectedSettingsPage;
exports.SettingsPage = SettingsPage;
//# sourceMappingURL=SettingsPage.js.map
