'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var qs = require('qs');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var styledComponents = require('styled-components');
var AIUploadModal = require('../../../ai/components/AIUploadModal.js');
var AssetGridList = require('../../../components/AssetGridList/AssetGridList.js');
var EditAssetContent = require('../../../components/EditAssetDialog/EditAssetContent.js');
var EditFolderDialog = require('../../../components/EditFolderDialog/EditFolderDialog.js');
var FolderCard = require('../../../components/FolderCard/FolderCard/FolderCard.js');
var FolderCardBody = require('../../../components/FolderCard/FolderCardBody/FolderCardBody.js');
var FolderCardBodyAction = require('../../../components/FolderCard/FolderCardBodyAction/FolderCardBodyAction.js');
var FolderCardCheckbox = require('../../../components/FolderCard/FolderCardCheckbox/FolderCardCheckbox.js');
var FolderGridList = require('../../../components/FolderGridList/FolderGridList.js');
var SortPicker = require('../../../components/SortPicker/SortPicker.js');
var TableList = require('../../../components/TableList/TableList.js');
var UploadAssetDialog = require('../../../components/UploadAssetDialog/UploadAssetDialog.js');
var constants = require('../../../constants.js');
var useAiAvailability = require('../../../hooks/useAiAvailability.js');
var useAssets = require('../../../hooks/useAssets.js');
var useFolder = require('../../../hooks/useFolder.js');
var useFolders = require('../../../hooks/useFolders.js');
var useMediaLibraryPermissions = require('../../../hooks/useMediaLibraryPermissions.js');
var usePersistentState = require('../../../hooks/usePersistentState.js');
var useSelectionState = require('../../../hooks/useSelectionState.js');
var containsAssetFilter = require('../../../utils/containsAssetFilter.js');
require('byte-size');
require('date-fns');
var getTrad = require('../../../utils/getTrad.js');
var getBreadcrumbDataML = require('../../../utils/getBreadcrumbDataML.js');
var getFolderURL = require('../../../utils/getFolderURL.js');
require('../../../utils/typeFromMime.js');
require('../../../utils/urlYupSchema.js');
var BulkActions = require('./components/BulkActions.js');
var EmptyOrNoPermissions = require('./components/EmptyOrNoPermissions.js');
var Filters = require('./components/Filters.js');
var Header = require('./components/Header.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

// TODO: find a better naming convention for the file that was an index file before
const BoxWithHeight = styledComponents.styled(designSystem.Box)`
  height: 3.2rem;
  display: flex;
  align-items: center;
`;
const TypographyMaxWidth = styledComponents.styled(designSystem.Typography)`
  max-width: 100%;
`;
const ActionContainer = styledComponents.styled(designSystem.Box)`
  svg {
    path {
      fill: ${({ theme })=>theme.colors.neutral500};
    }
  }
`;
const MediaLibrary = ()=>{
    const navigate = reactRouterDom.useNavigate();
    const { canRead, canCreate, canUpdate, canCopyLink, canDownload, canConfigureView, isLoading: permissionsLoading } = useMediaLibraryPermissions.useMediaLibraryPermissions();
    const { isEnabled: isAiEnabled, status: aiAvailabilityStatus } = useAiAvailability.useAIAvailability();
    const currentFolderToEditRef = React__namespace.useRef();
    const { formatMessage } = reactIntl.useIntl();
    const { pathname } = reactRouterDom.useLocation();
    const { trackUsage } = strapiAdmin.useTracking();
    const [{ query }, setQuery] = strapiAdmin.useQueryParams();
    const isFiltering = Boolean(query._q || query.filters);
    const [view, setView] = usePersistentState.usePersistentState(constants.localStorageKeys.view, constants.viewOptions.GRID);
    const isGridView = view === constants.viewOptions.GRID;
    const { data: assetsData, isLoading: assetsLoading, error: assetsError } = useAssets.useAssets({
        skipWhen: !canRead,
        query
    });
    const { data: foldersData, isLoading: foldersLoading, error: foldersError } = useFolders.useFolders({
        enabled: canRead && assetsData?.pagination?.page === 1 && !containsAssetFilter.containsAssetFilter(query),
        query
    });
    const { data: currentFolder, isLoading: isCurrentFolderLoading, error: currentFolderError } = useFolder.useFolder(query?.folder, {
        enabled: canRead && !!query?.folder
    });
    // Folder was not found: redirect to the media library root
    if (currentFolderError?.name === 'NotFoundError') {
        navigate(pathname);
    }
    const folders = foldersData?.map((folder)=>({
            ...folder,
            type: 'folder',
            folderURL: getFolderURL.getFolderURL(pathname, query, {
                folder: folder.id.toString(),
                folderPath: folder.path
            }),
            isSelectable: canUpdate
        })) ?? [];
    const folderCount = folders?.length || 0;
    const assets = assetsData?.results?.map((asset)=>({
            ...asset,
            type: 'asset',
            isSelectable: canUpdate
        })) || [];
    const assetCount = assets?.length ?? 0;
    const totalAssetCount = assetsData?.pagination?.total;
    const isLoading = isCurrentFolderLoading || foldersLoading || permissionsLoading || assetsLoading || aiAvailabilityStatus === 'loading';
    const [showUploadAssetDialog, setShowUploadAssetDialog] = React__namespace.useState(false);
    const [showEditFolderDialog, setShowEditFolderDialog] = React__namespace.useState(false);
    const [assetToEdit, setAssetToEdit] = React__namespace.useState(undefined);
    const [folderToEdit, setFolderToEdit] = React__namespace.useState(undefined);
    const [selected, { selectOne, selectAll, setSelections }] = useSelectionState.useSelectionState([
        'type',
        'id'
    ], []);
    // reset selection when folder changes to hide bulk actions
    React__namespace.useEffect(()=>{
        setSelections([]);
    }, [
        query.folder,
        setSelections
    ]);
    const indeterminateBulkSelect = selected?.length > 0 && selected?.length !== assetCount + folderCount;
    const toggleUploadAssetDialog = ()=>setShowUploadAssetDialog((prev)=>!prev);
    const toggleEditFolderDialog = ({ created = false } = {})=>{
        // folders are only displayed on the first page, therefore
        // we have to navigate the user to that page, in case a folder
        // was created successfully in order for them to see it
        if (created && query?.page !== '1') {
            setQuery({
                ...query,
                page: 1
            });
        }
        setShowEditFolderDialog((prev)=>!prev);
    };
    const handleBulkSelect = (checked, elements)=>{
        if (checked) {
            trackUsage('didSelectAllMediaLibraryElements');
        }
        selectAll(elements);
    };
    const handleChangeSort = (value)=>{
        trackUsage('didSortMediaLibraryElements', {
            location: 'upload',
            sort: value
        });
        setQuery({
            sort: value
        });
    };
    const handleEditFolder = (folder)=>{
        setFolderToEdit(folder);
        setShowEditFolderDialog(true);
    };
    const handleEditFolderClose = (payload)=>{
        setFolderToEdit(null);
        toggleEditFolderDialog(payload);
        if (currentFolderToEditRef.current) {
            currentFolderToEditRef.current.focus();
        }
    };
    const handleAssetDeleted = (numberOfAssets)=>{
        if (numberOfAssets === assetCount && assetsData?.pagination?.page === assetsData?.pagination?.pageCount && assetsData?.pagination?.page && assetsData.pagination.page > 1) {
            setQuery({
                ...query,
                page: assetsData.pagination.page - 1
            });
        }
    };
    const handleBulkActionSuccess = ()=>{
        selectAll();
        handleAssetDeleted(selected.length);
    };
    if (isLoading) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Loading, {});
    }
    if (assetsError || foldersError || aiAvailabilityStatus === 'error') {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Error, {});
    }
    return /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Layouts.Root, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Page.Main, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(Header.Header, {
                        breadcrumbs: !isCurrentFolderLoading ? getBreadcrumbDataML.getBreadcrumbDataML(currentFolder, {
                            pathname,
                            query
                        }) : null,
                        canCreate: canCreate,
                        onToggleEditFolderDialog: toggleEditFolderDialog,
                        onToggleUploadAssetDialog: toggleUploadAssetDialog,
                        folder: currentFolder
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Action, {
                        startActions: /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                            children: [
                                canUpdate && isGridView && (assetCount > 0 || folderCount > 0) && /*#__PURE__*/ jsxRuntime.jsx(BoxWithHeight, {
                                    paddingLeft: 2,
                                    paddingRight: 2,
                                    background: "neutral0",
                                    hasRadius: true,
                                    borderColor: "neutral200",
                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Checkbox, {
                                        "aria-label": formatMessage({
                                            id: getTrad.getTrad('bulk.select.label'),
                                            defaultMessage: 'Select all folders & assets'
                                        }),
                                        checked: indeterminateBulkSelect ? 'indeterminate' : (assetCount > 0 || folderCount > 0) && selected.length === assetCount + folderCount,
                                        onCheckedChange: (e)=>handleBulkSelect(e, [
                                                ...assets,
                                                ...folders
                                            ])
                                    })
                                }),
                                canRead && isGridView && /*#__PURE__*/ jsxRuntime.jsx(SortPicker.SortPicker, {
                                    value: query?.sort,
                                    onChangeSort: handleChangeSort
                                }),
                                canRead && /*#__PURE__*/ jsxRuntime.jsx(Filters.Filters, {})
                            ]
                        }),
                        endActions: /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                            children: [
                                canConfigureView ? /*#__PURE__*/ jsxRuntime.jsx(ActionContainer, {
                                    paddingTop: 1,
                                    paddingBottom: 1,
                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                                        tag: reactRouterDom.Link,
                                        to: {
                                            pathname: `${pathname}/configuration`,
                                            search: qs.stringify(query, {
                                                encode: false
                                            })
                                        },
                                        label: formatMessage({
                                            id: 'app.links.configure-view',
                                            defaultMessage: 'Configure the view'
                                        }),
                                        children: /*#__PURE__*/ jsxRuntime.jsx(icons.Cog, {})
                                    })
                                }) : null,
                                /*#__PURE__*/ jsxRuntime.jsx(ActionContainer, {
                                    paddingTop: 1,
                                    paddingBottom: 1,
                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                                        label: isGridView ? formatMessage({
                                            id: getTrad.getTrad('view-switch.list'),
                                            defaultMessage: 'List View'
                                        }) : formatMessage({
                                            id: getTrad.getTrad('view-switch.grid'),
                                            defaultMessage: 'Grid View'
                                        }),
                                        onClick: ()=>setView(isGridView ? constants.viewOptions.LIST : constants.viewOptions.GRID),
                                        children: isGridView ? /*#__PURE__*/ jsxRuntime.jsx(icons.List, {}) : /*#__PURE__*/ jsxRuntime.jsx(icons.GridFour, {})
                                    })
                                }),
                                /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.SearchInput, {
                                    label: formatMessage({
                                        id: getTrad.getTrad('search.label'),
                                        defaultMessage: 'Search for an asset'
                                    }),
                                    trackedEvent: "didSearchMediaLibraryElements",
                                    trackedEventDetails: {
                                        location: 'upload'
                                    }
                                })
                            ]
                        })
                    }),
                    /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Layouts.Content, {
                        children: [
                            selected.length > 0 && /*#__PURE__*/ jsxRuntime.jsx(BulkActions.BulkActions, {
                                currentFolder: currentFolder,
                                selected: selected,
                                onSuccess: handleBulkActionSuccess
                            }),
                            folderCount === 0 && assetCount === 0 && /*#__PURE__*/ jsxRuntime.jsx(EmptyOrNoPermissions.EmptyOrNoPermissions, {
                                canCreate: canCreate,
                                canRead: canRead,
                                isFiltering: isFiltering,
                                onActionClick: toggleUploadAssetDialog
                            }),
                            canRead && !isGridView && (assetCount > 0 || folderCount > 0) && /*#__PURE__*/ jsxRuntime.jsx(TableList.TableList, {
                                assetCount: assetCount,
                                folderCount: folderCount,
                                indeterminate: indeterminateBulkSelect,
                                onChangeSort: handleChangeSort,
                                onChangeFolder: (folderID, folderPath)=>navigate(getFolderURL.getFolderURL(pathname, query, {
                                        folder: folderID.toString(),
                                        folderPath
                                    })),
                                onEditAsset: setAssetToEdit,
                                onEditFolder: handleEditFolder,
                                onSelectOne: selectOne,
                                onSelectAll: handleBulkSelect,
                                rows: [
                                    ...folders,
                                    ...assets
                                ],
                                selected: selected,
                                shouldDisableBulkSelect: !canUpdate,
                                sortQuery: query?.sort ?? ''
                            }),
                            canRead && isGridView && /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                                children: [
                                    folderCount > 0 && /*#__PURE__*/ jsxRuntime.jsx(FolderGridList.FolderGridList, {
                                        title: (isFiltering && assetCount > 0 || !isFiltering) && formatMessage({
                                            id: getTrad.getTrad('list.folders.title'),
                                            defaultMessage: 'Folders ({count})'
                                        }, {
                                            count: folderCount
                                        }) || '',
                                        children: folders.map((folder)=>{
                                            const selectedFolders = selected.filter(({ type })=>type === 'folder');
                                            const isSelected = !!selectedFolders.find((currentFolder)=>currentFolder.id === folder.id);
                                            const url = getFolderURL.getFolderURL(pathname, query, {
                                                folder: folder?.id.toString(),
                                                folderPath: folder?.path
                                            });
                                            return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                                col: 3,
                                                m: 4,
                                                s: 6,
                                                xs: 12,
                                                direction: "column",
                                                alignItems: "stretch",
                                                children: /*#__PURE__*/ jsxRuntime.jsx(FolderCard.FolderCard, {
                                                    ref: folderToEdit && folder.id === folderToEdit.id ? currentFolderToEditRef : undefined,
                                                    ariaLabel: folder.name,
                                                    id: `folder-${folder.id}`,
                                                    to: url,
                                                    startAction: folder.isSelectable ? /*#__PURE__*/ jsxRuntime.jsx(FolderCardCheckbox.FolderCardCheckbox, {
                                                        "data-testid": `folder-checkbox-${folder.id}`,
                                                        checked: isSelected,
                                                        onCheckedChange: ()=>selectOne(folder)
                                                    }) : null,
                                                    cardActions: /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                                                        label: formatMessage({
                                                            id: getTrad.getTrad('list.folder.edit'),
                                                            defaultMessage: 'Edit folder'
                                                        }),
                                                        onClick: ()=>handleEditFolder(folder),
                                                        children: /*#__PURE__*/ jsxRuntime.jsx(icons.Pencil, {})
                                                    }),
                                                    children: /*#__PURE__*/ jsxRuntime.jsx(FolderCardBody.FolderCardBody, {
                                                        children: /*#__PURE__*/ jsxRuntime.jsx(FolderCardBodyAction.FolderCardBodyAction, {
                                                            to: url,
                                                            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                                                tag: "h2",
                                                                direction: "column",
                                                                alignItems: "start",
                                                                maxWidth: "100%",
                                                                children: [
                                                                    /*#__PURE__*/ jsxRuntime.jsxs(TypographyMaxWidth, {
                                                                        fontWeight: "semiBold",
                                                                        textColor: "neutral800",
                                                                        ellipsis: true,
                                                                        children: [
                                                                            folder.name,
                                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.VisuallyHidden, {
                                                                                children: ":"
                                                                            })
                                                                        ]
                                                                    }),
                                                                    /*#__PURE__*/ jsxRuntime.jsx(TypographyMaxWidth, {
                                                                        tag: "span",
                                                                        textColor: "neutral600",
                                                                        variant: "pi",
                                                                        ellipsis: true,
                                                                        children: formatMessage({
                                                                            id: getTrad.getTrad('list.folder.subtitle'),
                                                                            defaultMessage: '{folderCount, plural, =0 {# folder} one {# folder} other {# folders}}, {filesCount, plural, =0 {# asset} one {# asset} other {# assets}}'
                                                                        }, {
                                                                            folderCount: folder.children?.count,
                                                                            filesCount: folder.files?.count
                                                                        })
                                                                    })
                                                                ]
                                                            })
                                                        })
                                                    })
                                                })
                                            }, `folder-${folder.id}`);
                                        })
                                    }),
                                    assetCount > 0 && folderCount > 0 && /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                        paddingTop: 6,
                                        paddingBottom: 4,
                                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Divider, {})
                                    }),
                                    assetCount > 0 && /*#__PURE__*/ jsxRuntime.jsx(AssetGridList.AssetGridList, {
                                        assets: assets,
                                        onEditAsset: setAssetToEdit,
                                        onSelectAsset: selectOne,
                                        selectedAssets: selected.filter(({ type })=>type === 'asset'),
                                        title: (!isFiltering || isFiltering && folderCount > 0) && assetsData?.pagination?.page === 1 && formatMessage({
                                            id: getTrad.getTrad('list.assets.title'),
                                            defaultMessage: 'Assets ({count})'
                                        }, {
                                            count: totalAssetCount
                                        }) || ''
                                    })
                                ]
                            }),
                            /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Pagination.Root, {
                                ...assetsData?.pagination,
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Pagination.PageSize, {}),
                                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Pagination.Links, {})
                                ]
                            })
                        ]
                    })
                ]
            }),
            showUploadAssetDialog && (isAiEnabled ? /*#__PURE__*/ jsxRuntime.jsx(AIUploadModal.AIUploadModal, {
                open: showUploadAssetDialog,
                onClose: toggleUploadAssetDialog,
                folderId: query?.folder ? Number(query.folder) : null
            }) : /*#__PURE__*/ jsxRuntime.jsx(UploadAssetDialog.UploadAssetDialog, {
                open: showUploadAssetDialog,
                onClose: toggleUploadAssetDialog,
                trackedLocation: "upload",
                folderId: query?.folder
            })),
            showEditFolderDialog && /*#__PURE__*/ jsxRuntime.jsx(EditFolderDialog.EditFolderDialog, {
                open: showEditFolderDialog,
                onClose: ()=>handleEditFolderClose(),
                folder: folderToEdit,
                parentFolderId: query?.folder,
                location: "upload"
            }),
            assetToEdit && /*#__PURE__*/ jsxRuntime.jsx(EditAssetContent.EditAssetDialog, {
                onClose: (editedAsset)=>{
                    // The asset has been deleted
                    if (editedAsset === null) {
                        handleAssetDeleted(1);
                    }
                    setAssetToEdit(undefined);
                },
                open: !!assetToEdit,
                asset: assetToEdit,
                canUpdate: canUpdate,
                canCopyLink: canCopyLink,
                canDownload: canDownload,
                trackedLocation: "upload"
            })
        ]
    });
};

exports.MediaLibrary = MediaLibrary;
//# sourceMappingURL=MediaLibrary.js.map
