'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var name = "@strapi/upload";
var version = "5.33.1";
var description = "Makes it easy to upload images and files to your Strapi Application.";
var license = "SEE LICENSE IN LICENSE";
var author = {
    name: "Strapi Solutions SAS",
    email: "hi@strapi.io",
    url: "https://strapi.io"
};
var maintainers = [
    {
        name: "Strapi Solutions SAS",
        email: "hi@strapi.io",
        url: "https://strapi.io"
    }
];
var exports$1 = {
    "./strapi-admin": {
        types: "./dist/admin/src/index.d.ts",
        source: "./admin/src/index.ts",
        "import": "./dist/admin/index.mjs",
        require: "./dist/admin/index.js",
        "default": "./dist/admin/index.js"
    },
    "./_internal/shared": {
        types: "./dist/shared/index.d.ts",
        source: "./shared/index.ts",
        "import": "./dist/shared/index.mjs",
        require: "./dist/shared/index.js",
        "default": "./dist/shared/index.js"
    },
    "./strapi-server": {
        types: "./dist/server/src/index.d.ts",
        source: "./server/src/index.ts",
        "import": "./dist/server/index.mjs",
        require: "./dist/server/index.js",
        "default": "./dist/server/index.js"
    },
    "./package.json": "./package.json"
};
var files = [
    "dist/",
    "strapi-server.js"
];
var scripts = {
    build: "run -T npm-run-all clean --parallel build:code build:types",
    "build:code": "run -T rollup -c",
    "build:types": "run -T run-p build:types:server build:types:admin",
    "build:types:server": "run -T tsc -p server/tsconfig.build.json --emitDeclarationOnly",
    "build:types:admin": "run -T tsc -p admin/tsconfig.build.json --emitDeclarationOnly",
    clean: "run -T rimraf dist",
    lint: "run -T eslint .",
    "test:front": "run -T cross-env IS_EE=true jest --config ./jest.config.front.js",
    "test:unit": "run -T jest",
    "test:ts:back": "run -T tsc --noEmit -p server/tsconfig.json",
    "test:ts:front": "run -T tsc -p admin/tsconfig.json",
    "test:front:watch": "run -T cross-env IS_EE=true jest --config ./jest.config.front.js --watch",
    "test:unit:watch": "run -T jest --watch",
    watch: "run -T rollup -c -w"
};
var dependencies = {
    "@mux/mux-player-react": "3.1.0",
    "@reduxjs/toolkit": "1.9.7",
    "@strapi/design-system": "2.0.1",
    "@strapi/icons": "2.0.1",
    "@strapi/provider-upload-local": "5.33.1",
    "@strapi/utils": "5.33.1",
    "byte-size": "8.1.1",
    cropperjs: "1.6.1",
    "date-fns": "2.30.0",
    "file-type": "21.0.0",
    formik: "2.4.5",
    "fs-extra": "11.2.0",
    immer: "9.0.21",
    "koa-range": "0.3.0",
    "koa-static": "5.0.0",
    lodash: "4.17.21",
    "mime-types": "2.1.35",
    "prop-types": "^15.8.1",
    qs: "6.11.1",
    "react-dnd": "16.0.1",
    "react-intl": "6.6.2",
    "react-query": "3.39.3",
    "react-redux": "8.1.3",
    "react-select": "5.8.0",
    sharp: "0.33.5",
    yup: "0.32.9",
    zod: "3.25.67"
};
var devDependencies = {
    "@strapi/admin": "5.33.1",
    "@strapi/types": "5.33.1",
    "@testing-library/dom": "10.4.1",
    "@testing-library/react": "16.3.0",
    "@testing-library/user-event": "14.6.1",
    "@types/byte-size": "8.1.2",
    "@types/fs-extra": "11.0.4",
    "@types/koa": "2.13.4",
    "@types/koa-range": "0.3.5",
    "@types/koa-static": "4.0.2",
    formidable: "3.5.4",
    koa: "2.16.1",
    "koa-body": "6.0.1",
    msw: "1.3.0",
    react: "18.3.1",
    "react-dom": "18.3.1",
    "react-router-dom": "6.22.3",
    "styled-components": "6.1.8"
};
var peerDependencies = {
    "@strapi/admin": "^5.0.0",
    react: "^17.0.0 || ^18.0.0",
    "react-dom": "^17.0.0 || ^18.0.0",
    "react-router-dom": "^6.0.0",
    "styled-components": "^6.0.0"
};
var engines = {
    node: ">=20.0.0 <=24.x.x",
    npm: ">=6.0.0"
};
var strapi = {
    displayName: "Media Library",
    name: "upload",
    description: "Media file management.",
    required: true,
    kind: "plugin"
};
var pluginPkg = {
    name: name,
    version: version,
    description: description,
    license: license,
    author: author,
    maintainers: maintainers,
    exports: exports$1,
    files: files,
    scripts: scripts,
    dependencies: dependencies,
    devDependencies: devDependencies,
    peerDependencies: peerDependencies,
    engines: engines,
    strapi: strapi
};

exports.author = author;
exports.default = pluginPkg;
exports.dependencies = dependencies;
exports.description = description;
exports.devDependencies = devDependencies;
exports.engines = engines;
exports.exports = exports$1;
exports.files = files;
exports.license = license;
exports.maintainers = maintainers;
exports.name = name;
exports.peerDependencies = peerDependencies;
exports.scripts = scripts;
exports.strapi = strapi;
exports.version = version;
//# sourceMappingURL=package.json.js.map
