import { useTracking as useTracking$1 } from '@strapi/admin/strapi-admin';
import { useAIAvailability } from '@strapi/admin/strapi-admin/ee';
import { useSettings } from './useSettings.mjs';

const useTracking = ()=>{
    const { trackUsage: trackStrapiUsage } = useTracking$1();
    const { data } = useSettings();
    const isAiAvailable = useAIAvailability();
    const trackUsage = (event, properties)=>{
        return trackStrapiUsage(event, {
            ...properties,
            ...isAiAvailable ? {
                isAIMediaLibraryConfigured: Boolean(data?.aiMetadata)
            } : {}
        });
    };
    return {
        trackUsage
    };
};

export { useTracking };
//# sourceMappingURL=useTracking.mjs.map
