'use strict';

var strapiAdmin = require('@strapi/admin/strapi-admin');
var ee = require('@strapi/admin/strapi-admin/ee');
var useSettings = require('./useSettings.js');

const useTracking = ()=>{
    const { trackUsage: trackStrapiUsage } = strapiAdmin.useTracking();
    const { data } = useSettings.useSettings();
    const isAiAvailable = ee.useAIAvailability();
    const trackUsage = (event, properties)=>{
        return trackStrapiUsage(event, {
            ...properties,
            ...isAiAvailable ? {
                isAIMediaLibraryConfigured: Boolean(data?.aiMetadata)
            } : {}
        });
    };
    return {
        trackUsage
    };
};

exports.useTracking = useTracking;
//# sourceMappingURL=useTracking.js.map
