import { useNotification, useFetchClient } from '@strapi/admin/strapi-admin';
import { useIntl } from 'react-intl';
import { useQueryClient, useMutation } from 'react-query';
import { pluginId } from '../pluginId.mjs';
import 'byte-size';
import 'date-fns';
import { getTrad } from '../utils/getTrad.mjs';
import 'qs';
import '../utils/typeFromMime.mjs';
import '../utils/urlYupSchema.mjs';

const useBulkEdit = ()=>{
    const { formatMessage } = useIntl();
    const { toggleNotification } = useNotification();
    const queryClient = useQueryClient();
    const { post } = useFetchClient();
    const bulkEditQuery = ({ updates })=>{
        return post('/upload/actions/bulk-update', {
            updates
        });
    };
    const mutation = useMutation(bulkEditQuery, {
        onSuccess (res) {
            const { data } = res;
            if (data && data.length > 0) {
                queryClient.refetchQueries([
                    pluginId,
                    'assets'
                ], {
                    active: true
                });
                queryClient.refetchQueries([
                    pluginId,
                    'asset-count'
                ], {
                    active: true
                });
                queryClient.refetchQueries([
                    pluginId,
                    'folders'
                ], {
                    active: true
                });
            }
            toggleNotification({
                type: 'success',
                message: formatMessage({
                    id: getTrad('modal.edit.success-label'),
                    defaultMessage: 'Files have been successfully updated.'
                })
            });
        }
    });
    const edit = (updates)=>mutation.mutateAsync({
            updates
        });
    return {
        ...mutation,
        edit
    };
};

export { useBulkEdit };
//# sourceMappingURL=useBulkEdit.mjs.map
