'use strict';

var strapiAdmin = require('@strapi/admin/strapi-admin');
var reactIntl = require('react-intl');
var reactQuery = require('react-query');
var pluginId = require('../pluginId.js');
require('byte-size');
require('date-fns');
var getTrad = require('../utils/getTrad.js');
require('qs');
require('../utils/typeFromMime.js');
require('../utils/urlYupSchema.js');

const useBulkEdit = ()=>{
    const { formatMessage } = reactIntl.useIntl();
    const { toggleNotification } = strapiAdmin.useNotification();
    const queryClient = reactQuery.useQueryClient();
    const { post } = strapiAdmin.useFetchClient();
    const bulkEditQuery = ({ updates })=>{
        return post('/upload/actions/bulk-update', {
            updates
        });
    };
    const mutation = reactQuery.useMutation(bulkEditQuery, {
        onSuccess (res) {
            const { data } = res;
            if (data && data.length > 0) {
                queryClient.refetchQueries([
                    pluginId.pluginId,
                    'assets'
                ], {
                    active: true
                });
                queryClient.refetchQueries([
                    pluginId.pluginId,
                    'asset-count'
                ], {
                    active: true
                });
                queryClient.refetchQueries([
                    pluginId.pluginId,
                    'folders'
                ], {
                    active: true
                });
            }
            toggleNotification({
                type: 'success',
                message: formatMessage({
                    id: getTrad.getTrad('modal.edit.success-label'),
                    defaultMessage: 'Files have been successfully updated.'
                })
            });
        }
    });
    const edit = (updates)=>mutation.mutateAsync({
            updates
        });
    return {
        ...mutation,
        edit
    };
};

exports.useBulkEdit = useBulkEdit;
//# sourceMappingURL=useBulkEdit.js.map
