import { jsxs, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { Flex, Box, Typography, Modal, Button } from '@strapi/design-system';
import { PlusCircle } from '@strapi/icons';
import { useIntl } from 'react-intl';
import { styled } from 'styled-components';
import { AssetSource } from '../../../constants.mjs';
import { useTracking } from '../../../hooks/useTracking.mjs';
import 'byte-size';
import 'date-fns';
import { getTrad } from '../../../utils/getTrad.mjs';
import 'qs';
import { rawFileToAsset } from '../../../utils/rawFileToAsset.mjs';
import '../../../utils/typeFromMime.mjs';
import '../../../utils/urlYupSchema.mjs';

const Wrapper = styled(Flex)`
  flex-direction: column;
`;
const IconWrapper = styled.div`
  font-size: 6rem;

  svg path {
    fill: ${({ theme })=>theme.colors.primary600};
  }
`;
const MediaBox = styled(Box)`
  border-style: dashed;
`;
const OpaqueBox = styled(Box)`
  opacity: 0;
  cursor: pointer;
`;
const FromComputerForm = ({ onClose, onAddAssets, trackedLocation })=>{
    const { formatMessage } = useIntl();
    const [dragOver, setDragOver] = React.useState(false);
    const inputRef = React.useRef(null);
    const { trackUsage } = useTracking();
    const handleDragOver = (event)=>{
        event.preventDefault();
    };
    const handleDragEnter = (event)=>{
        event.preventDefault();
        setDragOver(true);
    };
    const handleDragLeave = ()=>setDragOver(false);
    const handleChange = ()=>{
        const files = inputRef.current?.files;
        const assets = [];
        if (files) {
            for(let i = 0; i < files.length; i++){
                const file = files.item(i);
                if (file) {
                    const asset = rawFileToAsset(file, AssetSource.Computer);
                    assets.push(asset);
                }
            }
        }
        if (trackedLocation) {
            trackUsage('didSelectFile', {
                source: 'computer',
                location: trackedLocation
            });
        }
        onAddAssets(assets);
    };
    const handleDrop = (e)=>{
        e.preventDefault();
        if (e?.dataTransfer?.files) {
            const files = e.dataTransfer.files;
            const assets = [];
            for(let i = 0; i < files.length; i++){
                const file = files.item(i);
                if (file) {
                    const asset = rawFileToAsset(file, AssetSource.Computer);
                    assets.push(asset);
                }
            }
            onAddAssets(assets);
        }
        setDragOver(false);
    };
    return /*#__PURE__*/ jsxs("form", {
        children: [
            /*#__PURE__*/ jsx(Box, {
                paddingLeft: 8,
                paddingRight: 8,
                paddingTop: 6,
                paddingBottom: 6,
                children: /*#__PURE__*/ jsx("label", {
                    children: /*#__PURE__*/ jsx(MediaBox, {
                        paddingTop: 11,
                        paddingBottom: 11,
                        hasRadius: true,
                        justifyContent: "center",
                        borderColor: dragOver ? 'primary500' : 'neutral300',
                        background: dragOver ? 'primary100' : 'neutral100',
                        position: "relative",
                        onDragEnter: handleDragEnter,
                        onDragLeave: handleDragLeave,
                        onDragOver: handleDragOver,
                        onDrop: handleDrop,
                        children: /*#__PURE__*/ jsx(Flex, {
                            justifyContent: "center",
                            children: /*#__PURE__*/ jsxs(Wrapper, {
                                children: [
                                    /*#__PURE__*/ jsx(IconWrapper, {
                                        children: /*#__PURE__*/ jsx(PlusCircle, {
                                            "aria-hidden": true,
                                            width: "3.2rem",
                                            height: "3.2rem"
                                        })
                                    }),
                                    /*#__PURE__*/ jsx(Box, {
                                        paddingTop: 3,
                                        paddingBottom: 5,
                                        children: /*#__PURE__*/ jsx(Typography, {
                                            variant: "delta",
                                            textColor: "neutral600",
                                            tag: "span",
                                            children: formatMessage({
                                                id: getTrad('input.label'),
                                                defaultMessage: 'Drag & Drop here or'
                                            })
                                        })
                                    }),
                                    /*#__PURE__*/ jsx(OpaqueBox, {
                                        tag: "input",
                                        position: "absolute",
                                        left: 0,
                                        right: 0,
                                        bottom: 0,
                                        top: 0,
                                        width: "100%",
                                        type: "file",
                                        multiple: true,
                                        name: "files",
                                        "aria-label": formatMessage({
                                            id: getTrad('input.label'),
                                            defaultMessage: 'Drag & Drop here or'
                                        }),
                                        tabIndex: -1,
                                        ref: inputRef,
                                        zIndex: 1,
                                        onChange: handleChange
                                    })
                                ]
                            })
                        })
                    })
                })
            }),
            /*#__PURE__*/ jsx(Modal.Footer, {
                children: /*#__PURE__*/ jsx(Button, {
                    onClick: onClose,
                    variant: "tertiary",
                    children: formatMessage({
                        id: 'app.components.Button.cancel',
                        defaultMessage: 'cancel'
                    })
                })
            })
        ]
    });
};

export { FromComputerForm };
//# sourceMappingURL=FromComputerForm.mjs.map
