'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var reactIntl = require('react-intl');
var styledComponents = require('styled-components');
var constants = require('../../../constants.js');
var useTracking = require('../../../hooks/useTracking.js');
require('byte-size');
require('date-fns');
var getTrad = require('../../../utils/getTrad.js');
require('qs');
var rawFileToAsset = require('../../../utils/rawFileToAsset.js');
require('../../../utils/typeFromMime.js');
require('../../../utils/urlYupSchema.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const Wrapper = styledComponents.styled(designSystem.Flex)`
  flex-direction: column;
`;
const IconWrapper = styledComponents.styled.div`
  font-size: 6rem;

  svg path {
    fill: ${({ theme })=>theme.colors.primary600};
  }
`;
const MediaBox = styledComponents.styled(designSystem.Box)`
  border-style: dashed;
`;
const OpaqueBox = styledComponents.styled(designSystem.Box)`
  opacity: 0;
  cursor: pointer;
`;
const FromComputerForm = ({ onClose, onAddAssets, trackedLocation })=>{
    const { formatMessage } = reactIntl.useIntl();
    const [dragOver, setDragOver] = React__namespace.useState(false);
    const inputRef = React__namespace.useRef(null);
    const { trackUsage } = useTracking.useTracking();
    const handleDragOver = (event)=>{
        event.preventDefault();
    };
    const handleDragEnter = (event)=>{
        event.preventDefault();
        setDragOver(true);
    };
    const handleDragLeave = ()=>setDragOver(false);
    const handleChange = ()=>{
        const files = inputRef.current?.files;
        const assets = [];
        if (files) {
            for(let i = 0; i < files.length; i++){
                const file = files.item(i);
                if (file) {
                    const asset = rawFileToAsset.rawFileToAsset(file, constants.AssetSource.Computer);
                    assets.push(asset);
                }
            }
        }
        if (trackedLocation) {
            trackUsage('didSelectFile', {
                source: 'computer',
                location: trackedLocation
            });
        }
        onAddAssets(assets);
    };
    const handleDrop = (e)=>{
        e.preventDefault();
        if (e?.dataTransfer?.files) {
            const files = e.dataTransfer.files;
            const assets = [];
            for(let i = 0; i < files.length; i++){
                const file = files.item(i);
                if (file) {
                    const asset = rawFileToAsset.rawFileToAsset(file, constants.AssetSource.Computer);
                    assets.push(asset);
                }
            }
            onAddAssets(assets);
        }
        setDragOver(false);
    };
    return /*#__PURE__*/ jsxRuntime.jsxs("form", {
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                paddingLeft: 8,
                paddingRight: 8,
                paddingTop: 6,
                paddingBottom: 6,
                children: /*#__PURE__*/ jsxRuntime.jsx("label", {
                    children: /*#__PURE__*/ jsxRuntime.jsx(MediaBox, {
                        paddingTop: 11,
                        paddingBottom: 11,
                        hasRadius: true,
                        justifyContent: "center",
                        borderColor: dragOver ? 'primary500' : 'neutral300',
                        background: dragOver ? 'primary100' : 'neutral100',
                        position: "relative",
                        onDragEnter: handleDragEnter,
                        onDragLeave: handleDragLeave,
                        onDragOver: handleDragOver,
                        onDrop: handleDrop,
                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                            justifyContent: "center",
                            children: /*#__PURE__*/ jsxRuntime.jsxs(Wrapper, {
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(IconWrapper, {
                                        children: /*#__PURE__*/ jsxRuntime.jsx(icons.PlusCircle, {
                                            "aria-hidden": true,
                                            width: "3.2rem",
                                            height: "3.2rem"
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                        paddingTop: 3,
                                        paddingBottom: 5,
                                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                            variant: "delta",
                                            textColor: "neutral600",
                                            tag: "span",
                                            children: formatMessage({
                                                id: getTrad.getTrad('input.label'),
                                                defaultMessage: 'Drag & Drop here or'
                                            })
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(OpaqueBox, {
                                        tag: "input",
                                        position: "absolute",
                                        left: 0,
                                        right: 0,
                                        bottom: 0,
                                        top: 0,
                                        width: "100%",
                                        type: "file",
                                        multiple: true,
                                        name: "files",
                                        "aria-label": formatMessage({
                                            id: getTrad.getTrad('input.label'),
                                            defaultMessage: 'Drag & Drop here or'
                                        }),
                                        tabIndex: -1,
                                        ref: inputRef,
                                        zIndex: 1,
                                        onChange: handleChange
                                    })
                                ]
                            })
                        })
                    })
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Footer, {
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                    onClick: onClose,
                    variant: "tertiary",
                    children: formatMessage({
                        id: 'app.components.Button.cancel',
                        defaultMessage: 'cancel'
                    })
                })
            })
        ]
    });
};

exports.FromComputerForm = FromComputerForm;
//# sourceMappingURL=FromComputerForm.js.map
