import { jsx } from 'react/jsx-runtime';
import { Flex, Box } from '@strapi/design-system';
import { styled } from 'styled-components';
import { AssetType } from '../../../enums.mjs';
import { createAssetUrl } from '../../../utils/createAssetUrl.mjs';
import 'byte-size';
import 'date-fns';
import 'qs';
import '../../../utils/typeFromMime.mjs';
import '../../../utils/urlYupSchema.mjs';
import { getFileIconComponent } from '../../../utils/icons.mjs';
import { AudioPreview } from '../../AssetCard/AudioPreview.mjs';
import { VideoPreview } from '../../AssetCard/VideoPreview.mjs';

const DocAsset = styled(Flex)`
  background: linear-gradient(180deg, #ffffff 0%, #f6f6f9 121.48%);
`;
const VideoPreviewWrapper = styled(Box)`
  canvas,
  video {
    max-width: 100%;
    height: 124px;
  }
`;
const AudioPreviewWrapper = styled(Box)`
  canvas,
  audio {
    max-width: 100%;
  }
`;
const CarouselAsset = ({ asset })=>{
    if (asset.mime?.includes(AssetType.Video)) {
        return /*#__PURE__*/ jsx(VideoPreviewWrapper, {
            height: "100%",
            children: /*#__PURE__*/ jsx(VideoPreview, {
                url: createAssetUrl(asset, true),
                mime: asset.mime,
                alt: asset.alternativeText || asset.name
            })
        });
    }
    if (asset.mime?.includes(AssetType.Audio)) {
        return /*#__PURE__*/ jsx(AudioPreviewWrapper, {
            children: /*#__PURE__*/ jsx(AudioPreview, {
                url: createAssetUrl(asset, true),
                alt: asset.alternativeText || asset.name
            })
        });
    }
    if (asset.mime?.includes(AssetType.Image)) {
        const assetUrl = createAssetUrl(asset, true);
        if (!assetUrl) return null;
        // Adding a param to the url to bust the cache and force the refresh of the image when replaced
        // Only add updatedAt parameter if the URL is not signed to prevent signature invalidation
        const cacheBustedUrl = asset.isUrlSigned ? assetUrl : `${assetUrl}${assetUrl.includes('?') ? '&' : '?'}updatedAt=${asset.updatedAt}`;
        return /*#__PURE__*/ jsx(Box, {
            tag: "img",
            maxHeight: "100%",
            maxWidth: "100%",
            src: cacheBustedUrl,
            alt: asset.alternativeText || asset.name
        });
    }
    const IconComponent = getFileIconComponent(asset.ext);
    return /*#__PURE__*/ jsx(DocAsset, {
        width: "100%",
        height: "100%",
        justifyContent: "center",
        hasRadius: true,
        children: /*#__PURE__*/ jsx(IconComponent, {
            "aria-label": asset.alternativeText || asset.name,
            width: "24px",
            height: "32px"
        })
    });
};

export { CarouselAsset };
//# sourceMappingURL=CarouselAsset.mjs.map
