import { jsx, jsxs } from 'react/jsx-runtime';
import * as React from 'react';
import MuxPlayer from '@mux/mux-player-react';
import { Flex, Box, Typography } from '@strapi/design-system';
import { useIntl } from 'react-intl';
import { styled, useTheme } from 'styled-components';
import { AssetType } from '../../../enums.mjs';
import 'byte-size';
import 'date-fns';
import 'qs';
import { typeFromMime } from '../../../utils/typeFromMime.mjs';
import '../../../utils/urlYupSchema.mjs';
import { getFileIconComponent } from '../../../utils/icons.mjs';

const CardAsset = styled(Flex)`
  min-height: 26.4rem;
  border-radius: ${({ theme })=>theme.borderRadius} ${({ theme })=>theme.borderRadius} 0 0;
  background: linear-gradient(
    180deg,
    ${({ theme })=>theme.colors.neutral0} 0%,
    ${({ theme })=>theme.colors.neutral100} 121.48%
  );
`;
const AssetPreview = /*#__PURE__*/ React.forwardRef(({ mime, url, name, ...props }, ref)=>{
    const theme = useTheme();
    const assetType = typeFromMime(mime);
    const { formatMessage } = useIntl();
    if (assetType === AssetType.Image) {
        return /*#__PURE__*/ jsx("img", {
            ref: ref,
            src: url,
            alt: name,
            ...props
        });
    }
    if (assetType === AssetType.Video) {
        return /*#__PURE__*/ jsx(MuxPlayer, {
            src: url,
            accentColor: theme.colors.primary500
        });
    }
    if (assetType === AssetType.Audio) {
        return /*#__PURE__*/ jsx(Box, {
            margin: "5",
            children: /*#__PURE__*/ jsx("audio", {
                controls: true,
                src: url,
                ref: ref,
                ...props,
                children: name
            })
        });
    }
    // getFileIconComponent will handle all other file types, eg. PDF, CSV, XLS, ZIP
    // If the file type is not recognized, the default icon will be used
    const IconComponent = getFileIconComponent(assetType);
    return /*#__PURE__*/ jsx(CardAsset, {
        width: "100%",
        justifyContent: "center",
        ...props,
        children: /*#__PURE__*/ jsxs(Flex, {
            gap: 2,
            direction: "column",
            alignItems: "center",
            children: [
                /*#__PURE__*/ jsx(IconComponent, {
                    "aria-label": name,
                    fill: "neutral500",
                    width: 24,
                    height: 24
                }),
                /*#__PURE__*/ jsx(Typography, {
                    textColor: "neutral500",
                    variant: "pi",
                    children: formatMessage({
                        id: 'noPreview',
                        defaultMessage: 'No preview available'
                    })
                })
            ]
        })
    });
});
AssetPreview.displayName = 'AssetPreview';

export { AssetPreview };
//# sourceMappingURL=AssetPreview.mjs.map
