'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var formik = require('formik');
var isEqual = require('lodash/isEqual');
var reactIntl = require('react-intl');
var styledComponents = require('styled-components');
var yup = require('yup');
var useEditAsset = require('../../hooks/useEditAsset.js');
var useFolderStructure = require('../../hooks/useFolderStructure.js');
var useTracking = require('../../hooks/useTracking.js');
var findRecursiveFolderByValue = require('../../utils/findRecursiveFolderByValue.js');
var formatBytes = require('../../utils/formatBytes.js');
require('date-fns');
var getTrad = require('../../utils/getTrad.js');
require('qs');
var getFileExtension = require('../../utils/getFileExtension.js');
require('../../utils/typeFromMime.js');
require('../../utils/urlYupSchema.js');
var ContextInfo = require('../ContextInfo/ContextInfo.js');
var SelectTree = require('../SelectTree/SelectTree.js');
var DialogHeader = require('./DialogHeader.js');
var PreviewBox = require('./PreviewBox/PreviewBox.js');
var ReplaceMediaButton = require('./ReplaceMediaButton.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);
var yup__namespace = /*#__PURE__*/_interopNamespaceDefault(yup);

const LoadingBody = styledComponents.styled(designSystem.Flex)`
  /* 80px are coming from the Tabs component that is not included in the ModalBody */
  min-height: ${()=>`calc(60dvh + 8rem)`};
`;
const fileInfoSchema = yup__namespace.object({
    name: yup__namespace.string().required(),
    alternativeText: yup__namespace.string(),
    caption: yup__namespace.string(),
    folder: yup__namespace.number()
});
const EditAssetContent = ({ onClose, asset, canUpdate = false, canCopyLink = false, canDownload = false, trackedLocation, omitFields = [], omitActions = [] })=>{
    const { formatMessage, formatDate } = reactIntl.useIntl();
    const { trackUsage } = useTracking.useTracking();
    const submitButtonRef = React__namespace.useRef(null);
    const [isCropping, setIsCropping] = React__namespace.useState(false);
    const [replacementFile, setReplacementFile] = React__namespace.useState();
    const { editAsset, isLoading } = useEditAsset.useEditAsset();
    const { data: folderStructure, isLoading: folderStructureIsLoading } = useFolderStructure.useFolderStructure({
        enabled: true
    });
    const handleSubmit = async (values)=>{
        const nextAsset = {
            ...asset,
            ...values,
            folder: values.parent?.value
        };
        if (asset?.isLocal) {
            onClose(nextAsset);
        } else {
            const editedAsset = await editAsset(nextAsset, replacementFile);
            const assetType = asset?.mime?.split('/')[0];
            // if the folder parent was the root of Media Library, its id is null
            // we know it changed location if the new parent value exists
            const didChangeLocation = asset?.folder?.id ? asset.folder.id !== values.parent?.value : asset?.folder === null && !!values.parent?.value;
            trackUsage('didEditMediaLibraryElements', {
                location: trackedLocation,
                type: assetType,
                changeLocation: didChangeLocation
            });
            onClose(editedAsset);
        }
    };
    const handleStartCropping = ()=>{
        setIsCropping(true);
    };
    const handleCancelCropping = ()=>{
        setIsCropping(false);
    };
    const handleFinishCropping = ()=>{
        setIsCropping(false);
        onClose();
    };
    const formDisabled = !canUpdate || isCropping;
    const handleConfirmClose = ()=>{
        // eslint-disable-next-line no-alert
        const confirm = window.confirm(formatMessage({
            id: 'window.confirm.close-modal.file',
            defaultMessage: 'Are you sure? Your changes will be lost.'
        }));
        if (confirm) {
            onClose();
        }
    };
    const activeFolderId = asset?.folder?.id;
    const initialFormData = !folderStructureIsLoading && {
        name: asset?.name,
        alternativeText: asset?.alternativeText ?? undefined,
        caption: asset?.caption ?? undefined,
        parent: {
            value: activeFolderId ?? undefined,
            label: findRecursiveFolderByValue.findRecursiveFolderByValue(folderStructure, activeFolderId)?.label ?? folderStructure[0].label
        }
    };
    const handleClose = (values)=>{
        if (!isEqual(initialFormData, values)) {
            handleConfirmClose();
        } else {
            onClose();
        }
    };
    if (folderStructureIsLoading) {
        return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(DialogHeader.DialogHeader, {}),
                /*#__PURE__*/ jsxRuntime.jsx(LoadingBody, {
                    minHeight: "60vh",
                    justifyContent: "center",
                    paddingTop: 4,
                    paddingBottom: 4,
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Loader, {
                        children: formatMessage({
                            id: getTrad.getTrad('content.isLoading'),
                            defaultMessage: 'Content is loading.'
                        })
                    })
                }),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Footer, {
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                        onClick: ()=>handleClose(),
                        variant: "tertiary",
                        children: formatMessage({
                            id: 'cancel',
                            defaultMessage: 'Cancel'
                        })
                    })
                })
            ]
        });
    }
    return /*#__PURE__*/ jsxRuntime.jsx(formik.Formik, {
        validationSchema: fileInfoSchema,
        validateOnChange: false,
        onSubmit: handleSubmit,
        initialValues: initialFormData,
        children: ({ values, errors, handleChange, setFieldValue })=>/*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(DialogHeader.DialogHeader, {}),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Body, {
                        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Grid.Root, {
                            gap: 4,
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                    xs: 12,
                                    col: 6,
                                    direction: "column",
                                    alignItems: "stretch",
                                    children: /*#__PURE__*/ jsxRuntime.jsx(PreviewBox.PreviewBox, {
                                        asset: asset,
                                        canUpdate: canUpdate,
                                        canCopyLink: canCopyLink,
                                        canDownload: canDownload,
                                        onDelete: onClose,
                                        onCropFinish: handleFinishCropping,
                                        onCropStart: handleStartCropping,
                                        onCropCancel: handleCancelCropping,
                                        replacementFile: replacementFile,
                                        trackedLocation: trackedLocation
                                    })
                                }),
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                    xs: 12,
                                    col: 6,
                                    direction: "column",
                                    alignItems: "stretch",
                                    children: /*#__PURE__*/ jsxRuntime.jsxs(formik.Form, {
                                        noValidate: true,
                                        children: [
                                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                                direction: "column",
                                                alignItems: "stretch",
                                                gap: 3,
                                                children: [
                                                    /*#__PURE__*/ jsxRuntime.jsx(ContextInfo.ContextInfo, {
                                                        blocks: [
                                                            {
                                                                label: formatMessage({
                                                                    id: getTrad.getTrad('modal.file-details.size'),
                                                                    defaultMessage: 'Size'
                                                                }),
                                                                value: formatBytes.formatBytes(asset?.size ? asset.size : 0)
                                                            },
                                                            {
                                                                label: formatMessage({
                                                                    id: getTrad.getTrad('modal.file-details.dimensions'),
                                                                    defaultMessage: 'Dimensions'
                                                                }),
                                                                value: asset?.height && asset.width ? `${asset.width}✕${asset.height}` : null
                                                            },
                                                            {
                                                                label: formatMessage({
                                                                    id: getTrad.getTrad('modal.file-details.date'),
                                                                    defaultMessage: 'Date'
                                                                }),
                                                                value: formatDate(new Date(asset?.createdAt ? asset.createdAt : ''))
                                                            },
                                                            {
                                                                label: formatMessage({
                                                                    id: getTrad.getTrad('modal.file-details.extension'),
                                                                    defaultMessage: 'Extension'
                                                                }),
                                                                value: getFileExtension.getFileExtension(asset?.ext)
                                                            },
                                                            {
                                                                label: formatMessage({
                                                                    id: getTrad.getTrad('modal.file-details.id'),
                                                                    defaultMessage: 'Asset ID'
                                                                }),
                                                                value: asset?.id ? asset.id : null
                                                            }
                                                        ]
                                                    }),
                                                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
                                                        name: "name",
                                                        error: errors.name,
                                                        children: [
                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                                                                children: formatMessage({
                                                                    id: getTrad.getTrad('form.input.label.file-name'),
                                                                    defaultMessage: 'File name'
                                                                })
                                                            }),
                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.TextInput, {
                                                                value: values.name,
                                                                onChange: handleChange,
                                                                disabled: formDisabled,
                                                                type: "text"
                                                            }),
                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Error, {})
                                                        ]
                                                    }),
                                                    !omitFields?.includes('alternativeText') && /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
                                                        name: "alternativeText",
                                                        hint: formatMessage({
                                                            id: getTrad.getTrad('form.input.description.file-alt'),
                                                            defaultMessage: 'This text will be displayed if the asset can’t be shown.'
                                                        }),
                                                        error: errors.alternativeText,
                                                        children: [
                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                                                                children: formatMessage({
                                                                    id: getTrad.getTrad('form.input.label.file-alt'),
                                                                    defaultMessage: 'Alternative text'
                                                                })
                                                            }),
                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.TextInput, {
                                                                value: values.alternativeText,
                                                                onChange: handleChange,
                                                                disabled: formDisabled,
                                                                type: "text"
                                                            }),
                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Hint, {}),
                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Error, {})
                                                        ]
                                                    }),
                                                    !omitFields?.includes('caption') && /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
                                                        name: "caption",
                                                        error: errors.caption,
                                                        children: [
                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                                                                children: formatMessage({
                                                                    id: getTrad.getTrad('form.input.label.file-caption'),
                                                                    defaultMessage: 'Caption'
                                                                })
                                                            }),
                                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.TextInput, {
                                                                value: values.caption,
                                                                onChange: handleChange,
                                                                disabled: formDisabled,
                                                                type: "text"
                                                            })
                                                        ]
                                                    }),
                                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                                        direction: "column",
                                                        alignItems: "stretch",
                                                        gap: 1,
                                                        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
                                                            name: "parent",
                                                            id: "asset-folder",
                                                            children: [
                                                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                                                                    children: formatMessage({
                                                                        id: getTrad.getTrad('form.input.label.file-location'),
                                                                        defaultMessage: 'Location'
                                                                    })
                                                                }),
                                                                /*#__PURE__*/ jsxRuntime.jsx(SelectTree.SelectTree, {
                                                                    name: "parent",
                                                                    defaultValue: values.parent,
                                                                    options: folderStructure,
                                                                    onChange: (value)=>{
                                                                        setFieldValue('parent', value);
                                                                    },
                                                                    menuPortalTarget: document.querySelector('body'),
                                                                    inputId: "asset-folder",
                                                                    isDisabled: formDisabled,
                                                                    error: errors?.parent,
                                                                    ariaErrorMessage: "folder-parent-error"
                                                                })
                                                            ]
                                                        })
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.VisuallyHidden, {
                                                children: /*#__PURE__*/ jsxRuntime.jsx("button", {
                                                    type: "submit",
                                                    tabIndex: -1,
                                                    ref: submitButtonRef,
                                                    disabled: formDisabled,
                                                    children: formatMessage({
                                                        id: 'submit',
                                                        defaultMessage: 'Submit'
                                                    })
                                                })
                                            })
                                        ]
                                    })
                                })
                            ]
                        })
                    }),
                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Modal.Footer, {
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                                onClick: ()=>handleClose({
                                        ...values
                                    }),
                                variant: "tertiary",
                                children: formatMessage({
                                    id: 'global.cancel',
                                    defaultMessage: 'Cancel'
                                })
                            }),
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                gap: 2,
                                children: [
                                    !omitActions?.includes('replace') && /*#__PURE__*/ jsxRuntime.jsx(ReplaceMediaButton.ReplaceMediaButton, {
                                        onSelectMedia: setReplacementFile,
                                        acceptedMime: asset?.mime ?? '',
                                        disabled: formDisabled,
                                        trackedLocation: trackedLocation
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                                        onClick: ()=>submitButtonRef.current?.click(),
                                        loading: isLoading,
                                        disabled: formDisabled,
                                        children: formatMessage({
                                            id: 'global.finish',
                                            defaultMessage: 'Finish'
                                        })
                                    })
                                ]
                            })
                        ]
                    })
                ]
            })
    });
};
const EditAssetDialog = ({ open, onClose, canUpdate = false, canCopyLink = false, canDownload = false, ...restProps })=>{
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Root, {
        open: open,
        onOpenChange: onClose,
        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Content, {
            children: /*#__PURE__*/ jsxRuntime.jsx(EditAssetContent, {
                onClose: onClose,
                canUpdate: canUpdate,
                canCopyLink: canCopyLink,
                canDownload: canDownload,
                ...restProps
            })
        })
    });
};

exports.EditAssetContent = EditAssetContent;
exports.EditAssetDialog = EditAssetDialog;
//# sourceMappingURL=EditAssetContent.js.map
