'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var reactIntl = require('react-intl');
var styledComponents = require('styled-components');
var useAssets = require('../../hooks/useAssets.js');
var useFolders = require('../../hooks/useFolders.js');
var useMediaLibraryPermissions = require('../../hooks/useMediaLibraryPermissions.js');
var useModalQueryParams = require('../../hooks/useModalQueryParams.js');
var useSelectionState = require('../../hooks/useSelectionState.js');
var containsAssetFilter = require('../../utils/containsAssetFilter.js');
require('byte-size');
require('date-fns');
var getAllowedFiles = require('../../utils/getAllowedFiles.js');
var getTrad = require('../../utils/getTrad.js');
require('qs');
var moveElement = require('../../utils/moveElement.js');
require('../../utils/typeFromMime.js');
require('../../utils/urlYupSchema.js');
var EditAssetContent = require('../EditAssetDialog/EditAssetContent.js');
var EditFolderDialog = require('../EditFolderDialog/EditFolderDialog.js');
var BrowseStep = require('./BrowseStep/BrowseStep.js');
var DialogFooter = require('./DialogFooter.js');
var SelectedStep = require('./SelectedStep/SelectedStep.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

// TODO: find a better naming convention for the file that was an index file before
const LoadingBody = styledComponents.styled(designSystem.Flex)`
  /* 80px are coming from the Tabs component that is not included in the ModalBody */
  min-height: ${()=>`calc(60dvh + 8rem)`};
`;
const AssetContent = ({ allowedTypes = [], folderId = null, onClose, onAddAsset, onAddFolder, onChangeFolder, onValidate, multiple = false, initiallySelectedAssets = [], trackedLocation })=>{
    const [assetToEdit, setAssetToEdit] = React__namespace.useState(undefined);
    const [folderToEdit, setFolderToEdit] = React__namespace.useState(undefined);
    const { formatMessage } = reactIntl.useIntl();
    const { canRead, canCreate, isLoading: isLoadingPermissions, canUpdate, canCopyLink, canDownload } = useMediaLibraryPermissions.useMediaLibraryPermissions();
    const [{ queryObject }, { onChangeFilters, onChangePage, onChangePageSize, onChangeSort, onChangeSearch, onChangeFolder: onChangeFolderParam }] = useModalQueryParams.useModalQueryParams({
        folder: folderId
    });
    const { data: { pagination, results: assets } = {}, isLoading: isLoadingAssets, error: errorAssets } = useAssets.useAssets({
        skipWhen: !canRead,
        query: queryObject
    });
    const { data: folders, isLoading: isLoadingFolders, error: errorFolders } = useFolders.useFolders({
        enabled: canRead && !containsAssetFilter.containsAssetFilter(queryObject) && pagination?.page === 1,
        query: queryObject
    });
    const [selectedAssets, { selectOne, selectOnly, setSelections, selectMultiple, deselectMultiple }] = useSelectionState.useSelectionState([
        'id'
    ], initiallySelectedAssets);
    const handleSelectAllAssets = ()=>{
        const allowedAssets = getAllowedFiles.getAllowedFiles(allowedTypes, assets);
        if (!multiple) {
            return undefined;
        }
        // selected files in current folder
        const alreadySelected = allowedAssets.filter((asset)=>selectedAssets.findIndex((selectedAsset)=>selectedAsset.id === asset.id) !== -1);
        if (alreadySelected.length > 0) {
            deselectMultiple(alreadySelected);
        } else {
            selectMultiple(allowedAssets);
        }
    };
    const handleSelectAsset = (asset)=>{
        return multiple ? selectOne(asset) : selectOnly(asset);
    };
    const isLoading = isLoadingPermissions || isLoadingAssets || isLoadingFolders;
    const hasError = errorAssets || errorFolders;
    const [activeTab, setActiveTab] = React__namespace.useState(selectedAssets.length > 0 ? 'selected' : 'browse');
    if (isLoading) {
        return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Header, {
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Title, {
                        children: formatMessage({
                            id: getTrad.getTrad('header.actions.add-assets'),
                            defaultMessage: 'Add new assets'
                        })
                    })
                }),
                /*#__PURE__*/ jsxRuntime.jsx(LoadingBody, {
                    justifyContent: "center",
                    paddingTop: 4,
                    paddingBottom: 4,
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Loader, {
                        children: formatMessage({
                            id: getTrad.getTrad('content.isLoading'),
                            defaultMessage: 'Content is loading.'
                        })
                    })
                }),
                /*#__PURE__*/ jsxRuntime.jsx(DialogFooter.DialogFooter, {
                    onClose: onClose
                })
            ]
        });
    }
    if (hasError) {
        return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Header, {
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Title, {
                        children: formatMessage({
                            id: getTrad.getTrad('header.actions.add-assets'),
                            defaultMessage: 'Add new assets'
                        })
                    })
                }),
                /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Error, {}),
                /*#__PURE__*/ jsxRuntime.jsx(DialogFooter.DialogFooter, {
                    onClose: onClose
                })
            ]
        });
    }
    if (!canRead) {
        return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Header, {
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Title, {
                        children: formatMessage({
                            id: getTrad.getTrad('header.actions.add-assets'),
                            defaultMessage: 'Add new assets'
                        })
                    })
                }),
                /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.NoPermissions, {}),
                /*#__PURE__*/ jsxRuntime.jsx(DialogFooter.DialogFooter, {
                    onClose: onClose
                })
            ]
        });
    }
    if (assetToEdit) {
        return /*#__PURE__*/ jsxRuntime.jsx(EditAssetContent.EditAssetContent, {
            onClose: ()=>setAssetToEdit(undefined),
            asset: assetToEdit,
            canUpdate: canUpdate,
            canCopyLink: canCopyLink,
            canDownload: canDownload,
            trackedLocation: trackedLocation
        });
    }
    if (folderToEdit) {
        return /*#__PURE__*/ jsxRuntime.jsx(EditFolderDialog.EditFolderContent, {
            folder: folderToEdit,
            onClose: ()=>setFolderToEdit(undefined),
            location: "content-manager",
            parentFolderId: queryObject?.folder
        });
    }
    const handleMoveItem = (hoverIndex, destIndex)=>{
        const offset = destIndex - hoverIndex;
        const orderedAssetsClone = selectedAssets.slice();
        const nextAssets = moveElement.moveElement(orderedAssetsClone, hoverIndex, offset);
        setSelections(nextAssets);
    };
    const handleFolderChange = (folderId, folderPath)=>{
        onChangeFolder(folderId);
        if (onChangeFolderParam) {
            onChangeFolderParam(folderId, folderPath);
        }
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Header, {
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Title, {
                    children: formatMessage({
                        id: getTrad.getTrad('header.actions.add-assets'),
                        defaultMessage: 'Add new assets'
                    })
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsxs(TabsRoot, {
                variant: "simple",
                value: activeTab,
                onValueChange: setActiveTab,
                children: [
                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                        paddingLeft: 8,
                        paddingRight: 8,
                        paddingTop: 6,
                        justifyContent: "space-between",
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Tabs.List, {
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tabs.Trigger, {
                                        value: "browse",
                                        children: formatMessage({
                                            id: getTrad.getTrad('modal.nav.browse'),
                                            defaultMessage: 'Browse'
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Tabs.Trigger, {
                                        value: "selected",
                                        children: [
                                            formatMessage({
                                                id: getTrad.getTrad('modal.header.select-files'),
                                                defaultMessage: 'Selected files'
                                            }),
                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Badge, {
                                                marginLeft: 2,
                                                children: selectedAssets.length
                                            })
                                        ]
                                    })
                                ]
                            }),
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                gap: 2,
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                                        variant: "secondary",
                                        onClick: ()=>onAddFolder({
                                                folderId: queryObject?.folder
                                            }),
                                        children: formatMessage({
                                            id: getTrad.getTrad('modal.upload-list.sub-header.add-folder'),
                                            defaultMessage: 'Add folder'
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                                        onClick: ()=>onAddAsset({
                                                folderId: queryObject?.folder
                                            }),
                                        children: formatMessage({
                                            id: getTrad.getTrad('modal.upload-list.sub-header.button'),
                                            defaultMessage: 'Add more assets'
                                        })
                                    })
                                ]
                            })
                        ]
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Divider, {}),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.ScrollArea, {
                        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Modal.Body, {
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tabs.Content, {
                                    value: "browse",
                                    children: /*#__PURE__*/ jsxRuntime.jsx(BrowseStep.BrowseStep, {
                                        allowedTypes: allowedTypes,
                                        assets: assets,
                                        canCreate: canCreate,
                                        canRead: canRead,
                                        folders: folders,
                                        onSelectAsset: handleSelectAsset,
                                        selectedAssets: selectedAssets,
                                        multiple: multiple,
                                        onSelectAllAsset: handleSelectAllAssets,
                                        onEditAsset: setAssetToEdit,
                                        onEditFolder: setFolderToEdit,
                                        pagination: pagination,
                                        queryObject: queryObject,
                                        onAddAsset: onAddAsset,
                                        onChangeFilters: (filters)=>onChangeFilters(filters),
                                        onChangeFolder: handleFolderChange,
                                        onChangePage: onChangePage,
                                        onChangePageSize: onChangePageSize,
                                        onChangeSort: (sort)=>onChangeSort(sort),
                                        onChangeSearch: onChangeSearch
                                    })
                                }),
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tabs.Content, {
                                    value: "selected",
                                    children: /*#__PURE__*/ jsxRuntime.jsx(SelectedStep.SelectedStep, {
                                        selectedAssets: selectedAssets,
                                        onSelectAsset: handleSelectAsset,
                                        onReorderAsset: handleMoveItem
                                    })
                                })
                            ]
                        })
                    })
                ]
            }),
            /*#__PURE__*/ jsxRuntime.jsx(DialogFooter.DialogFooter, {
                onClose: onClose,
                onValidate: ()=>onValidate(selectedAssets)
            })
        ]
    });
};
const AssetDialog = ({ open = false, onClose, ...restProps })=>{
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Root, {
        open: open,
        onOpenChange: onClose,
        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Content, {
            children: /*#__PURE__*/ jsxRuntime.jsx(AssetContent, {
                onClose: onClose,
                ...restProps
            })
        })
    });
};
const TabsRoot = styledComponents.styled(designSystem.Tabs.Root)`
  display: flex;
  flex-direction: column;
  overflow: hidden;
`;

exports.AssetContent = AssetContent;
exports.AssetDialog = AssetDialog;
//# sourceMappingURL=AssetDialog.js.map
