'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var reactIntl = require('react-intl');
var styledComponents = require('styled-components');
var AudioPreview = require('../../components/AssetCard/AudioPreview.js');
var VideoPreview = require('../../components/AssetCard/VideoPreview.js');
var EditAssetContent = require('../../components/EditAssetDialog/EditAssetContent.js');
var enums = require('../../enums.js');
var useMediaLibraryPermissions = require('../../hooks/useMediaLibraryPermissions.js');
var useRemoveAsset = require('../../hooks/useRemoveAsset.js');
var prefixFileUrlWithBackendUrl = require('../../utils/prefixFileUrlWithBackendUrl.js');
var formatBytes = require('../../utils/formatBytes.js');
var formatDuration = require('../../utils/formatDuration.js');
var getTrad = require('../../utils/getTrad.js');
require('qs');
var getFileExtension = require('../../utils/getFileExtension.js');
var typeFromMime = require('../../utils/typeFromMime.js');
require('../../utils/urlYupSchema.js');
var AIUploadModal = require('./AIUploadModal.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const CardActionsContainer = styledComponents.styled(designSystem.CardAction)`
  opacity: 0;
  z-index: 1;

  &:focus-within {
    opacity: 1;
  }
`;
const CardContainer = styledComponents.styled(designSystem.Box)`
  background: ${({ theme })=>theme.colors.neutral0};
  border: 1px solid ${({ theme })=>theme.colors.neutral150};
  border-radius: ${({ theme })=>theme.borderRadius};

  &:hover {
    ${CardActionsContainer} {
      opacity: 1;
    }
  }
`;
/* -------------------------------------------------------------------------------------------------
 * AssetCardActions
 * -----------------------------------------------------------------------------------------------*/ const AssetCardActions = ({ asset })=>{
    const { formatMessage } = reactIntl.useIntl();
    const dispatch = AIUploadModal.useAIUploadModalContext('AssetCardActions', (s)=>s.dispatch);
    const state = AIUploadModal.useAIUploadModalContext('AssetCardActions', (s)=>s.state);
    const onClose = AIUploadModal.useAIUploadModalContext('AssetCardActions', (s)=>s.onClose);
    const { canUpdate, canCopyLink, canDownload } = useMediaLibraryPermissions.useMediaLibraryPermissions();
    const [isEditModalOpen, setIsEditModalOpen] = React__namespace.useState(false);
    const { removeAsset } = useRemoveAsset.useRemoveAsset(()=>{});
    const handleConfirmRemove = async (event)=>{
        event?.preventDefault();
        await removeAsset(asset.id);
        dispatch({
            type: 'remove_uploaded_asset',
            payload: {
                id: asset.id
            }
        });
        // Close modal if this was the last asset
        if (state.uploadedAssets.length === 1) {
            onClose();
        }
    };
    const handlePropagationClick = (event)=>{
        event.stopPropagation();
    };
    const handleEditAsset = (editedAsset)=>{
        if (editedAsset) {
            dispatch({
                type: 'edit_uploaded_asset',
                payload: {
                    editedAsset
                }
            });
            setIsEditModalOpen(false);
        }
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(CardActionsContainer, {
        onClick: handlePropagationClick,
        position: "end",
        children: [
            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Dialog.Root, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Dialog.Trigger, {
                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                            label: formatMessage({
                                id: getTrad.getTrad('control-card.remove-selection'),
                                defaultMessage: 'Remove from selection'
                            }),
                            children: /*#__PURE__*/ jsxRuntime.jsx(icons.Trash, {})
                        })
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.ConfirmDialog, {
                        onConfirm: handleConfirmRemove
                    })
                ]
            }),
            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Modal.Root, {
                open: isEditModalOpen,
                onOpenChange: setIsEditModalOpen,
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Trigger, {
                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                            label: formatMessage({
                                id: getTrad.getTrad('control-card.edit'),
                                defaultMessage: 'Edit'
                            }),
                            children: /*#__PURE__*/ jsxRuntime.jsx(icons.Pencil, {})
                        })
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Content, {
                        children: /*#__PURE__*/ jsxRuntime.jsx(EditAssetContent.EditAssetContent, {
                            // Is Local must be set to false to trigger the correct branch of logic in the EditAssetContent on submit
                            asset: {
                                ...asset,
                                isLocal: false,
                                folder: typeof asset.folder === 'number' ? {
                                    id: asset.folder
                                } : asset.folder
                            },
                            onClose: (arg)=>handleEditAsset(arg),
                            canUpdate: canUpdate,
                            canCopyLink: canCopyLink,
                            canDownload: canDownload,
                            omitFields: [
                                'caption',
                                'alternativeText'
                            ],
                            omitActions: [
                                'replace'
                            ]
                        })
                    })
                ]
            })
        ]
    });
};
const Extension = styledComponents.styled.span`
  text-transform: uppercase;
`;
const VideoPreviewWrapper = styledComponents.styled(designSystem.Box)`
  position: relative;
  height: 100%;
  overflow: hidden;

  canvas,
  video {
    display: block;
    pointer-events: none;
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: ${({ theme })=>theme.borderRadius};
  }
`;
const VideoTimerOverlay = styledComponents.styled(designSystem.CardTimer)`
  position: absolute;
  bottom: 0.5rem;
  right: 0.5rem;
`;
const AudioPreviewWrapper = styledComponents.styled(designSystem.Box)`
  height: 100%;
  overflow: hidden;
  display: flex;
  align-items: center;
  justify-content: center;

  canvas,
  audio {
    display: block;
    max-width: 100%;
    max-height: 100%;
  }
`;
const Asset = ({ assetType, thumbnailUrl, assetUrl, asset })=>{
    const [duration, setDuration] = React__namespace.useState();
    const formattedDuration = duration ? formatDuration.formatDuration(duration) : undefined;
    switch(assetType){
        case enums.AssetType.Image:
            return /*#__PURE__*/ jsxRuntime.jsx(designSystem.CardAsset, {
                src: thumbnailUrl,
                size: "S",
                alt: asset.alternativeText || asset.name
            });
        case enums.AssetType.Video:
            return /*#__PURE__*/ jsxRuntime.jsx(designSystem.CardAsset, {
                size: "S",
                children: /*#__PURE__*/ jsxRuntime.jsxs(VideoPreviewWrapper, {
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsx(VideoPreview.VideoPreview, {
                            url: assetUrl,
                            mime: asset.mime || 'video/mp4',
                            onLoadDuration: setDuration,
                            alt: asset.alternativeText || asset.name
                        }),
                        formattedDuration && /*#__PURE__*/ jsxRuntime.jsx(VideoTimerOverlay, {
                            children: formattedDuration
                        })
                    ]
                })
            });
        case enums.AssetType.Audio:
            return /*#__PURE__*/ jsxRuntime.jsx(designSystem.CardAsset, {
                size: "S",
                children: /*#__PURE__*/ jsxRuntime.jsx(AudioPreviewWrapper, {
                    children: /*#__PURE__*/ jsxRuntime.jsx(AudioPreview.AudioPreview, {
                        url: assetUrl,
                        alt: asset.alternativeText || asset.name
                    })
                })
            });
        default:
            return /*#__PURE__*/ jsxRuntime.jsx(designSystem.CardAsset, {
                src: thumbnailUrl,
                size: "S",
                alt: asset.alternativeText || asset.name
            });
    }
};
/* -------------------------------------------------------------------------------------------------
 * AssetCard
 * -----------------------------------------------------------------------------------------------*/ const StyledCardBody = styledComponents.styled(designSystem.CardBody)`
  display: flex;
  padding: ${({ theme })=>theme.spaces[2]} ${({ theme })=>theme.spaces[1]};
`;
const StyledCard = styledComponents.styled(designSystem.Card)`
  width: 100%;
  height: 100%;
  border: none;
  box-shadow: none;
  border-radius: 0;
  padding: 0;
`;
const getAssetBadgeLabel = (assetType)=>{
    switch(assetType){
        case enums.AssetType.Image:
            return {
                id: getTrad.getTrad('settings.section.image.label'),
                defaultMessage: 'IMAGE'
            };
        case enums.AssetType.Video:
            return {
                id: getTrad.getTrad('settings.section.video.label'),
                defaultMessage: 'VIDEO'
            };
        case enums.AssetType.Audio:
            return {
                id: getTrad.getTrad('settings.section.audio.label'),
                defaultMessage: 'AUDIO'
            };
        case enums.DocType.Pdf:
            return {
                id: getTrad.getTrad('settings.section.pdf.label'),
                defaultMessage: 'PDF'
            };
        case enums.DocType.Csv:
            return {
                id: getTrad.getTrad('settings.section.csv.label'),
                defaultMessage: 'CSV'
            };
        case enums.DocType.Xls:
            return {
                id: getTrad.getTrad('settings.section.xls.label'),
                defaultMessage: 'XLS'
            };
        case enums.DocType.Zip:
            return {
                id: getTrad.getTrad('settings.section.zip.label'),
                defaultMessage: 'ZIP'
            };
        default:
            return {
                id: getTrad.getTrad('settings.section.doc.label'),
                defaultMessage: 'DOC'
            };
    }
};
const AIAssetCard = ({ asset, onCaptionChange, onAltTextChange, wasAltTextChanged, wasCaptionChanged })=>{
    const { formatMessage } = reactIntl.useIntl();
    const assetType = typeFromMime.typeFromMime(asset.mime || '');
    const thumbnailUrl = prefixFileUrlWithBackendUrl.prefixFileUrlWithBackendUrl(asset?.formats?.thumbnail?.url || asset.url) || '';
    const assetUrl = prefixFileUrlWithBackendUrl.prefixFileUrlWithBackendUrl(asset.url) || '';
    const subtitle = asset.height && asset.width ? ` - ${asset.width}x${asset.height}` : '';
    const formattedSize = asset.size ? formatBytes.formatBytes(asset.size) : '';
    const fullSubtitle = `${subtitle}${subtitle && formattedSize ? ' - ' : ''}${formattedSize}`;
    const [caption, setCaption] = React__namespace.useState(asset.caption || '');
    React__namespace.useEffect(()=>{
        onCaptionChange(caption);
    }, [
        caption,
        onCaptionChange
    ]);
    const [altText, setAltText] = React__namespace.useState(asset.alternativeText || '');
    React__namespace.useEffect(()=>{
        onAltTextChange(altText);
    }, [
        altText,
        onAltTextChange
    ]);
    return /*#__PURE__*/ jsxRuntime.jsx(CardContainer, {
        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Grid.Root, {
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                    m: 5,
                    xs: 12,
                    alignItems: "stretch",
                    children: /*#__PURE__*/ jsxRuntime.jsxs(StyledCard, {
                        width: "100%",
                        height: "100%",
                        shadow: "none",
                        borderRadius: 0,
                        padding: 0,
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.CardHeader, {
                                style: {
                                    borderStyle: 'none'
                                },
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(AssetCardActions, {
                                        asset: asset
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(Asset, {
                                        assetType: assetType,
                                        thumbnailUrl: thumbnailUrl,
                                        assetUrl: assetUrl,
                                        asset: asset
                                    })
                                ]
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(StyledCardBody, {
                                children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.CardContent, {
                                    width: "100%",
                                    children: [
                                        /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                            justifyContent: "space-between",
                                            alignItems: "start",
                                            children: [
                                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                                    tag: "h2",
                                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.CardTitle, {
                                                        tag: "span",
                                                        children: asset.name
                                                    })
                                                }),
                                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.CardBadge, {
                                                    children: formatMessage(getAssetBadgeLabel(assetType))
                                                })
                                            ]
                                        }),
                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.CardSubtitle, {
                                                children: [
                                                    /*#__PURE__*/ jsxRuntime.jsx(Extension, {
                                                        children: getFileExtension.getFileExtension(asset.ext)
                                                    }),
                                                    fullSubtitle
                                                ]
                                            })
                                        })
                                    ]
                                })
                            })
                        ]
                    })
                }),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                    m: 7,
                    xs: 12,
                    flex: 1,
                    children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                        direction: "column",
                        height: "100%",
                        alignItems: "stretch",
                        flex: 1,
                        padding: 4,
                        gap: 2,
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
                                name: "caption",
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                        alignItems: "center",
                                        gap: 2,
                                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                                            children: formatMessage({
                                                id: getTrad.getTrad('form.input.label.file-caption'),
                                                defaultMessage: 'Caption'
                                            })
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.TextInput, {
                                        value: caption,
                                        onChange: (e)=>setCaption(e.target.value),
                                        placeholder: formatMessage({
                                            id: getTrad.getTrad('form.input.placeholder.file-caption'),
                                            defaultMessage: 'Enter caption'
                                        }),
                                        endAction: !wasCaptionChanged && asset.caption && /*#__PURE__*/ jsxRuntime.jsx(icons.Sparkle, {
                                            width: "16px",
                                            height: "16px",
                                            fill: "#AC73E6"
                                        }),
                                        type: "text"
                                    })
                                ]
                            }),
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
                                name: "alternativeText",
                                hint: formatMessage({
                                    id: getTrad.getTrad('form.input.description.file-alt'),
                                    defaultMessage: "This text will be displayed if the asset can't be shown."
                                }),
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                                        alignItems: "center",
                                        gap: 2,
                                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                                            children: formatMessage({
                                                id: getTrad.getTrad('form.input.label.file-alt'),
                                                defaultMessage: 'Alternative text'
                                            })
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.TextInput, {
                                        value: altText,
                                        onChange: (e)=>setAltText(e.target.value),
                                        placeholder: formatMessage({
                                            id: getTrad.getTrad('form.input.placeholder.file-alt'),
                                            defaultMessage: 'Enter alternative text'
                                        }),
                                        endAction: !wasAltTextChanged && asset.alternativeText && /*#__PURE__*/ jsxRuntime.jsx(icons.Sparkle, {
                                            width: "16px",
                                            height: "16px",
                                            fill: "#AC73E6"
                                        }),
                                        type: "text"
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Hint, {})
                                ]
                            })
                        ]
                    })
                })
            ]
        })
    });
};
/* -------------------------------------------------------------------------------------------------
 * AssetCardSkeletons
 * -----------------------------------------------------------------------------------------------*/ const SkeletonBox = styledComponents.styled(designSystem.Box)`
  background: linear-gradient(
    90deg,
    ${({ theme })=>theme.colors.neutral100} 25%,
    ${({ theme })=>theme.colors.neutral150} 50%,
    ${({ theme })=>theme.colors.neutral100} 75%
  );
  background-size: 200% 100%;
  animation: loading 1.5s infinite;
  border-radius: ${({ theme })=>theme.borderRadius};
  width: ${({ width })=>width || '100%'};
  height: ${({ height })=>height || '1rem'};

  @keyframes loading {
    0% {
      background-position: 200% 0;
    }
    100% {
      background-position: -200% 0;
    }
  }
`;
const AIAssetCardSkeletons = ({ count = 1 })=>{
    const skeletons = Array.from({
        length: count
    }, (_, i)=>i);
    return skeletons.map((index)=>/*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
            background: "neutral0",
            borderColor: "neutral150",
            borderStyle: "solid",
            borderWidth: "1px",
            borderRadius: "4px",
            marginBottom: 4,
            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Grid.Root, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                        col: 5,
                        alignItems: "stretch",
                        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Card, {
                            height: "100%",
                            width: "100%",
                            borderStyle: "none",
                            shadow: "none",
                            borderRadius: 0,
                            padding: 2,
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                    height: "150px",
                                    padding: 2,
                                    children: /*#__PURE__*/ jsxRuntime.jsx(SkeletonBox, {
                                        height: "100%"
                                    })
                                }),
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.CardBody, {
                                    style: {
                                        display: 'flex',
                                        padding: '8px 4px'
                                    },
                                    children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.CardContent, {
                                        width: "100%",
                                        children: [
                                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                                justifyContent: "space-between",
                                                alignItems: "start",
                                                marginBottom: 1,
                                                children: [
                                                    /*#__PURE__*/ jsxRuntime.jsx(SkeletonBox, {
                                                        width: "60%",
                                                        height: "18px"
                                                    }),
                                                    /*#__PURE__*/ jsxRuntime.jsx(SkeletonBox, {
                                                        width: "40px",
                                                        height: "16px"
                                                    })
                                                ]
                                            }),
                                            /*#__PURE__*/ jsxRuntime.jsx(SkeletonBox, {
                                                width: "80%",
                                                height: "14px"
                                            })
                                        ]
                                    })
                                })
                            ]
                        })
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                        m: 7,
                        xs: 12,
                        flex: 1,
                        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                            direction: "column",
                            height: "100%",
                            alignItems: "stretch",
                            flex: 1,
                            padding: 4,
                            gap: 2,
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Box, {
                                    children: [
                                        /*#__PURE__*/ jsxRuntime.jsx(SkeletonBox, {
                                            width: "60px",
                                            height: "16px",
                                            marginBottom: 1
                                        }),
                                        /*#__PURE__*/ jsxRuntime.jsx(SkeletonBox, {
                                            height: "32px"
                                        })
                                    ]
                                }),
                                /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Box, {
                                    children: [
                                        /*#__PURE__*/ jsxRuntime.jsx(SkeletonBox, {
                                            width: "100px",
                                            height: "16px",
                                            marginBottom: 1
                                        }),
                                        /*#__PURE__*/ jsxRuntime.jsx(SkeletonBox, {
                                            height: "32px"
                                        }),
                                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                            marginTop: 1,
                                            children: /*#__PURE__*/ jsxRuntime.jsx(SkeletonBox, {
                                                width: "70%",
                                                height: "12px"
                                            })
                                        })
                                    ]
                                })
                            ]
                        })
                    })
                ]
            })
        }, index));
};

exports.AIAssetCard = AIAssetCard;
exports.AIAssetCardSkeletons = AIAssetCardSkeletons;
//# sourceMappingURL=AIAssetCard.js.map
