import { jsx as p, jsxs as ye, Fragment as Se } from "react/jsx-runtime";
import * as s from "react";
import { useComposedRefs as A } from "@radix-ui/react-compose-refs";
import { createContextScope as st, createContext as it } from "@radix-ui/react-context";
import { Slot as Ee } from "@radix-ui/react-slot";
import { composeEventHandlers as E } from "@radix-ui/primitive";
import { DismissableLayer as ct } from "@radix-ui/react-dismissable-layer";
import { useFocusGuards as at } from "@radix-ui/react-focus-guards";
import { FocusScope as ut } from "@radix-ui/react-focus-scope";
import { useId as se } from "@radix-ui/react-id";
import * as ie from "@radix-ui/react-popper";
import { createPopperScope as dt } from "@radix-ui/react-popper";
import { Portal as pt } from "@radix-ui/react-portal";
import { Primitive as N } from "@radix-ui/react-primitive";
import { useControllableState as de } from "@radix-ui/react-use-controllable-state";
import { useLayoutEffect as $ } from "@radix-ui/react-use-layout-effect";
import { hideOthers as ft } from "aria-hidden";
import * as we from "react-dom";
import { RemoveScroll as mt } from "react-remove-scroll";
import { useVirtualizer as jt } from "@tanstack/react-virtual";
import { clamp as rt } from "@radix-ui/number";
import { createCollection as Yt } from "@radix-ui/react-collection";
import { useDirection as qt } from "@radix-ui/react-direction";
import { usePrevious as Xt } from "@radix-ui/react-use-previous";
import { VisuallyHidden as Zt } from "@radix-ui/react-visually-hidden";
function Jt(o) {
  const i = `${o}CollectionProvider`, [e, t] = st(i), [n, r] = e(i, {
    collectionRef: { current: null },
    itemMap: /* @__PURE__ */ new Map(),
    listeners: /* @__PURE__ */ new Set()
  }), c = (u) => {
    const { scope: f, children: m } = u, b = s.useRef(null), g = s.useRef(/* @__PURE__ */ new Map()).current, d = s.useRef(/* @__PURE__ */ new Set()).current;
    return /* @__PURE__ */ p(n, { scope: f, itemMap: g, collectionRef: b, listeners: d, children: m });
  };
  c.displayName = i;
  const l = `${o}CollectionSlot`, a = s.forwardRef((u, f) => {
    const { scope: m, children: b } = u, g = r(l, m), d = A(f, g.collectionRef);
    return /* @__PURE__ */ p(Ee, { ref: d, children: b });
  });
  a.displayName = l;
  const h = `${o}CollectionItemSlot`, C = "data-radix-collection-item", v = s.forwardRef((u, f) => {
    const { scope: m, children: b, ...g } = u, d = s.useRef(null), y = A(f, d), V = r(h, m);
    return s.useEffect(() => {
      const O = Array.from(V.itemMap.values());
      return V.itemMap.set(d, { ref: d, ...g }), V.listeners.forEach((F) => F(Array.from(V.itemMap.values()), O)), () => {
        const F = Array.from(V.itemMap.values());
        V.itemMap.delete(d), V.listeners.forEach((_) => _(Array.from(V.itemMap.values()), F));
      };
    }), /* @__PURE__ */ p(Ee, { [C]: "", ref: y, children: b });
  });
  v.displayName = h;
  function x(u) {
    const f = r(`${o}CollectionConsumer`, u), m = s.useCallback(() => {
      const g = f.collectionRef.current;
      if (!g) return [];
      const d = Array.from(g.querySelectorAll(`[${C}]`));
      return Array.from(f.itemMap.values()).sort(
        (O, F) => d.indexOf(O.ref.current) - d.indexOf(F.ref.current)
      );
    }, [f.collectionRef, f.itemMap]), b = s.useCallback(
      (g) => (f.listeners.add(g), () => f.listeners.delete(g)),
      [f.listeners]
    );
    return { getItems: m, subscribe: b };
  }
  return [
    { Provider: c, Slot: a, ItemSlot: v },
    x,
    t
  ];
}
const Pe = /* @__PURE__ */ new Map();
function Qt(o, i) {
  const e = o + (i ? Object.entries(i).sort((n, r) => n[0] < r[0] ? -1 : 1).join() : "");
  if (Pe.has(e))
    return Pe.get(e);
  const t = new Intl.Collator(o, i);
  return Pe.set(e, t), t;
}
function De(o, i) {
  const e = Qt(o, {
    usage: "search",
    ...i
  });
  return {
    startsWith(t, n) {
      return n.length === 0 ? !0 : (t = t.normalize("NFC"), n = n.normalize("NFC"), e.compare(t.slice(0, n.length), n) === 0);
    },
    endsWith(t, n) {
      return n.length === 0 ? !0 : (t = t.normalize("NFC"), n = n.normalize("NFC"), e.compare(t.slice(-n.length), n) === 0);
    },
    contains(t, n) {
      if (n.length === 0)
        return !0;
      t = t.normalize("NFC"), n = n.normalize("NFC");
      let r = 0;
      const c = n.length;
      for (; r + c <= t.length; r++) {
        const l = t.slice(r, r + c);
        if (e.compare(n, l) === 0)
          return !0;
      }
      return !1;
    }
  };
}
const eo = (o) => {
  const i = s.useRef();
  return s.useEffect(() => {
    i.current = o;
  }), i.current;
}, ht = s.forwardRef(
  ({ children: o, estimatedItemSize: i = 40, overscan: e = 5, getItemCount: t, onViewportChange: n, ...r }, c) => {
    const l = s.useRef(null), a = A(c, l, n), h = s.useMemo(() => s.Children.toArray(o), [o]), C = jt({
      count: t(),
      getScrollElement: () => l.current,
      estimateSize: () => i,
      overscan: e
    }), v = C.getVirtualItems();
    return /* @__PURE__ */ ye(Se, { children: [
      /* @__PURE__ */ p(
        "style",
        {
          dangerouslySetInnerHTML: {
            __html: "[data-radix-combobox-viewport]{scrollbar-width:none;-ms-overflow-style:none;-webkit-overflow-scrolling:touch;}[data-radix-combobox-viewport]::-webkit-scrollbar{display:none}"
          }
        }
      ),
      /* @__PURE__ */ p(
        N.div,
        {
          "data-radix-combobox-viewport": "",
          role: "presentation",
          ...r,
          ref: a,
          style: {
            position: "relative",
            flex: 1,
            overflow: "auto",
            ...r.style
          },
          children: /* @__PURE__ */ p(
            "div",
            {
              style: {
                height: `${C.getTotalSize()}px`,
                width: "100%",
                position: "relative"
              },
              children: v.map((x) => {
                const u = h[x.index];
                return /* @__PURE__ */ p(
                  "div",
                  {
                    "data-index": x.index,
                    ref: C.measureElement,
                    style: {
                      position: "absolute",
                      top: 0,
                      left: 0,
                      width: "100%",
                      transform: `translateY(${x.start}px)`
                    },
                    children: u
                  },
                  x.key
                );
              })
            }
          )
        }
      )
    ] });
  }
);
ht.displayName = "VirtualizedViewport";
const to = [" ", "Enter", "ArrowUp", "ArrowDown"], oo = ["Enter"], no = (o) => !!(o.length === 1 && o.match(/\S| /)), gt = "Combobox", [re, xe] = Jt(gt), [ro, Y] = it(gt), lo = ({ children: o }) => /* @__PURE__ */ p(ie.Root, { children: /* @__PURE__ */ p(re.Provider, { scope: void 0, children: o }) }), so = (o) => typeof o == "string" ? o === "none" ? {
  type: o,
  filter: void 0
} : {
  type: o,
  filter: "startsWith"
} : o, io = (o) => {
  const {
    allowCustomValue: i = !1,
    autocomplete: e = "none",
    children: t,
    open: n,
    defaultOpen: r,
    onOpenChange: c,
    value: l,
    defaultValue: a,
    onValueChange: h,
    disabled: C,
    required: v = !1,
    locale: x = "en-EN",
    onTextValueChange: u,
    textValue: f,
    defaultTextValue: m,
    filterValue: b,
    defaultFilterValue: g,
    onFilterValueChange: d,
    isPrintableCharacter: y = no,
    visible: V = !1,
    virtualized: O = "auto",
    estimatedItemSize: F = 40,
    overscan: _ = 5
  } = o, [k, Z] = s.useState(null), [U, W] = s.useState(null), [R, H] = s.useState(null), [L, z] = s.useState(null), [J = !1, Q] = de({
    prop: n,
    defaultProp: r,
    onChange: c
  }), [K, G] = de({
    prop: l,
    defaultProp: a,
    onChange: h
  }), [ce, ee] = de({
    prop: f,
    defaultProp: i && !m ? l : m,
    onChange: u
  }), [fe, me] = de({
    prop: b,
    defaultProp: g,
    onChange: d
  }), te = se(), ae = s.useCallback(
    (S, I) => {
      var j;
      const M = I.map((D) => D.ref.current), [P, ...T] = M, [w] = T.slice(-1), B = L ?? ((j = I.find((D) => D.value === K)) == null ? void 0 : j.ref.current);
      for (const D of S) {
        if (D === B) return;
        if (D == null || D.scrollIntoView({ block: "nearest" }), D === P && U && (U.scrollTop = 0), D === w && U && (U.scrollTop = U.scrollHeight), z(D), e === "both") {
          const ue = I.find((he) => he.ref.current === D);
          ue && ee(ue.textValue);
        }
        if (D !== B) return;
      }
    },
    [e, ee, U, L, K]
  ), ne = so(e);
  return s.useEffect(() => {
    e !== "both" && z(null);
  }, [ce, e]), s.useEffect(() => {
    if (R && k) return ft([R, k]);
  }, [R, k]), /* @__PURE__ */ p(lo, { children: /* @__PURE__ */ p(
    ro,
    {
      allowCustomValue: i,
      autocomplete: ne,
      required: v,
      trigger: k,
      onTriggerChange: Z,
      contentId: te,
      value: K,
      onValueChange: G,
      open: J,
      onOpenChange: Q,
      disabled: C,
      locale: x,
      focusFirst: ae,
      textValue: ce,
      onTextValueChange: ee,
      onViewportChange: W,
      onContentChange: H,
      visuallyFocussedItem: L,
      filterValue: fe,
      onFilterValueChange: me,
      onVisuallyFocussedItemChange: z,
      isPrintableCharacter: y,
      visible: V,
      virtualized: O,
      estimatedItemSize: F,
      overscan: _,
      children: t
    }
  ) });
}, xt = "ComboboxTrigger", Ct = s.forwardRef((o, i) => {
  const { ...e } = o, t = Y(xt), n = () => {
    t.disabled || t.onOpenChange(!0);
  };
  return /* @__PURE__ */ p(ie.Anchor, { asChild: !0, children: /* @__PURE__ */ p(
    ut,
    {
      asChild: !0,
      trapped: t.open,
      onMountAutoFocus: (r) => {
        r.preventDefault();
      },
      onUnmountAutoFocus: (r) => {
        var c, l;
        (c = t.trigger) == null || c.focus({ preventScroll: !0 }), (l = document.getSelection()) == null || l.empty(), r.preventDefault();
      },
      children: /* @__PURE__ */ p(
        "div",
        {
          ref: i,
          "data-disabled": t.disabled ? "" : void 0,
          ...e,
          onClick: E(e.onClick, (r) => {
            var c;
            if (t.disabled) {
              r.preventDefault();
              return;
            }
            (c = t.trigger) == null || c.focus();
          }),
          onPointerDown: E(e.onPointerDown, (r) => {
            var a;
            if (t.disabled) {
              r.preventDefault();
              return;
            }
            const c = r.target;
            c.hasPointerCapture(r.pointerId) && c.releasePointerCapture(r.pointerId), (c.closest("button") ?? c.closest("div")) === r.currentTarget && r.button === 0 && r.ctrlKey === !1 && (n(), (a = t.trigger) == null || a.focus());
          })
        }
      )
    }
  ) });
});
Ct.displayName = xt;
const vt = "ComboboxInput", bt = s.forwardRef((o, i) => {
  var C;
  const e = Y(vt), t = s.useRef(null), { getItems: n } = xe(void 0), { startsWith: r } = De(e.locale, { sensitivity: "base" }), c = e.disabled, l = A(t, i, e.onTriggerChange), a = () => {
    c || e.onOpenChange(!0);
  }, h = eo(e.filterValue);
  return $(() => {
    const v = setTimeout(() => {
      var f;
      if (e.textValue === "" || e.textValue === void 0 || e.filterValue === "" || e.filterValue === void 0)
        return;
      const x = n().find(
        (m) => m.type === "option" && r(m.textValue, e.textValue)
      ), u = wo(h ?? "", e.filterValue);
      x && !e.visuallyFocussedItem && u === e.filterValue.length && ((f = t.current) == null || f.setSelectionRange(e.filterValue.length, e.textValue.length));
    });
    return () => clearTimeout(v);
  }, [e.textValue, e.filterValue, r, e.visuallyFocussedItem, n, h]), /* @__PURE__ */ p(
    "input",
    {
      type: "text",
      role: "combobox",
      "aria-controls": e.contentId,
      "aria-expanded": e.open,
      "aria-required": e.required,
      "aria-autocomplete": e.autocomplete.type,
      "data-state": e.open ? "open" : "closed",
      "aria-disabled": c,
      "aria-activedescendant": (C = e.visuallyFocussedItem) == null ? void 0 : C.id,
      disabled: c,
      "data-disabled": c ? "" : void 0,
      "data-placeholder": e.textValue === void 0 ? "" : void 0,
      value: e.textValue ?? "",
      ...o,
      ref: l,
      onKeyDown: E(o.onKeyDown, (v) => {
        var x, u;
        if (["ArrowUp", "ArrowDown", "Home", "End"].includes(v.key))
          e.open || a(), setTimeout(() => {
            var b;
            let m = n().filter((g) => !g.disabled && g.isVisible).map((g) => g.ref.current);
            if (["ArrowUp", "End"].includes(v.key) && (m = m.slice().reverse()), ["ArrowUp", "ArrowDown"].includes(v.key)) {
              const g = e.visuallyFocussedItem ?? ((b = n().find((d) => d.value === e.value)) == null ? void 0 : b.ref.current);
              if (g) {
                let d = m.indexOf(g);
                d === m.length - 1 && (d = -1), m = m.slice(d + 1);
              }
            }
            if (["ArrowDown"].includes(v.key) && e.autocomplete.type === "both" && m.length > 1) {
              const [g, ...d] = m, y = n().find((V) => V.ref.current === g).textValue;
              e.textValue === y && (m = d);
            }
            e.focusFirst(m, n());
          }), v.preventDefault();
        else if (["Tab"].includes(v.key) && e.open)
          v.preventDefault();
        else if (["Escape"].includes(v.key))
          e.open ? e.onOpenChange(!1) : (e.onValueChange(void 0), e.onTextValueChange("")), v.preventDefault();
        else if (oo.includes(v.key)) {
          if (e.visuallyFocussedItem) {
            const f = n().find((m) => m.ref.current === e.visuallyFocussedItem);
            f && (e.onValueChange(f.value), e.onTextValueChange(f.textValue), e.autocomplete.type === "both" && e.onFilterValueChange(f.textValue), (x = f.ref.current) == null || x.click());
          } else {
            const f = n().find(
              (m) => m.type === "option" && !m.disabled && m.textValue === e.textValue
            );
            f && (e.onValueChange(f.value), e.onTextValueChange(f.textValue), e.autocomplete.type === "both" && e.onFilterValueChange(f.textValue), (u = f.ref.current) == null || u.click());
          }
          e.onOpenChange(!1), v.preventDefault();
        } else
          e.onVisuallyFocussedItemChange(null);
      }),
      onChange: E(o.onChange, (v) => {
        e.onTextValueChange(v.currentTarget.value), e.autocomplete.type === "both" && e.onFilterValueChange(v.currentTarget.value);
      }),
      onKeyUp: E(o.onKeyUp, (v) => {
        var x;
        if (!e.open && (e.isPrintableCharacter(v.key) || ["Backspace"].includes(v.key)) && a(), setTimeout(() => {
          if (e.autocomplete.type === "both" && e.isPrintableCharacter(v.key) && e.filterValue !== void 0) {
            const u = e.filterValue, f = n().find((m) => r(m.textValue, u));
            f && e.onTextValueChange(f.textValue);
          }
        }), e.autocomplete.type === "none" && e.isPrintableCharacter(v.key)) {
          const u = e.textValue ?? "", f = n().find((m) => r(m.textValue, u));
          f && (e.onVisuallyFocussedItemChange(f.ref.current), (x = f.ref.current) == null || x.scrollIntoView());
        }
      }),
      onBlur: E(o.onBlur, () => {
        if (e.open)
          return;
        e.onVisuallyFocussedItemChange(null);
        const [v] = n().filter(
          (u) => u.textValue === e.textValue && u.type === "option"
        );
        if (v) {
          e.onValueChange(v.value), e.autocomplete.type === "both" && e.onFilterValueChange(v.textValue);
          return;
        }
        if (e.allowCustomValue) {
          e.onValueChange(e.textValue), e.autocomplete.type === "both" && e.onFilterValueChange(e.textValue);
          return;
        }
        const [x] = n().filter((u) => u.value === e.value && u.type === "option");
        x && e.textValue !== "" ? (e.onTextValueChange(x.textValue), e.autocomplete.type === "both" && e.onFilterValueChange(x.textValue)) : (e.onValueChange(void 0), e.onTextValueChange(""));
      })
    }
  );
});
bt.displayName = "ComboboxTextInput";
const yt = s.forwardRef((o, i) => {
  const { children: e, ...t } = o, n = Y(vt), r = n.disabled, c = () => {
    var l;
    r || (n.onOpenChange(!0), (l = n.trigger) == null || l.focus());
  };
  return /* @__PURE__ */ p(
    N.button,
    {
      "aria-hidden": !0,
      type: "button",
      "aria-disabled": r,
      "aria-controls": n.contentId,
      "aria-expanded": n.open,
      disabled: r,
      "data-disabled": r ? "" : void 0,
      ...t,
      tabIndex: -1,
      ref: i,
      onClick: E(t.onClick, () => {
        var l;
        (l = n.trigger) == null || l.focus();
      }),
      onPointerDown: E(t.onPointerDown, (l) => {
        l.button === 0 && l.ctrlKey === !1 && (c(), l.preventDefault());
      }),
      onKeyDown: E(t.onKeyDown, (l) => {
        to.includes(l.key) && (c(), l.preventDefault());
      }),
      children: e || "▼"
    }
  );
});
yt.displayName = "ComboboxIcon";
const co = "ComboboxPortal", St = (o) => /* @__PURE__ */ p(pt, { asChild: !0, ...o });
St.displayName = co;
const ke = "ComboboxContent", wt = s.forwardRef((o, i) => {
  const e = Y(ke), { getItems: t } = xe(void 0), [n, r] = s.useState();
  if ($(() => {
    r(new DocumentFragment());
  }, []), $(() => {
    e.open && e.autocomplete.type === "none" && setTimeout(() => {
      var l;
      const c = t().find((a) => a.value === e.value);
      (l = c == null ? void 0 : c.ref.current) == null || l.scrollIntoView({ block: "nearest" });
    });
  }, [t, e.autocomplete, e.value, e.open]), !e.open) {
    const c = n;
    return c ? we.createPortal(
      /* @__PURE__ */ p(re.Slot, { scope: void 0, children: /* @__PURE__ */ p("div", { children: o.children }) }),
      c
    ) : null;
  }
  return /* @__PURE__ */ p(It, { ...o, ref: i });
});
wt.displayName = ke;
const ao = 10, It = s.forwardRef(
  (o, i) => {
    const { onEscapeKeyDown: e, onPointerDownOutside: t, ...n } = o, r = Y(ke), c = A(i, (a) => r.onContentChange(a)), { onOpenChange: l } = r;
    return at(), s.useEffect(() => {
      const a = () => {
        l(!1);
      };
      return window.addEventListener("blur", a), window.addEventListener("resize", a), () => {
        window.removeEventListener("blur", a), window.removeEventListener("resize", a);
      };
    }, [l]), /* @__PURE__ */ p(mt, { allowPinchZoom: !0, children: /* @__PURE__ */ p(
      ct,
      {
        asChild: !0,
        onEscapeKeyDown: e,
        onPointerDownOutside: t,
        onFocusOutside: (a) => {
          a.preventDefault();
        },
        onDismiss: () => {
          var a;
          r.onOpenChange(!1), (a = r.trigger) == null || a.focus({ preventScroll: !0 });
        },
        children: /* @__PURE__ */ p(
          Tt,
          {
            role: "listbox",
            id: r.contentId,
            "data-state": r.open ? "open" : "closed",
            onContextMenu: (a) => a.preventDefault(),
            ...n,
            ref: c,
            style: {
              // flex layout so we can place the scroll buttons properly
              display: "flex",
              flexDirection: "column",
              // reset the outline by default as the content MAY get focused
              outline: "none",
              ...n.style
            }
          }
        )
      }
    ) });
  }
);
It.displayName = "ComboboxContentImpl";
const Tt = s.forwardRef(
  (o, i) => {
    const { align: e = "start", collisionPadding: t = ao, ...n } = o;
    return /* @__PURE__ */ p(
      ie.Content,
      {
        ...n,
        ref: i,
        align: e,
        collisionPadding: t,
        style: {
          // Ensure border-box for floating-ui calculations
          boxSizing: "border-box",
          ...n.style,
          "--radix-combobox-content-transform-origin": "var(--radix-popper-transform-origin)",
          "--radix-combobox-content-available-width": "var(--radix-popper-available-width)",
          "--radix-combobox-content-available-height": "var(--radix-popper-available-height)",
          "--radix-combobox-trigger-width": "var(--radix-popper-anchor-width)",
          "--radix-combobox-trigger-height": "var(--radix-popper-anchor-height)"
        }
      }
    );
  }
);
Tt.displayName = "ComboboxPopperPosition";
const Vt = "ComboboxViewport", Pt = s.forwardRef((o, i) => {
  const e = Y(Vt), t = A(i, e.onViewportChange), r = s.useMemo(() => s.Children.toArray(o.children), [o.children]).length;
  return e.virtualized === !0 || e.virtualized === "auto" && r > 100 ? /* @__PURE__ */ p(re.Slot, { scope: void 0, children: /* @__PURE__ */ p(
    ht,
    {
      ...o,
      ref: t,
      getItemCount: () => r,
      estimatedItemSize: e.estimatedItemSize,
      overscan: e.overscan,
      onViewportChange: e.onViewportChange
    }
  ) }) : /* @__PURE__ */ ye(Se, { children: [
    /* @__PURE__ */ p(
      "style",
      {
        dangerouslySetInnerHTML: {
          __html: "[data-radix-combobox-viewport]{scrollbar-width:none;-ms-overflow-style:none;-webkit-overflow-scrolling:touch;}[data-radix-combobox-viewport]::-webkit-scrollbar{display:none}"
        }
      }
    ),
    /* @__PURE__ */ p(re.Slot, { scope: void 0, children: /* @__PURE__ */ p(
      N.div,
      {
        "data-radix-combobox-viewport": "",
        role: "presentation",
        ...o,
        ref: t,
        style: {
          // we use position: 'relative' here on the `viewport` so that when we call
          // `selectedItem.offsetTop` in calculations, the offset is relative to the viewport
          // (independent of the scrollUpButton).
          position: "relative",
          flex: 1,
          overflow: "auto",
          ...o.style
        }
      }
    ) })
  ] });
});
Pt.displayName = Vt;
const Ie = "ComboboxItem", [lt, Fe] = it(Ie), Le = s.forwardRef((o, i) => {
  const { value: e, disabled: t = !1, textValue: n, ...r } = o, [c, l] = s.useState();
  $(() => {
    l(new DocumentFragment());
  }, []);
  const { onTextValueChange: a, textValue: h, ...C } = Y(Ie), v = se(), [x, u] = s.useState(n ?? ""), f = C.value === e, { startsWith: m, contains: b } = De(C.locale, { sensitivity: "base" }), g = s.useCallback((d) => {
    u((y) => y || ((d == null ? void 0 : d.textContent) ?? "").trim());
  }, []);
  return s.useEffect(() => {
    f && h === void 0 && x !== "" && a(x);
  }, [x, f, h, a]), C.autocomplete.type === "both" && x && C.filterValue && !m(x, C.filterValue) || C.autocomplete.type === "list" && C.autocomplete.filter === "startsWith" && x && h && !m(x, h) || C.autocomplete.type === "list" && C.autocomplete.filter === "contains" && x && h && !b(x, h) ? c ? we.createPortal(
    /* @__PURE__ */ p(
      lt,
      {
        textId: v,
        onTextValueChange: g,
        isSelected: f,
        textValue: x,
        children: /* @__PURE__ */ p(
          re.ItemSlot,
          {
            scope: void 0,
            value: e,
            textValue: x,
            disabled: t,
            type: "option",
            isVisible: !1,
            children: /* @__PURE__ */ p(Ne, { ref: i, value: e, disabled: t, ...r })
          }
        )
      }
    ),
    c
  ) : null : /* @__PURE__ */ p(
    lt,
    {
      textId: v,
      onTextValueChange: g,
      isSelected: f,
      textValue: x,
      children: /* @__PURE__ */ p(
        re.ItemSlot,
        {
          scope: void 0,
          value: e,
          textValue: x,
          disabled: t,
          type: "option",
          isVisible: !0,
          children: /* @__PURE__ */ p(Ne, { ref: i, value: e, disabled: t, ...r })
        }
      )
    }
  );
});
Le.displayName = Ie;
const Et = "ComboboxItemImpl", Ne = s.forwardRef((o, i) => {
  const { value: e, disabled: t = !1, ...n } = o, r = s.useRef(null), c = A(i, r), { getItems: l } = xe(void 0), { onTextValueChange: a, visuallyFocussedItem: h, ...C } = Y(Ie), { isSelected: v, textValue: x, textId: u } = Fe(Et), f = () => {
    var g;
    t || (C.onValueChange(e), a(x), C.onOpenChange(!1), C.autocomplete.type === "both" && C.onFilterValueChange(x), (g = C.trigger) == null || g.focus({ preventScroll: !0 }));
  }, m = s.useMemo(() => {
    var g;
    return h === ((g = l().find((d) => d.ref.current === r.current)) == null ? void 0 : g.ref.current);
  }, [l, h]), b = se();
  return /* @__PURE__ */ p(
    N.div,
    {
      role: "option",
      "aria-labelledby": u,
      "data-highlighted": m ? "" : void 0,
      "aria-selected": v && m,
      "data-state": v ? "checked" : "unchecked",
      "aria-disabled": t || void 0,
      "data-disabled": t ? "" : void 0,
      tabIndex: t ? void 0 : -1,
      ...n,
      id: b,
      ref: c,
      onPointerUp: E(n.onPointerUp, f)
    }
  );
});
Ne.displayName = Et;
const Nt = "ComboboxItemText", Rt = s.forwardRef((o, i) => {
  const { className: e, style: t, ...n } = o, r = Fe(Nt), c = A(i, r.onTextValueChange);
  return /* @__PURE__ */ p(N.span, { id: r.textId, ...n, ref: c });
});
Rt.displayName = Nt;
const At = "ComboboxItemIndicator", _t = s.forwardRef((o, i) => {
  const { isSelected: e } = Fe(At);
  return e ? /* @__PURE__ */ p(N.span, { "aria-hidden": !0, ...o, ref: i }) : null;
});
_t.displayName = At;
const Be = "ComboboxNoValueFound", Mt = s.forwardRef((o, i) => {
  const {
    textValue: e = "",
    filterValue: t = "",
    visible: n = !1,
    locale: r,
    autocomplete: c
  } = Y(Be), [l, a] = s.useState([]), { subscribe: h } = xe(void 0), { startsWith: C, contains: v } = De(r, { sensitivity: "base" });
  return s.useEffect(() => {
    const x = h((u) => {
      if (n) {
        const f = u.filter((m) => m.type !== "create");
        a(f);
      } else
        a(u);
    });
    return () => {
      x();
    };
  }, [n, h]), c.type === "none" && l.length > 0 || c.type === "list" && c.filter === "startsWith" && l.some((x) => C(x.textValue, e)) || c.type === "both" && l.some((x) => C(x.textValue, t)) || c.type === "list" && c.filter === "contains" && l.some((x) => v(x.textValue, e)) ? null : /* @__PURE__ */ p(N.div, { ...o, ref: i });
});
Mt.displayName = Be;
const Ot = s.forwardRef((o, i) => {
  const { disabled: e = !1, ...t } = o, n = Y(Be), { textValue: r, visuallyFocussedItem: c } = n, { getItems: l, subscribe: a } = xe(void 0), h = s.useRef(null), [C, v] = s.useState(!1), x = A(i, h), u = s.useMemo(() => {
    var b;
    return c === ((b = l().find((g) => g.ref.current === h.current)) == null ? void 0 : b.ref.current);
  }, [l, c]), f = se(), m = () => {
    var b;
    !e && r && (n.onValueChange(r), n.onTextValueChange(r), n.onOpenChange(!1), n.autocomplete.type === "both" && n.onFilterValueChange(r), (b = n.trigger) == null || b.focus({ preventScroll: !0 }));
  };
  return $(() => {
    const b = a((g) => {
      v(!g.some((d) => d.textValue === r && d.type !== "create"));
    });
    return l().length === 0 && v(!0), () => {
      b();
    };
  }, [r, a, l]), (!r || !C) && !n.visible ? null : /* @__PURE__ */ p(
    re.ItemSlot,
    {
      scope: void 0,
      value: r ?? "",
      textValue: r ?? "",
      disabled: e,
      isVisible: !0,
      type: "create",
      children: /* @__PURE__ */ p(
        N.div,
        {
          role: "option",
          tabIndex: e ? void 0 : -1,
          "aria-disabled": e || void 0,
          "data-disabled": e ? "" : void 0,
          "data-highlighted": u ? "" : void 0,
          ...t,
          id: f,
          ref: x,
          onPointerUp: E(t.onPointerUp, m)
        }
      )
    }
  );
});
Ot.displayName = "ComboboxCreateItem";
const uo = io, po = Ct, fo = bt, mo = yt, ho = St, go = wt, xo = Pt, Co = Le, vo = Rt, bo = _t, yo = Mt, So = Ot;
function wo(o, i) {
  const e = Math.min(o.length, i.length);
  for (let t = 0; t < e; t++)
    if (o[t] !== i[t])
      return t;
  return e;
}
const Rn = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  ComboboxItem: Le,
  Content: go,
  CreateItem: So,
  Icon: mo,
  Item: Co,
  ItemIndicator: bo,
  ItemText: vo,
  NoValueFound: yo,
  Portal: ho,
  Root: uo,
  TextInput: fo,
  Trigger: po,
  Viewport: xo
}, Symbol.toStringTag, { value: "Module" }));
function Io(o) {
  const i = s.useRef(o);
  return s.useEffect(() => {
    i.current = o;
  }), s.useMemo(() => (...e) => {
    var t;
    return (t = i.current) == null ? void 0 : t.call(i, ...e);
  }, []);
}
const To = [" ", "Enter", "ArrowUp", "ArrowDown"], Vo = [" ", "Enter"], Ce = "Select", [Te, ve, Po] = Yt(Ce), [pe, Eo] = st(Ce, [
  Po,
  dt
]), Ve = dt(), [No, X] = pe(Ce), [Ro, Ao] = pe(Ce), $e = (o) => {
  const {
    __scopeSelect: i,
    children: e,
    open: t,
    defaultOpen: n,
    onOpenChange: r,
    value: c,
    defaultValue: l,
    onValueChange: a,
    dir: h,
    // name,
    // autoComplete,
    disabled: C,
    required: v,
    multi: x = !1
  } = o, u = Ve(i), [f, m] = s.useState(null), [b, g] = s.useState(null), [d, y] = s.useState(!1), V = qt(h), [O = !1, F] = de({
    prop: t,
    defaultProp: n,
    onChange: r
  }), [_, k] = de({
    prop: c,
    defaultProp: l,
    onChange(R) {
      a && (Array.isArray(R), a(R));
    }
  }), Z = s.useRef(null), [U, W] = s.useState(/* @__PURE__ */ new Set());
  return /* @__PURE__ */ p(ie.Root, { ...u, children: /* @__PURE__ */ p(
    No,
    {
      required: v,
      scope: i,
      trigger: f,
      onTriggerChange: m,
      valueNode: b,
      onValueNodeChange: g,
      valueNodeHasChildren: d,
      onValueNodeHasChildrenChange: y,
      contentId: se(),
      value: _,
      onValueChange: k,
      open: O,
      onOpenChange: F,
      dir: V,
      triggerPointerDownPosRef: Z,
      disabled: C,
      multi: x,
      children: /* @__PURE__ */ p(Te.Provider, { scope: i, children: /* @__PURE__ */ p(
        Ro,
        {
          scope: o.__scopeSelect,
          onNativeOptionAdd: s.useCallback((R) => {
            W((H) => new Set(H).add(R));
          }, []),
          onNativeOptionRemove: s.useCallback((R) => {
            W((H) => {
              const L = new Set(H);
              return L.delete(R), L;
            });
          }, []),
          children: e
        }
      ) })
    }
  ) });
};
$e.displayName = Ce;
const Dt = "SelectTrigger", Ue = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, ...t } = o, n = Ve(e), r = X(Dt, e), c = r.disabled, l = A(i, r.onTriggerChange), a = ve(e), [h, C, v] = Wt((u) => {
      const f = a().filter((g) => !g.disabled), m = f.find((g) => g.value === r.value), b = Kt(f, u, m);
      if (b !== void 0 && !Array.isArray(b.value)) {
        const g = r.multi ? [b.value] : b.value;
        r.onValueChange(g);
      }
    }), x = () => {
      c || (r.onOpenChange(!0), v());
    };
    return /* @__PURE__ */ p(ie.Anchor, { asChild: !0, ...n, children: /* @__PURE__ */ p(
      N.div,
      {
        role: "combobox",
        "aria-controls": r.contentId,
        "aria-expanded": r.open,
        "aria-required": r.required,
        "aria-autocomplete": "none",
        dir: r.dir,
        "data-state": r.open ? "open" : "closed",
        "data-disabled": c ? "" : void 0,
        "data-placeholder": r.value === void 0 ? "" : void 0,
        tabIndex: c ? void 0 : 0,
        ...t,
        ref: l,
        onClick: E(t.onClick, (u) => {
          u.currentTarget.focus();
        }),
        onPointerDown: E(t.onPointerDown, (u) => {
          const f = u.target;
          f.hasPointerCapture(u.pointerId) && f.releasePointerCapture(u.pointerId), (f.closest("button") ?? f.closest("div")) === u.currentTarget && u.button === 0 && u.ctrlKey === !1 && (x(), r.triggerPointerDownPosRef.current = {
            x: Math.round(u.pageX),
            y: Math.round(u.pageY)
          }, u.preventDefault());
        }),
        onKeyDown: E(t.onKeyDown, (u) => {
          const f = h.current !== "", m = u.ctrlKey || u.altKey || u.metaKey, b = u.target;
          (b.closest("button") ?? b.closest("div")) === u.currentTarget && (!m && u.key.length === 1 && C(u.key), !(f && u.key === " ") && To.includes(u.key) && (x(), u.preventDefault()));
        })
      }
    ) });
  }
);
Ue.displayName = Dt;
const kt = "SelectValue", He = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, children: t, placeholder: n, ...r } = o, c = X(kt, e), { onValueNodeHasChildrenChange: l } = c, a = t !== void 0, h = A(i, c.onValueNodeChange), [C, v] = s.useState([]), x = ve(e);
    $(() => {
      l(a);
    }, [l, a]), s.useLayoutEffect(() => {
      if (Array.isArray(c.value)) {
        const f = new Set(C.map((g) => g.value)), m = new Set(c.value);
        if (!(f.size === m.size && Array.from(m).every((g) => f.has(g)))) {
          const g = setTimeout(() => {
            const d = x().filter(
              (y) => {
                var V;
                return Array.isArray(y.value) ? !1 : (V = c.value) == null ? void 0 : V.includes(y.value);
              }
            );
            v(d);
          });
          return () => {
            clearTimeout(g);
          };
        }
      }
    }, [c.value, x, C]);
    let u;
    if ((c.value === void 0 || c.value.length === 0) && n !== void 0)
      u = /* @__PURE__ */ p("span", { children: n });
    else if (typeof t == "function")
      if (Array.isArray(c.value)) {
        const f = c.value.map((m) => {
          const b = C.find((g) => g.value === m);
          return b ? t({ value: m, textValue: b == null ? void 0 : b.textValue }) : null;
        });
        u = f.every((m) => m === null) ? n : f;
      } else
        u = t(c.value);
    else
      u = t;
    return /* @__PURE__ */ p(N.span, { ...r, ref: h, children: u || null });
  }
);
He.displayName = kt;
const _o = "SelectIcon", ze = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, children: t, ...n } = o;
    return /* @__PURE__ */ p(N.span, { "aria-hidden": !0, ...n, ref: i, children: t || "▼" });
  }
);
ze.displayName = _o;
const Mo = "SelectPortal", We = (o) => /* @__PURE__ */ p(pt, { asChild: !0, ...o });
We.displayName = Mo;
const le = "SelectContent", Ke = s.forwardRef(
  (o, i) => {
    const e = X(le, o.__scopeSelect), [t, n] = s.useState();
    if ($(() => {
      n(new DocumentFragment());
    }, []), !e.open) {
      const r = t;
      return r ? we.createPortal(
        /* @__PURE__ */ p(Ft, { scope: o.__scopeSelect, children: /* @__PURE__ */ p(Te.Slot, { scope: o.__scopeSelect, children: /* @__PURE__ */ p("div", { children: o.children }) }) }),
        r
      ) : null;
    }
    return /* @__PURE__ */ p(Lt, { ...o, ref: i });
  }
);
Ke.displayName = le;
const q = 10, [Ft, oe] = pe(le), Oo = "SelectContentImpl", Lt = s.forwardRef(
  (o, i) => {
    const {
      __scopeSelect: e,
      position: t = "item-aligned",
      onCloseAutoFocus: n,
      onEscapeKeyDown: r,
      onPointerDownOutside: c,
      //
      // PopperContent props
      side: l,
      sideOffset: a,
      align: h,
      alignOffset: C,
      arrowPadding: v,
      collisionBoundary: x,
      collisionPadding: u,
      sticky: f,
      hideWhenDetached: m,
      avoidCollisions: b,
      //
      ...g
    } = o, d = X(le, e), [y, V] = s.useState(null), [O, F] = s.useState(null), _ = A(i, (S) => V(S)), [k, Z] = s.useState(null), [U, W] = s.useState(null), R = ve(e), [H, L] = s.useState(!1), z = s.useRef(!1);
    s.useEffect(() => {
      if (y) return ft(y);
    }, [y]), at();
    const J = s.useCallback(
      (S) => {
        const [I, ...M] = R().map((w) => w.ref.current), [P] = M.slice(-1), T = document.activeElement;
        for (const w of S)
          if (w === T || (w == null || w.scrollIntoView({ block: "nearest" }), w === I && O && (O.scrollTop = 0), w === P && O && (O.scrollTop = O.scrollHeight), w == null || w.focus(), document.activeElement !== T)) return;
      },
      [R, O]
    ), Q = s.useCallback(
      () => J([k, y]),
      [J, k, y]
    );
    s.useEffect(() => {
      H && Q();
    }, [H, Q]);
    const { onOpenChange: K, triggerPointerDownPosRef: G } = d;
    s.useEffect(() => {
      if (y) {
        let S = { x: 0, y: 0 };
        const I = (P) => {
          var T, w;
          S = {
            x: Math.abs(Math.round(P.pageX) - (((T = G.current) == null ? void 0 : T.x) ?? 0)),
            y: Math.abs(Math.round(P.pageY) - (((w = G.current) == null ? void 0 : w.y) ?? 0))
          };
        }, M = (P) => {
          S.x <= 10 && S.y <= 10 ? P.preventDefault() : y.contains(P.target) || K(!1), document.removeEventListener("pointermove", I), G.current = null;
        };
        return G.current !== null && (document.addEventListener("pointermove", I), document.addEventListener("pointerup", M, { capture: !0, once: !0 })), () => {
          document.removeEventListener("pointermove", I), document.removeEventListener("pointerup", M, { capture: !0 });
        };
      }
    }, [y, K, G]), s.useEffect(() => {
      const S = () => K(!1);
      return window.addEventListener("blur", S), window.addEventListener("resize", S), () => {
        window.removeEventListener("blur", S), window.removeEventListener("resize", S);
      };
    }, [K]);
    const [ce, ee] = Wt((S) => {
      const I = R().filter((T) => !T.disabled), M = I.find((T) => T.ref.current === document.activeElement), P = Kt(I, S, M);
      P && setTimeout(() => P.ref.current.focus());
    }), fe = s.useCallback(
      (S, I, M) => {
        const P = !z.current && !M;
        (d.value !== void 0 && d.value === I || P) && (Z(S), P && (z.current = !0));
      },
      [d.value]
    ), me = s.useCallback(() => y == null ? void 0 : y.focus(), [y]), te = s.useCallback(
      (S, I, M) => {
        const P = !z.current && !M;
        (d.value !== void 0 && (Array.isArray(I) ? I.every((w) => {
          var B;
          return (B = d.value) == null ? void 0 : B.includes(w);
        }) : d.value === I) || P) && W(S);
      },
      [d.value]
    ), ae = t === "popper" ? Re : Bt, ne = ae === Re ? {
      side: l,
      sideOffset: a,
      align: h,
      alignOffset: C,
      arrowPadding: v,
      collisionBoundary: x,
      collisionPadding: u,
      sticky: f,
      hideWhenDetached: m,
      avoidCollisions: b
    } : {};
    return /* @__PURE__ */ p(
      Ft,
      {
        scope: e,
        content: y,
        viewport: O,
        onViewportChange: F,
        itemRefCallback: fe,
        selectedItem: k,
        onItemLeave: me,
        itemTextRefCallback: te,
        focusSelectedItem: Q,
        selectedItemText: U,
        position: t,
        isPositioned: H,
        searchRef: ce,
        children: /* @__PURE__ */ p(mt, { as: Ee, allowPinchZoom: !0, children: /* @__PURE__ */ p(
          ut,
          {
            asChild: !0,
            trapped: d.open,
            onMountAutoFocus: (S) => {
              S.preventDefault();
            },
            onUnmountAutoFocus: E(n, (S) => {
              var I, M;
              (I = d.trigger) == null || I.focus({ preventScroll: !0 }), (M = document.getSelection()) == null || M.empty(), S.preventDefault();
            }),
            children: /* @__PURE__ */ p(
              ct,
              {
                asChild: !0,
                disableOutsidePointerEvents: !0,
                onEscapeKeyDown: r,
                onPointerDownOutside: c,
                onFocusOutside: (S) => S.preventDefault(),
                onDismiss: () => d.onOpenChange(!1),
                children: /* @__PURE__ */ p(
                  ae,
                  {
                    role: "listbox",
                    id: d.contentId,
                    "data-state": d.open ? "open" : "closed",
                    "aria-multiselectable": d.multi ? "true" : void 0,
                    dir: d.dir,
                    onContextMenu: (S) => S.preventDefault(),
                    ...g,
                    ...ne,
                    onPlaced: () => L(!0),
                    ref: _,
                    style: {
                      // flex layout so we can place the scroll buttons properly
                      display: "flex",
                      flexDirection: "column",
                      // reset the outline by default as the content MAY get focused
                      outline: "none",
                      ...g.style
                    },
                    onKeyDown: E(g.onKeyDown, (S) => {
                      const I = S.ctrlKey || S.altKey || S.metaKey;
                      if (S.key === "Tab" && S.preventDefault(), !I && S.key.length === 1 && ee(S.key), ["ArrowUp", "ArrowDown", "Home", "End"].includes(S.key)) {
                        let P = R().filter((T) => !T.disabled).map((T) => T.ref.current);
                        if (["ArrowUp", "End"].includes(S.key) && (P = P.slice().reverse()), ["ArrowUp", "ArrowDown"].includes(S.key)) {
                          const T = S.target, w = P.indexOf(T);
                          P = P.slice(w + 1);
                        }
                        setTimeout(() => J(P)), S.preventDefault();
                      }
                    })
                  }
                )
              }
            )
          }
        ) })
      }
    );
  }
);
Lt.displayName = Oo;
const Do = "SelectItemAlignedPosition", Bt = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, onPlaced: t, ...n } = o, r = X(le, e), c = oe(le, e), [l, a] = s.useState(null), [h, C] = s.useState(null), v = A(i, (_) => C(_)), x = ve(e), u = s.useRef(!1), f = s.useRef(!0), { viewport: m, selectedItem: b, selectedItemText: g, focusSelectedItem: d } = c, y = s.useCallback(() => {
      if (r.trigger && r.valueNode && l && h && m && b && g) {
        const _ = r.trigger.getBoundingClientRect(), k = h.getBoundingClientRect(), Z = r.valueNode.getBoundingClientRect(), U = g.getBoundingClientRect();
        if (r.dir !== "rtl") {
          const T = U.left - k.left, w = Z.left - T, B = _.left - w, j = _.width + B, D = Math.max(j, k.width), ue = window.innerWidth - q, he = rt(w, [q, ue - D]);
          l.style.minWidth = `${j}px`, l.style.left = `${he}px`;
        } else {
          const T = k.right - U.right, w = window.innerWidth - Z.right - T, B = window.innerWidth - _.right - w, j = _.width + B, D = Math.max(j, k.width), ue = window.innerWidth - q, he = rt(w, [q, ue - D]);
          l.style.minWidth = `${j}px`, l.style.right = `${he}px`;
        }
        const W = x(), R = window.innerHeight - q * 2, H = m.scrollHeight, L = window.getComputedStyle(h), z = parseInt(L.borderTopWidth, 10), J = parseInt(L.paddingTop, 10), Q = parseInt(L.borderBottomWidth, 10), K = parseInt(L.paddingBottom, 10), G = z + J + H + K + Q, ce = Math.min(b.offsetHeight * 5, G), ee = window.getComputedStyle(m), fe = parseInt(ee.paddingTop, 10), me = parseInt(ee.paddingBottom, 10), te = _.top + _.height / 2 - q, ae = R - te, ne = b.offsetHeight / 2, S = b.offsetTop + ne, I = z + J + S, M = G - I;
        if (I <= te) {
          const T = b === W[W.length - 1].ref.current;
          l.style.bottom = "0px";
          const w = h.clientHeight - m.offsetTop - m.offsetHeight, B = Math.max(
            ae,
            ne + // viewport might have padding bottom, include it to avoid a scrollable viewport
            (T ? me : 0) + w + Q
          ), j = I + B;
          l.style.height = `${j}px`;
        } else {
          const T = b === W[0].ref.current;
          l.style.top = "0px";
          const B = Math.max(
            te,
            z + m.offsetTop + // viewport might have padding top, include it to avoid a scrollable viewport
            (T ? fe : 0) + ne
          ) + M;
          l.style.height = `${B}px`, m.scrollTop = I - te + m.offsetTop;
        }
        l.style.margin = `${q}px 0`, l.style.minHeight = `${ce}px`, l.style.maxHeight = `${R}px`, t == null || t(), requestAnimationFrame(() => u.current = !0);
      }
    }, [
      x,
      r.trigger,
      r.valueNode,
      l,
      h,
      m,
      b,
      g,
      r.dir,
      t
    ]);
    $(() => y(), [y]);
    const [V, O] = s.useState();
    $(() => {
      h && O(window.getComputedStyle(h).zIndex);
    }, [h]);
    const F = s.useCallback(
      (_) => {
        _ && f.current === !0 && (y(), d == null || d(), f.current = !1);
      },
      [y, d]
    );
    return /* @__PURE__ */ p(
      Fo,
      {
        scope: e,
        contentWrapper: l,
        shouldExpandOnScrollRef: u,
        onScrollButtonChange: F,
        children: /* @__PURE__ */ p(
          "div",
          {
            ref: a,
            style: {
              display: "flex",
              flexDirection: "column",
              position: "fixed",
              zIndex: V
            },
            children: /* @__PURE__ */ p(
              N.div,
              {
                ...n,
                ref: v,
                style: {
                  // When we get the height of the content, it includes borders. If we were to set
                  // the height without having `boxSizing: 'border-box'` it would be too big.
                  boxSizing: "border-box",
                  // We need to ensure the content doesn't get taller than the wrapper
                  maxHeight: "100%",
                  ...n.style
                }
              }
            )
          }
        )
      }
    );
  }
);
Bt.displayName = Do;
const ko = "SelectPopperPosition", Re = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, align: t = "start", collisionPadding: n = q, ...r } = o, c = Ve(e);
    return /* @__PURE__ */ p(
      ie.Content,
      {
        ...c,
        ...r,
        ref: i,
        align: t,
        collisionPadding: n,
        style: {
          // Ensure border-box for floating-ui calculations
          boxSizing: "border-box",
          ...r.style,
          "--radix-select-content-transform-origin": "var(--radix-popper-transform-origin)",
          "--radix-select-content-available-width": "var(--radix-popper-available-width)",
          "--radix-select-content-available-height": "var(--radix-popper-available-height)",
          "--radix-select-trigger-width": "var(--radix-popper-anchor-width)",
          "--radix-select-trigger-height": "var(--radix-popper-anchor-height)"
        }
      }
    );
  }
);
Re.displayName = ko;
const [Fo, Ge] = pe(
  le,
  {}
), Ae = "SelectViewport", je = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, ...t } = o, n = oe(Ae, e), r = Ge(Ae, e), c = A(i, n.onViewportChange), l = s.useRef(0);
    return /* @__PURE__ */ ye(Se, { children: [
      /* @__PURE__ */ p(
        "style",
        {
          dangerouslySetInnerHTML: {
            __html: "[data-radix-select-viewport]{scrollbar-width:none;-ms-overflow-style:none;-webkit-overflow-scrolling:touch;}[data-radix-select-viewport]::-webkit-scrollbar{display:none}"
          }
        }
      ),
      /* @__PURE__ */ p(Te.Slot, { scope: e, children: /* @__PURE__ */ p(
        N.div,
        {
          "data-radix-select-viewport": "",
          role: "presentation",
          ...t,
          ref: c,
          style: {
            // we use position: 'relative' here on the `viewport` so that when we call
            // `selectedItem.offsetTop` in calculations, the offset is relative to the viewport
            // (independent of the scrollUpButton).
            position: "relative",
            flex: 1,
            overflow: "auto",
            ...t.style
          },
          onScroll: E(t.onScroll, (a) => {
            const h = a.currentTarget, { contentWrapper: C, shouldExpandOnScrollRef: v } = r;
            if (v != null && v.current && C) {
              const x = Math.abs(l.current - h.scrollTop);
              if (x > 0) {
                const u = window.innerHeight - q * 2, f = parseFloat(C.style.minHeight), m = parseFloat(C.style.height), b = Math.max(f, m);
                if (b < u) {
                  const g = b + x, d = Math.min(u, g), y = g - d;
                  C.style.height = `${d}px`, C.style.bottom === "0px" && (h.scrollTop = y > 0 ? y : 0, C.style.justifyContent = "flex-end");
                }
              }
            }
            l.current = h.scrollTop;
          })
        }
      ) })
    ] });
  }
);
je.displayName = Ae;
const $t = "SelectGroup", [Lo, Bo] = pe($t), Ye = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, ...t } = o, n = se();
    return /* @__PURE__ */ p(Lo, { scope: e, id: n, children: /* @__PURE__ */ p(N.div, { role: "group", "aria-labelledby": n, ...t, ref: i }) });
  }
);
Ye.displayName = $t;
const Ut = "SelectLabel", qe = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, ...t } = o, n = Bo(Ut, e);
    return /* @__PURE__ */ p(N.div, { id: n.id, ...t, ref: i });
  }
);
qe.displayName = Ut;
const be = "SelectItem", [$o, Ht] = pe(be), Xe = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, value: t, disabled: n = !1, textValue: r, ...c } = o, l = X(be, e), a = oe(be, e), h = typeof t == "string" ? Array.isArray(l.value) ? l.value.includes(t) : l.value === t : t.every((d) => {
      var y;
      return (y = l.value) == null ? void 0 : y.includes(d);
    }), C = Array.isArray(l.value) && Array.isArray(t) && t.some((d) => {
      var y;
      return (y = l.value) == null ? void 0 : y.includes(d);
    }), [v, x] = s.useState(r ?? ""), [u, f] = s.useState(!1), m = A(
      i,
      (d) => {
        var y;
        return (y = a.itemRefCallback) == null ? void 0 : y.call(a, d, t, n);
      }
    ), b = se(), g = () => {
      if (!n) {
        let d = l.multi && typeof t == "string" ? [t] : t;
        C && !h ? l.onValueChange(d) : Array.isArray(l.value) && (d = Gt(t, l.value)), l.onValueChange(d), l.multi || l.onOpenChange(!1);
      }
    };
    if (!l.multi && Array.isArray(t))
      throw new Error("You can only pass an array of values in multi selects");
    return /* @__PURE__ */ p(
      $o,
      {
        scope: e,
        value: t,
        disabled: n,
        textId: b,
        isSelected: h,
        isIntermediate: C,
        onItemTextChange: s.useCallback((d) => {
          x((y) => y || ((d == null ? void 0 : d.textContent) ?? "").trim());
        }, []),
        children: /* @__PURE__ */ p(Te.ItemSlot, { scope: e, value: t, disabled: n, textValue: v, children: /* @__PURE__ */ p(
          N.div,
          {
            role: "option",
            "aria-labelledby": b,
            "data-highlighted": u ? "" : void 0,
            "aria-selected": l.multi ? void 0 : h && u,
            "aria-checked": l.multi ? h : void 0,
            "data-state": h ? "checked" : "unchecked",
            "aria-disabled": n || void 0,
            "data-disabled": n ? "" : void 0,
            tabIndex: n ? void 0 : -1,
            ...c,
            ref: m,
            onFocus: E(c.onFocus, () => f(!0)),
            onBlur: E(c.onBlur, () => f(!1)),
            onPointerUp: E(c.onPointerUp, g),
            onPointerMove: E(c.onPointerMove, (d) => {
              var y;
              n ? (y = a.onItemLeave) == null || y.call(a) : d.currentTarget.focus({ preventScroll: !0 });
            }),
            onPointerLeave: E(c.onPointerLeave, (d) => {
              var y;
              d.currentTarget === document.activeElement && ((y = a.onItemLeave) == null || y.call(a));
            }),
            onKeyDown: E(c.onKeyDown, (d) => {
              var V;
              ((V = a.searchRef) == null ? void 0 : V.current) !== "" && d.key === " " || (Vo.includes(d.key) && g(), d.key === " " && d.preventDefault());
            })
          }
        ) })
      }
    );
  }
);
Xe.displayName = be;
const ge = "SelectItemText", Ze = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, className: t, style: n, ...r } = o, c = X(ge, e), l = oe(ge, e), a = Ht(ge, e), h = Ao(ge, e), [C, v] = s.useState(null), x = A(
      i,
      (g) => v(g),
      a.onItemTextChange,
      (g) => {
        var d;
        return (d = l.itemTextRefCallback) == null ? void 0 : d.call(l, g, a.value, a.disabled);
      }
    ), u = C == null ? void 0 : C.textContent, f = s.useMemo(
      () => /* @__PURE__ */ p(
        "option",
        {
          value: a.value,
          disabled: a.disabled,
          children: u
        },
        Array.isArray(a.value) ? a.value.join(";") : a.value
      ),
      [a.disabled, a.value, u]
    ), { onNativeOptionAdd: m, onNativeOptionRemove: b } = h;
    return $(() => (m(f), () => b(f)), [m, b, f]), /* @__PURE__ */ ye(Se, { children: [
      /* @__PURE__ */ p(N.span, { id: a.textId, ...r, ref: x }),
      a.isSelected && c.valueNode && !c.valueNodeHasChildren ? we.createPortal(r.children, c.valueNode) : null
    ] });
  }
);
Ze.displayName = ge;
const zt = "SelectItemIndicator", Je = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, children: t, ...n } = o, r = Ht(zt, e);
    return typeof t == "function" ? /* @__PURE__ */ p(N.span, { "aria-hidden": !0, ...n, ref: i, children: t({
      isSelected: r.isSelected,
      isIntermediate: r.isIntermediate
    }) }) : r.isSelected ? /* @__PURE__ */ p(N.span, { "aria-hidden": !0, ...n, ref: i, children: t }) : null;
  }
);
Je.displayName = zt;
const _e = "SelectScrollUpButton", Qe = s.forwardRef(
  (o, i) => {
    const e = oe(_e, o.__scopeSelect), t = Ge(_e, o.__scopeSelect), [n, r] = s.useState(!1), c = A(i, t.onScrollButtonChange);
    return $(() => {
      if (e.viewport && e.isPositioned) {
        const l = e.viewport, a = () => {
          const h = l.scrollTop > 0;
          r(h);
        };
        return a(), l.addEventListener("scroll", a), () => l.removeEventListener("scroll", a);
      }
    }, [e.viewport, e.isPositioned]), n ? /* @__PURE__ */ p(
      tt,
      {
        ...o,
        ref: c,
        onAutoScroll: () => {
          const { viewport: l, selectedItem: a } = e;
          l && a && (l.scrollTop -= a.offsetHeight);
        }
      }
    ) : null;
  }
);
Qe.displayName = _e;
const Me = "SelectScrollDownButton", et = s.forwardRef(
  (o, i) => {
    const e = oe(Me, o.__scopeSelect), t = Ge(Me, o.__scopeSelect), [n, r] = s.useState(!1), c = A(i, t.onScrollButtonChange);
    return $(() => {
      if (e.viewport && e.isPositioned) {
        const l = e.viewport, a = () => {
          const h = l.scrollHeight - l.clientHeight, C = Math.ceil(l.scrollTop) < h;
          r(C);
        };
        return a(), l.addEventListener("scroll", a), () => l.removeEventListener("scroll", a);
      }
    }, [e.viewport, e.isPositioned]), n ? /* @__PURE__ */ p(
      tt,
      {
        ...o,
        ref: c,
        onAutoScroll: () => {
          const { viewport: l, selectedItem: a } = e;
          l && a && (l.scrollTop += a.offsetHeight);
        }
      }
    ) : null;
  }
);
et.displayName = Me;
const tt = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, onAutoScroll: t, ...n } = o, r = oe("SelectScrollButton", e), c = s.useRef(null), l = ve(e), a = s.useCallback(() => {
      c.current !== null && (window.clearInterval(c.current), c.current = null);
    }, []);
    return s.useEffect(() => () => a(), [a]), $(() => {
      var C;
      const h = l().find((v) => v.ref.current === document.activeElement);
      (C = h == null ? void 0 : h.ref.current) == null || C.scrollIntoView({ block: "nearest" });
    }, [l]), /* @__PURE__ */ p(
      N.div,
      {
        "aria-hidden": !0,
        ...n,
        ref: i,
        style: { flexShrink: 0, ...n.style },
        onPointerMove: E(n.onPointerMove, () => {
          var h;
          (h = r.onItemLeave) == null || h.call(r), c.current === null && (c.current = window.setInterval(t, 50));
        }),
        onPointerLeave: E(n.onPointerLeave, () => {
          a();
        })
      }
    );
  }
);
tt.displayName = "SelectScrollButtonImpl";
const Uo = "SelectSeparator", ot = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, ...t } = o;
    return /* @__PURE__ */ p(N.div, { "aria-hidden": !0, ...t, ref: i });
  }
);
ot.displayName = Uo;
const Oe = "SelectArrow", nt = s.forwardRef(
  (o, i) => {
    const { __scopeSelect: e, ...t } = o, n = Ve(e), r = X(Oe, e), c = oe(Oe, e);
    return r.open && c.position === "popper" ? /* @__PURE__ */ p(ie.Arrow, { ...n, ...t, ref: i }) : null;
  }
);
nt.displayName = Oe;
const Ho = "BubbleSelect", zo = s.forwardRef(
  (o, i) => {
    const { value: e, ...t } = o, n = s.useRef(null), r = A(i, n), c = Xt(e), l = X(Ho, void 0);
    s.useEffect(() => {
      const h = n.current, C = window.HTMLSelectElement.prototype, x = Object.getOwnPropertyDescriptor(C, "value").set;
      if (c !== e && x) {
        const u = new Event("change", { bubbles: !0 });
        x.call(h, e), h.dispatchEvent(u);
      }
    }, [c, e]);
    let a = e;
    return l.multi && !Array.isArray(e) && (a = []), /* @__PURE__ */ p(Zt, { asChild: !0, children: /* @__PURE__ */ p(
      "select",
      {
        ...t,
        multiple: l.multi ? !0 : void 0,
        ref: r,
        defaultValue: a
      }
    ) });
  }
);
zo.displayName = "BubbleSelect";
function Wt(o) {
  const i = Io(o), e = s.useRef(""), t = s.useRef(0), n = s.useCallback(
    (c) => {
      const l = e.current + c;
      i(l), function a(h) {
        e.current = h, window.clearTimeout(t.current), h !== "" && (t.current = window.setTimeout(() => a(""), 1e3));
      }(l);
    },
    [i]
  ), r = s.useCallback(() => {
    e.current = "", window.clearTimeout(t.current);
  }, []);
  return s.useEffect(() => () => window.clearTimeout(t.current), []), [e, n, r];
}
function Kt(o, i, e) {
  const n = i.length > 1 && Array.from(i).every((h) => h === i[0]) ? i[0] : i, r = e ? o.indexOf(e) : -1;
  let c = Wo(o, Math.max(r, 0));
  n.length === 1 && (c = c.filter((h) => h !== e));
  const a = c.find((h) => h.textValue.toLowerCase().startsWith(n.toLowerCase()));
  return a !== e ? a : void 0;
}
function Wo(o, i) {
  return o.map((e, t) => o[(i + t) % o.length]);
}
const Gt = (o, i = []) => {
  if (Array.isArray(o))
    return o.reduce((t, n) => Gt(n, t), i);
  const e = i.indexOf(o);
  return e === -1 ? [...i, o] : [...i.slice(0, e), ...i.slice(e + 1)];
}, Ko = $e, Go = Ue, jo = He, Yo = ze, qo = We, Xo = Ke, Zo = je, Jo = Ye, Qo = qe, en = Xe, tn = Ze, on = Je, nn = Qe, rn = et, ln = ot, sn = nt, An = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Arrow: sn,
  Content: Xo,
  Group: Jo,
  Icon: Yo,
  Item: en,
  ItemIndicator: on,
  ItemText: tn,
  Label: Qo,
  Portal: qo,
  Root: Ko,
  ScrollDownButton: rn,
  ScrollUpButton: nn,
  Select: $e,
  SelectArrow: nt,
  SelectContent: Ke,
  SelectGroup: Ye,
  SelectIcon: ze,
  SelectItem: Xe,
  SelectItemIndicator: Je,
  SelectItemText: Ze,
  SelectLabel: qe,
  SelectPortal: We,
  SelectScrollDownButton: et,
  SelectScrollUpButton: Qe,
  SelectSeparator: ot,
  SelectTrigger: Ue,
  SelectValue: He,
  SelectViewport: je,
  Separator: ln,
  Trigger: Go,
  Value: jo,
  Viewport: Zo,
  createSelectScope: Eo
}, Symbol.toStringTag, { value: "Module" }));
function _n(o, i, { checkForDefaultPrevented: e = !0 } = {}) {
  return function(n) {
    if (o == null || o(n), e === !1 || !n.defaultPrevented)
      return i == null ? void 0 : i(n);
  };
}
export {
  Rn as Combobox,
  An as Select,
  _n as composeEventHandlers,
  Jt as createCollection,
  Io as useCallbackRef,
  Qt as useCollator,
  De as useFilter,
  eo as usePrev
};
