import type { Constants, If, Intersect } from '../../../utils';
import type { Attribute } from '../..';
export type MediaTargetUID = 'plugin::upload.file';
export type MediaKind = 'images' | 'videos' | 'files' | 'audios';
export interface MediaProperties<TKind extends MediaKind | undefined = undefined, TMultiple extends Constants.BooleanValue = Constants.False> {
    allowedTypes?: TKind | TKind[];
    multiple?: TMultiple;
}
/**
 * Represents a media Strapi attribute along with its options
 */
export type Media<TKind extends MediaKind | undefined = undefined, TMultiple extends Constants.BooleanValue = Constants.False> = Intersect<[
    Attribute.OfType<'media'>,
    MediaProperties<TKind, TMultiple>,
    Attribute.ConfigurableOption,
    Attribute.RequiredOption,
    Attribute.PrivateOption,
    Attribute.WritableOption,
    Attribute.VisibleOption
]>;
export type MediaValue<TMultiple extends Constants.BooleanValue = Constants.False> = If<TMultiple, any[], any>;
export type GetMediaValue<TAttribute extends Attribute.Attribute> = TAttribute extends Media<infer _TKind, infer TMultiple> ? MediaValue<TMultiple> : never;
export type MediaTarget<TAttribute extends Attribute.Attribute> = TAttribute extends Media<MediaKind | undefined, Constants.BooleanValue> ? MediaTargetUID : never;
//# sourceMappingURL=media.d.ts.map