import { ReactNode, FC } from 'react';
interface VirtualizedListProps {
    children?: ReactNode;
    estimatedItemSize?: number;
    overscan?: number;
    itemCount?: number;
    renderItem?: (index: number) => ReactNode;
}
/**
 * VirtualizedList - Wraps Combobox children in a virtualizer for performance
 * This component should be used inside ScrollArea to virtualize the list
 *
 * Two modes:
 * 1. Children mode (default): Pass children directly
 * 2. Lazy mode: Pass itemCount + renderItem for maximum performance
 */
export declare const VirtualizedList: FC<VirtualizedListProps>;
export {};
//# sourceMappingURL=VirtualizedList.d.ts.map