import type { errors } from '@strapi/utils';
import type { Struct, UID } from '@strapi/types';
export interface RecentDocument {
    kind: Struct.ContentTypeKind;
    contentTypeUid: UID.ContentType;
    contentTypeDisplayName: string;
    documentId: string;
    locale: string | null;
    status?: 'draft' | 'published' | 'modified';
    title: string;
    updatedAt: Date;
    publishedAt?: Date | null;
}
export declare namespace GetRecentDocuments {
    interface Request {
        body: {};
        query: {
            action: 'update' | 'publish';
        };
    }
    interface Response {
        data: RecentDocument[];
        error?: errors.ApplicationError;
    }
}
export declare namespace GetKeyStatistics {
    interface Request {
        body: {};
    }
    interface Response {
        data: {
            assets: number;
            contentTypes: number;
            components: number;
            locales: number | null;
            admins: number;
            webhooks: number;
            apiTokens: number;
        };
        error?: errors.ApplicationError;
    }
}
export declare namespace GetCountDocuments {
    interface Request {
        body: {};
    }
    interface Response {
        data: {
            draft: number;
            published: number;
            modified: number;
        };
        error?: errors.ApplicationError;
    }
}
export declare namespace Homepage {
    type WidgetUID = string;
    type Width = 4 | 6 | 8 | 12;
    interface Layout {
        version: number;
        widgets: Array<{
            uid: WidgetUID;
            width: Width;
        }>;
        updatedAt: string;
    }
    interface LayoutWrite {
        widgets: Array<{
            uid: WidgetUID;
            width: Width;
        }>;
    }
}
export declare namespace GetHomepageLayout {
    interface Response {
        data: Homepage.Layout;
    }
}
export declare namespace UpdateHomepageLayout {
    interface Request {
        body: Homepage.LayoutWrite;
    }
    interface Response {
        data: Homepage.Layout;
    }
}
