import type { Context } from 'koa';
import type { GetProjectSettings } from '../../../shared/contracts/admin';
/**
 * A set of functions called "actions" for `Admin`
 */
declare const _default: {
    getProjectType(): Promise<{
        data: {
            isEE: boolean;
            features: never[];
            flags: {};
            ai: {
                enabled: boolean;
            };
        };
    }>;
    init(): Promise<{
        data: {
            uuid: false;
            hasAdmin: boolean;
            menuLogo: string | null;
            authLogo: string | null;
        };
    }>;
    getProjectSettings(): Promise<GetProjectSettings.Response>;
    updateProjectSettings(ctx: Context): Promise<GetProjectSettings.Response>;
    telemetryProperties(ctx: Context): Promise<{
        data: {
            useTypescriptOnServer: any;
            useTypescriptOnAdmin: any;
            isHostedOnStrapiCloud: boolean;
            aiLicenseKey: string | undefined;
            numberOfAllContentTypes: number;
            numberOfComponents: number;
            numberOfDynamicZones: number;
        };
    } | undefined>;
    information(): Promise<{
        data: {
            currentEnvironment: string;
            autoReload: false;
            strapiVersion: null;
            dependencies: {};
            projectId: null;
            nodeVersion: string;
            communityEdition: boolean;
            useYarn: boolean;
        };
    }>;
    plugins(ctx: Context): Promise<void>;
    licenseTrialTimeLeft(): Promise<{
        trialEndsAt: string;
    } | null>;
    getGuidedTourMeta(ctx: Context): Promise<{
        data: {
            isFirstSuperAdminUser: boolean;
            schemas: import("@strapi/types/dist/public").ContentTypeSchemas;
        };
    }>;
};
export default _default;
//# sourceMappingURL=admin.d.ts.map