'use strict';

var crypto = require('crypto');

const REFRESH_COOKIE_NAME = 'strapi_admin_refresh';
const DEFAULT_MAX_REFRESH_TOKEN_LIFESPAN = 30 * 24 * 60 * 60;
const DEFAULT_IDLE_REFRESH_TOKEN_LIFESPAN = 14 * 24 * 60 * 60;
const DEFAULT_MAX_SESSION_LIFESPAN = 1 * 24 * 60 * 60;
const DEFAULT_IDLE_SESSION_LIFESPAN = 2 * 60 * 60;
const getRefreshCookieOptions = (secureRequest)=>{
    const configuredSecure = strapi.config.get('admin.auth.cookie.secure');
    const isProduction = process.env.NODE_ENV === 'production';
    const domain = strapi.config.get('admin.auth.cookie.domain') || strapi.config.get('admin.auth.domain');
    const path = strapi.config.get('admin.auth.cookie.path', '/admin');
    const sameSite = strapi.config.get('admin.auth.cookie.sameSite') ?? 'lax';
    let isSecure;
    if (typeof configuredSecure === 'boolean') {
        isSecure = configuredSecure;
    } else if (secureRequest !== undefined) {
        isSecure = isProduction && secureRequest;
    } else {
        isSecure = isProduction;
    }
    return {
        httpOnly: true,
        secure: isSecure,
        overwrite: true,
        domain,
        path,
        sameSite,
        maxAge: undefined
    };
};
const getLifespansForType = (type)=>{
    {
        const idleSeconds = Number(strapi.config.get('admin.auth.sessions.idleRefreshTokenLifespan', DEFAULT_IDLE_REFRESH_TOKEN_LIFESPAN));
        const maxSeconds = Number(strapi.config.get('admin.auth.sessions.maxRefreshTokenLifespan', DEFAULT_MAX_REFRESH_TOKEN_LIFESPAN));
        return {
            idleSeconds,
            maxSeconds
        };
    }
};
const buildCookieOptionsWithExpiry = (type, absoluteExpiresAtISO, secureRequest)=>{
    const base = getRefreshCookieOptions(secureRequest);
    if (type === 'session') {
        return base;
    }
    const { idleSeconds } = getLifespansForType();
    const now = Date.now();
    const idleExpiry = now + idleSeconds * 1000;
    const absoluteExpiry = absoluteExpiresAtISO ? new Date(absoluteExpiresAtISO).getTime() : idleExpiry;
    const chosen = new Date(Math.min(idleExpiry, absoluteExpiry));
    return {
        ...base,
        expires: chosen,
        maxAge: Math.max(0, chosen.getTime() - now)
    };
};
const getSessionManager = ()=>{
    const manager = strapi.sessionManager;
    return manager ?? null;
};
const generateDeviceId = ()=>crypto.randomUUID();
const extractDeviceParams = (requestBody)=>{
    const body = requestBody ?? {};
    const deviceId = body.deviceId || generateDeviceId();
    const rememberMe = Boolean(body.rememberMe);
    return {
        deviceId,
        rememberMe
    };
};

exports.DEFAULT_IDLE_REFRESH_TOKEN_LIFESPAN = DEFAULT_IDLE_REFRESH_TOKEN_LIFESPAN;
exports.DEFAULT_IDLE_SESSION_LIFESPAN = DEFAULT_IDLE_SESSION_LIFESPAN;
exports.DEFAULT_MAX_REFRESH_TOKEN_LIFESPAN = DEFAULT_MAX_REFRESH_TOKEN_LIFESPAN;
exports.DEFAULT_MAX_SESSION_LIFESPAN = DEFAULT_MAX_SESSION_LIFESPAN;
exports.REFRESH_COOKIE_NAME = REFRESH_COOKIE_NAME;
exports.buildCookieOptionsWithExpiry = buildCookieOptionsWithExpiry;
exports.extractDeviceParams = extractDeviceParams;
exports.generateDeviceId = generateDeviceId;
exports.getRefreshCookieOptions = getRefreshCookieOptions;
exports.getSessionManager = getSessionManager;
//# sourceMappingURL=session-auth.js.map
