/// <reference types="koa" />
declare const _default: {
    authentication: {
        getProviders(ctx: import("koa").Context): Promise<void>;
        getProviderLoginOptions(ctx: import("koa").Context): Promise<void>;
        updateProviderLoginOptions(ctx: import("koa").Context): Promise<void>;
        providerLogin(ctx: import("koa").Context, next: import("koa").Next): any;
    };
    role: {
        create(ctx: import("koa").Context): Promise<void>;
        deleteOne(ctx: import("koa").Context): Promise<any>;
        deleteMany(ctx: import("koa").Context): Promise<any>;
    };
    user: {
        create(ctx: import("koa").Context): Promise<void>;
        update(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
        isSSOLocked(ctx: import("koa").Context): Promise<void>;
    };
    admin: {
        getProjectType(): Promise<{
            data: {
                isEE: boolean | undefined;
                isTrial: boolean;
                features: {
                    [key: string]: any;
                    name: string;
                }[];
                flags: {};
                type: string | null | undefined;
                ai: {
                    enabled: boolean;
                };
            };
        } | {
            data: {
                isEE: boolean;
                features: never[];
                flags: {};
                ai: {
                    enabled: boolean;
                };
                isTrial?: undefined;
                type?: undefined;
            };
        }>;
        licenseLimitInformation(): Promise<{
            data: {
                enforcementUserCount: any;
                currentActiveUserCount: any;
                permittedSeats: number | null | undefined;
                shouldNotify: boolean;
                shouldStopCreate: boolean;
                licenseLimitStatus: string | null;
                isHostedOnStrapiCloud: boolean;
                aiLicenseKey: unknown;
                type: string | null | undefined;
                isTrial: boolean;
                features: {
                    [key: string]: any;
                    name: string;
                }[];
            };
        }>;
    };
};
export default _default;
//# sourceMappingURL=index.d.ts.map