import { Middleware, Reducer } from '@reduxjs/toolkit';
import { AppState } from '../../reducer';
type PreloadState = Partial<{
    admin_app: AppState;
}>;
/**
 * @description This is the main store configuration function, injected Reducers use our legacy app.addReducer API,
 * which we're trying to phase out. App Middlewares could potentially be improved...?
 */
declare const configureStoreImpl: (preloadedState?: PreloadState, appMiddlewares?: Array<() => Middleware>, injectedReducers?: Record<string, Reducer>) => import("@reduxjs/toolkit/dist/configureStore").ToolkitStore<{
    readonly adminApi: import("@reduxjs/toolkit/query").CombinedState<{}, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig", "adminApi">;
    readonly admin_app: AppState;
}, import("redux").AnyAction, (import("@reduxjs/toolkit").ThunkMiddleware<{
    readonly adminApi: import("@reduxjs/toolkit/query").CombinedState<{}, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig", "adminApi">;
    readonly admin_app: AppState;
}, import("redux").AnyAction> | Middleware<{}, import("@reduxjs/toolkit/query").RootState<{}, string, "adminApi">, import("@reduxjs/toolkit").ThunkDispatch<any, any, import("redux").AnyAction>>)[]>;
type Store = ReturnType<typeof configureStoreImpl> & {
    asyncReducers: Record<string, Reducer>;
    injectReducer: (key: string, asyncReducer: Reducer) => void;
};
type RootState = ReturnType<Store['getState']>;
type Dispatch = Store['dispatch'];
export { configureStoreImpl as configureStore };
export type { RootState, Dispatch, AppState, Store, PreloadState };
