'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var camelCase = require('lodash/camelCase');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var yup = require('yup');
var Form = require('../../../components/Form.js');
var Renderer = require('../../../components/FormInputs/Renderer.js');
var UnauthenticatedLogo = require('../../../components/UnauthenticatedLogo.js');
var Auth = require('../../../features/Auth.js');
var UnauthenticatedLayout = require('../../../layouts/UnauthenticatedLayout.js');
var translatedErrors = require('../../../utils/translatedErrors.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);
var yup__namespace = /*#__PURE__*/_interopNamespaceDefault(yup);

const LOGIN_SCHEMA = yup__namespace.object().shape({
    email: yup__namespace.string().nullable().email({
        id: translatedErrors.translatedErrors.email.id,
        defaultMessage: 'Not a valid email'
    }).required(translatedErrors.translatedErrors.required),
    password: yup__namespace.string().required(translatedErrors.translatedErrors.required).nullable(),
    rememberMe: yup__namespace.bool().nullable()
});
const Login = ({ children })=>{
    const [apiError, setApiError] = React__namespace.useState();
    const { formatMessage } = reactIntl.useIntl();
    const { search: searchString } = reactRouterDom.useLocation();
    const query = React__namespace.useMemo(()=>new URLSearchParams(searchString), [
        searchString
    ]);
    const navigate = reactRouterDom.useNavigate();
    const { login } = Auth.useAuth('Login', (auth)=>auth);
    const handleLogin = async (body)=>{
        setApiError(undefined);
        const res = await login(body);
        if ('error' in res) {
            const message = res.error.message ?? 'Something went wrong';
            if (camelCase(message).toLowerCase() === 'usernotactive') {
                navigate('/auth/oops');
                return;
            }
            setApiError(message);
        } else {
            const redirectTo = query.get('redirectTo');
            const redirectUrl = redirectTo ? decodeURIComponent(redirectTo) : '/';
            navigate(redirectUrl);
        }
    };
    return /*#__PURE__*/ jsxRuntime.jsx(UnauthenticatedLayout.UnauthenticatedLayout, {
        children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Main, {
            children: [
                /*#__PURE__*/ jsxRuntime.jsxs(UnauthenticatedLayout.LayoutContent, {
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsxs(UnauthenticatedLayout.Column, {
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsx(UnauthenticatedLogo.Logo, {}),
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                    paddingTop: 6,
                                    paddingBottom: 1,
                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                        variant: "alpha",
                                        tag: "h1",
                                        textAlign: "center",
                                        children: formatMessage({
                                            id: 'Auth.form.welcome.title',
                                            defaultMessage: 'Welcome!'
                                        })
                                    })
                                }),
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                    paddingBottom: 7,
                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                        variant: "epsilon",
                                        textColor: "neutral600",
                                        textAlign: "center",
                                        display: "block",
                                        children: formatMessage({
                                            id: 'Auth.form.welcome.subtitle',
                                            defaultMessage: 'Log in to your Strapi account'
                                        })
                                    })
                                }),
                                apiError ? /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                    id: "global-form-error",
                                    role: "alert",
                                    tabIndex: -1,
                                    textColor: "danger600",
                                    children: apiError
                                }) : null
                            ]
                        }),
                        /*#__PURE__*/ jsxRuntime.jsx(Form.Form, {
                            method: "PUT",
                            initialValues: {
                                email: '',
                                password: '',
                                rememberMe: false
                            },
                            onSubmit: (values)=>{
                                handleLogin(values);
                            },
                            validationSchema: LOGIN_SCHEMA,
                            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                direction: "column",
                                alignItems: "stretch",
                                gap: 6,
                                children: [
                                    [
                                        {
                                            label: formatMessage({
                                                id: 'Auth.form.email.label',
                                                defaultMessage: 'Email'
                                            }),
                                            name: 'email',
                                            placeholder: formatMessage({
                                                id: 'Auth.form.email.placeholder',
                                                defaultMessage: 'kai@doe.com'
                                            }),
                                            required: true,
                                            type: 'email'
                                        },
                                        {
                                            label: formatMessage({
                                                id: 'global.password',
                                                defaultMessage: 'Password'
                                            }),
                                            name: 'password',
                                            required: true,
                                            type: 'password'
                                        },
                                        {
                                            label: formatMessage({
                                                id: 'Auth.form.rememberMe.label',
                                                defaultMessage: 'Remember me'
                                            }),
                                            name: 'rememberMe',
                                            type: 'checkbox'
                                        }
                                    ].map((field)=>/*#__PURE__*/ jsxRuntime.jsx(Renderer.InputRenderer, {
                                            ...field
                                        }, field.name)),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                                        fullWidth: true,
                                        type: "submit",
                                        children: formatMessage({
                                            id: 'Auth.form.button.login',
                                            defaultMessage: 'Login'
                                        })
                                    })
                                ]
                            })
                        }),
                        children
                    ]
                }),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                    justifyContent: "center",
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                        paddingTop: 4,
                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Link, {
                            isExternal: false,
                            tag: reactRouterDom.NavLink,
                            to: "/auth/forgot-password",
                            children: formatMessage({
                                id: 'Auth.link.forgot-password',
                                defaultMessage: 'Forgot your password?'
                            })
                        })
                    })
                })
            ]
        })
    });
};

exports.Login = Login;
//# sourceMappingURL=Login.js.map
