import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { Flex, useCollator, Divider, Box, IconButton } from '@strapi/design-system';
import { List, Cross } from '@strapi/icons';
import { useIntl } from 'react-intl';
import { useLocation } from 'react-router-dom';
import { styled } from 'styled-components';
import { useTracking } from '../features/Tracking.mjs';
import { MainNav } from './MainNav/MainNav.mjs';
import { MainNavIcons } from './MainNav/MainNavLinks.mjs';
import { NavBrand } from './MainNav/NavBrand.mjs';
import { NavBurgerMenu } from './MainNav/NavBurgerMenu.mjs';
import { NavUser } from './MainNav/NavUser.mjs';
import { TrialCountdown } from './MainNav/TrialCountdown.mjs';

const sortLinks = (links)=>{
    return links.sort((a, b)=>{
        // if no position is defined, we put the link in the position of the external plugins, before the plugins list
        const positionA = a.position ?? 6;
        const positionB = b.position ?? 6;
        if (positionA < positionB) {
            return -1;
        } else {
            return 1;
        }
    });
};
const NavListWrapper = styled(Flex)`
  width: 100%;
  overflow-y: auto;
  scrollbar-width: none;
  -ms-overflow-style: none;

  &::-webkit-scrollbar {
    display: none;
  }
`;
const MenuDetails = styled(Flex)`
  flex: 1;
  flex-direction: row;
  justify-content: space-between;
  overflow-x: auto;

  ${({ theme })=>theme.breakpoints.large} {
    flex-direction: column;
    overflow-y: auto;
    overflow-x: hidden;
  }
`;
const LeftMenu = ({ generalSectionLinks, pluginsSectionLinks, topMobileNavigation, burgerMobileNavigation })=>{
    const [isBurgerMenuShown, setIsBurgerMenuShown] = React.useState(false);
    const { trackUsage } = useTracking();
    const { pathname } = useLocation();
    const { formatMessage, locale } = useIntl();
    const formatter = useCollator(locale, {
        sensitivity: 'base'
    });
    const handleClickOnLink = (destination)=>{
        trackUsage('willNavigate', {
            from: pathname,
            to: destination
        });
    };
    // Close burger menu when route changes
    React.useEffect(()=>{
        setIsBurgerMenuShown(false);
    }, [
        pathname
    ]);
    const listLinksAlphabeticallySorted = [
        ...pluginsSectionLinks,
        ...generalSectionLinks
    ].sort((a, b)=>formatter.compare(formatMessage(a.intlLabel), formatMessage(b.intlLabel)));
    const listLinks = sortLinks(listLinksAlphabeticallySorted);
    /**
   * Return filtered mobile navigation links (used for both top and burger menu)
   */ const mapMobileNavigationLinks = (mobileNavLinks)=>mobileNavLinks.reduce((acc, mobileLink)=>{
            const linkFound = listLinks.find((link)=>link.to === mobileLink.to);
            if (linkFound) {
                acc.push(mobileLink.link ? {
                    ...linkFound,
                    navigationLink: mobileLink.link
                } : linkFound);
            }
            return acc;
        }, []);
    /**
   * Mobile top navigation
   */ const topMobileNavigationLinks = mapMobileNavigationLinks(topMobileNavigation);
    /**
   * Mobile burger menu
   */ const excludedPluginsFromBurgerMenu = [
        'content-manager',
        'content-type-builder',
        'upload',
        'content-releases'
    ];
    const burgerMenuPluginsLinks = pluginsSectionLinks.filter((plugin)=>!excludedPluginsFromBurgerMenu.some((link)=>plugin.to.includes(link)));
    const burgerMobileNavigationLinks = [
        ...burgerMenuPluginsLinks,
        ...mapMobileNavigationLinks(burgerMobileNavigation)
    ];
    return /*#__PURE__*/ jsxs(Fragment, {
        children: [
            /*#__PURE__*/ jsxs(MainNav, {
                children: [
                    /*#__PURE__*/ jsx(NavBrand, {}),
                    /*#__PURE__*/ jsx(Divider, {}),
                    /*#__PURE__*/ jsxs(MenuDetails, {
                        children: [
                            /*#__PURE__*/ jsx(NavListWrapper, {
                                tag: "ul",
                                gap: 3,
                                direction: {
                                    initial: 'row',
                                    large: 'column'
                                },
                                alignItems: "center",
                                justifyContent: {
                                    initial: 'center',
                                    large: 'flex-start'
                                },
                                flex: 1,
                                paddingLeft: {
                                    initial: 3,
                                    large: 0
                                },
                                paddingRight: {
                                    initial: 3,
                                    large: 0
                                },
                                paddingTop: 3,
                                paddingBottom: 3,
                                children: /*#__PURE__*/ jsx(MainNavIcons, {
                                    listLinks: listLinks,
                                    mobileLinks: topMobileNavigationLinks,
                                    handleClickOnLink: handleClickOnLink
                                })
                            }),
                            /*#__PURE__*/ jsx(TrialCountdown, {}),
                            /*#__PURE__*/ jsx(Box, {
                                display: {
                                    initial: 'none',
                                    large: 'flex'
                                },
                                borderStyle: "solid",
                                borderWidth: {
                                    initial: 0,
                                    large: '1px 0 0 0'
                                },
                                borderColor: "neutral150",
                                padding: 3,
                                children: /*#__PURE__*/ jsx(NavUser, {})
                            })
                        ]
                    }),
                    /*#__PURE__*/ jsx(Box, {
                        padding: 3,
                        display: {
                            initial: 'flex',
                            large: 'none'
                        },
                        children: /*#__PURE__*/ jsx(IconButton, {
                            onClick: ()=>setIsBurgerMenuShown((prev)=>!prev),
                            style: {
                                border: 'none'
                            },
                            label: "Menu",
                            type: "button",
                            "aria-expanded": isBurgerMenuShown,
                            "aria-controls": "burger-menu",
                            children: !isBurgerMenuShown ? /*#__PURE__*/ jsx(List, {
                                fill: "neutral1000"
                            }) : /*#__PURE__*/ jsx(Cross, {
                                fill: "neutral1000"
                            })
                        })
                    })
                ]
            }),
            /*#__PURE__*/ jsx(NavBurgerMenu, {
                isShown: isBurgerMenuShown,
                listLinks: burgerMobileNavigationLinks,
                handleClickOnLink: handleClickOnLink,
                onClose: ()=>setIsBurgerMenuShown(false)
            })
        ]
    });
};

export { LeftMenu };
//# sourceMappingURL=LeftMenu.mjs.map
