'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var theme = require('../../constants/theme.js');
var useDeviceType = require('../../hooks/useDeviceType.js');
var useElementOnScreen = require('../../hooks/useElementOnScreen.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const BaseHeaderLayout = /*#__PURE__*/ React__namespace.forwardRef(({ navigationAction, primaryAction, secondaryAction, subtitle, title, sticky, width, ...props }, ref)=>{
    const isSubtitleString = typeof subtitle === 'string';
    if (sticky) {
        return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
            display: "flex",
            paddingLeft: 6,
            paddingRight: 6,
            paddingTop: 2,
            paddingBottom: 2,
            position: "fixed",
            top: 0,
            background: "neutral0",
            shadow: "tableShadow",
            width: `${width}px`,
            zIndex: 2,
            minHeight: theme.HEIGHT_TOP_NAVIGATION,
            "data-strapi-header-sticky": true,
            children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                alignItems: "center",
                justifyContent: "space-between",
                wrap: "wrap",
                width: "100%",
                children: [
                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                        children: [
                            navigationAction && /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                paddingRight: 3,
                                children: navigationAction
                            }),
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Box, {
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                        variant: "beta",
                                        tag: "h1",
                                        ...props,
                                        children: title
                                    }),
                                    isSubtitleString ? /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                        variant: "pi",
                                        textColor: "neutral600",
                                        children: subtitle
                                    }) : subtitle
                                ]
                            }),
                            secondaryAction ? /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                paddingLeft: 4,
                                children: secondaryAction
                            }) : null
                        ]
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                        children: primaryAction ? /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                            paddingLeft: 2,
                            children: primaryAction
                        }) : undefined
                    })
                ]
            })
        });
    }
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Box, {
        ref: ref,
        paddingLeft: theme.RESPONSIVE_DEFAULT_SPACING,
        paddingRight: theme.RESPONSIVE_DEFAULT_SPACING,
        paddingBottom: {
            initial: 4,
            large: 8
        },
        paddingTop: {
            initial: 4,
            large: navigationAction ? 6 : 8
        },
        background: "neutral100",
        "data-strapi-header": true,
        children: [
            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                direction: "column",
                alignItems: "initial",
                gap: 2,
                children: [
                    navigationAction,
                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                        justifyContent: "space-between",
                        wrap: "wrap",
                        gap: 4,
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                minWidth: 0,
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                        tag: "h1",
                                        variant: "alpha",
                                        ...props,
                                        style: {
                                            wordBreak: 'break-word',
                                            overflowWrap: 'break-word',
                                            maxWidth: '100%'
                                        },
                                        children: title
                                    }),
                                    secondaryAction ? /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                        paddingLeft: 4,
                                        children: secondaryAction
                                    }) : null
                                ]
                            }),
                            primaryAction
                        ]
                    })
                ]
            }),
            isSubtitleString ? /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                variant: "epsilon",
                textColor: "neutral600",
                tag: "p",
                paddingTop: {
                    initial: 4,
                    large: 0
                },
                children: subtitle
            }) : subtitle
        ]
    });
});
const HeaderLayout = (props)=>{
    const baseHeaderLayoutRef = React__namespace.useRef(null);
    const [headerSize, setHeaderSize] = React__namespace.useState(null);
    const [isVisible, setIsVisible] = React__namespace.useState(true);
    const deviceType = useDeviceType.useDeviceType();
    const containerRef = useElementOnScreen.useElementOnScreen(setIsVisible, {
        root: null,
        rootMargin: '0px',
        threshold: 0
    });
    useResizeObserver([
        containerRef,
        baseHeaderLayoutRef
    ], ()=>{
        const headerContainer = baseHeaderLayoutRef.current ?? containerRef.current;
        if (headerContainer) {
            const newSize = headerContainer.getBoundingClientRect();
            setHeaderSize((prevSize)=>{
                // Only update if size actually changed
                if (!prevSize || prevSize.height !== newSize.height || prevSize.width !== newSize.width) {
                    return newSize;
                }
                return prevSize;
            });
        }
    });
    React__namespace.useEffect(()=>{
        if (baseHeaderLayoutRef.current || containerRef.current) {
            const headerContainer = baseHeaderLayoutRef.current ?? containerRef.current;
            setHeaderSize(headerContainer?.getBoundingClientRect() ?? null);
        }
    }, [
        containerRef
    ]);
    if (deviceType === 'mobile') {
        return /*#__PURE__*/ jsxRuntime.jsx(BaseHeaderLayout, {
            ...props
        });
    }
    return /*#__PURE__*/ jsxRuntime.jsxs("div", {
        ref: containerRef,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx("div", {
                style: {
                    height: headerSize?.height
                },
                children: isVisible && /*#__PURE__*/ jsxRuntime.jsx(BaseHeaderLayout, {
                    ref: baseHeaderLayoutRef,
                    ...props
                })
            }),
            !isVisible && /*#__PURE__*/ jsxRuntime.jsx(BaseHeaderLayout, {
                ...props,
                sticky: true,
                width: headerSize?.width
            })
        ]
    });
};
HeaderLayout.displayName = 'HeaderLayout';
/**
 * useResizeObserver: hook that observes the size of an element and calls a callback when it changes.
 */ const useResizeObserver = (sources, onResize)=>{
    const handleResize = designSystem.useCallbackRef(onResize);
    React__namespace.useLayoutEffect(()=>{
        const resizeObs = new ResizeObserver(handleResize);
        if (Array.isArray(sources)) {
            sources.forEach((source)=>{
                if (source.current) {
                    resizeObs.observe(source.current);
                }
            });
        } else if (sources.current) {
            resizeObs.observe(sources.current);
        }
        return ()=>{
            resizeObs.disconnect();
        };
    }, [
        sources,
        handleResize
    ]);
};

exports.BaseHeaderLayout = BaseHeaderLayout;
exports.HeaderLayout = HeaderLayout;
//# sourceMappingURL=HeaderLayout.js.map
