/**
 * This is the base of _any_ env set for a strapi project,
 * to build a strapi admin panel we require these env variables.
 */
interface DefaultEnv {
    ADMIN_PATH: string;
    STRAPI_ADMIN_BACKEND_URL: string;
    STRAPI_TELEMETRY_DISABLED: string;
    STRAPI_AI_URL: string;
    STRAPI_ADMIN_AI_API_KEY?: string;
    STRAPI_ANALYTICS_URL?: string;
}
/**
 * @internal
 *
 * @description Load the .env file if it exists
 */
declare const loadEnv: (cwd: string) => Promise<void>;
/**
 * @internal
 *
 * @description Get all the environment variables that start with `STRAPI_ADMIN_`
 */
declare const getStrapiAdminEnvVars: (defaultEnv: DefaultEnv) => Record<string, string>;
export { getStrapiAdminEnvVars, loadEnv };
//# sourceMappingURL=env.d.ts.map