import type { SVGProps } from 'react';
import { Ref, forwardRef } from 'react';
const SvgEmptyPictures = (props: SVGProps<SVGSVGElement>, ref: Ref<SVGSVGElement>) => (
  <svg xmlns="http://www.w3.org/2000/svg" width={16} height={16} fill="none" viewBox="0 0 217 121" ref={ref} {...props}>
    <g clipPath="url(#EmptyPictures_svg__a)">
      <g clipPath="url(#EmptyPictures_svg__b)" opacity={0.88}>
        <path
          fill="#D9D8FF"
          fillOpacity={0.8}
          fillRule="evenodd"
          d="M119.667 28.797a7 7 0 1 1 0 14h64a7 7 0 1 1 0 14h22a7 7 0 1 1 0 14h-19a7 7 0 1 0 0 14h6a7 7 0 1 1 0 14h-52a7 7 0 0 1-1.5-.161 7 7 0 0 1-1.5.16h-91a7 7 0 0 1 0-14h-39a7 7 0 1 1 0-14h40a7 7 0 0 0 0-14h-25a7 7 0 1 1 0-14h40a7 7 0 1 1 0-14zm90 56a7 7 0 1 1 0 14 7 7 0 0 1 0-14"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="m74.497 103.07-8.622 1.422a4 4 0 0 1-4.518-3.404L50.224 21.866a4 4 0 0 1 3.404-4.518l78.231-10.994a4 4 0 0 1 4.518 3.404c.474 3.377 2.408 16.468 2.571 17.63"
          clipRule="evenodd"
        />
        <path
          fill="#F0F0FF"
          fillRule="evenodd"
          d="m72.472 99.51-3.696.525a3.62 3.62 0 0 1-4.096-3.085l-9.996-71.925a3.646 3.646 0 0 1 3.097-4.107L128.82 10.82a3.62 3.62 0 0 1 4.096 3.085l.859 6.18 9.206 66.599c.306 2.212-1.22 4.257-3.408 4.566l-.07.01z"
          clipRule="evenodd"
        />
        <path
          stroke="#7B79FF"
          strokeLinecap="round"
          strokeWidth={2.5}
          d="m69.945 103.92-4.07.572a4 4 0 0 1-4.518-3.405L50.223 21.866a4 4 0 0 1 3.405-4.518l78.231-10.994a4 4 0 0 1 4.518 3.404l.956 6.808M138.167 21.177l.5 3.12"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          stroke="#7B79FF"
          strokeWidth={2.5}
          d="m165.078 31.096-78.567-8.258a2.74 2.74 0 0 0-2.018.598 2.74 2.74 0 0 0-1.005 1.85l-8.362 79.561a2.748 2.748 0 0 0 2.447 3.023l78.568 8.258a2.74 2.74 0 0 0 2.018-.598 2.74 2.74 0 0 0 1.004-1.85l8.362-79.562a2.74 2.74 0 0 0-.597-2.018 2.74 2.74 0 0 0-1.85-1.004Z"
          clipRule="evenodd"
        />
        <path
          fill="#fff"
          fillRule="evenodd"
          d="m93.657 31.382 62.655 6.585a3 3 0 0 1 2.67 3.297l-5.54 52.71a3 3 0 0 1-3.298 2.67L87.49 90.059a3 3 0 0 1-2.67-3.297l5.54-52.71a3 3 0 0 1 3.297-2.67"
          clipRule="evenodd"
        />
        <path
          fill="#F0F0FF"
          fillRule="evenodd"
          d="m93.407 74.676 9.798-6.609a4 4 0 0 1 5.167.595l7.174 7.722a1 1 0 0 0 1.362.097l15.34-12.43a4 4 0 0 1 5.877.936l9.981 15.438 1.433 2.392-.686 8.124a1 1 0 0 1-1.107.91l-56.963-6.329a1 1 0 0 1-.885-1.085l.755-8.199z"
          clipRule="evenodd"
        />
        <path
          stroke="#7B79FF"
          strokeWidth={2.5}
          d="m156.181 39.21-62.655-6.585c-.48-.05-.936.099-1.284.38a1.75 1.75 0 0 0-.64 1.178l-5.54 52.71c-.05.48.1.936.381 1.284s.697.588 1.177.639l62.655 6.585c.481.05.936-.099 1.284-.38s.589-.697.639-1.177l5.54-52.71a1.74 1.74 0 0 0-.38-1.284 1.74 1.74 0 0 0-1.177-.64Z"
          clipRule="evenodd"
        />
        <path
          fill="#F0F0FF"
          stroke="#7B79FF"
          strokeWidth={2.5}
          d="M105.071 56.714a6 6 0 1 0 1.254-11.936 6 6 0 0 0-1.254 11.936Z"
        />
        <path
          stroke="#7B79FF"
          strokeLinecap="round"
          strokeWidth={2.5}
          d="m91.396 76.222 11.809-8.155a4 4 0 0 1 5.167.594l7.174 7.723a1 1 0 0 0 1.362.096l15.34-12.43a4 4 0 0 1 5.877.936l11.064 17.556"
        />
      </g>
    </g>
    <defs>
      <clipPath id="EmptyPictures_svg__a">
        <path fill="#fff" d="M.667.797h216v120h-216z" />
      </clipPath>
      <clipPath id="EmptyPictures_svg__b">
        <path fill="#fff" d="M.667.797h216v120h-216z" />
      </clipPath>
    </defs>
  </svg>
);
const ForwardRef = forwardRef(SvgEmptyPictures);
export default ForwardRef;
