import { difference, keys } from 'lodash/fp';
import { async } from '@strapi/utils';
import { WORKFLOW_MODEL_UID } from '../constants/workflows.mjs';
import { getWorkflowContentTypeFilter } from '../utils/review-workflows.mjs';

/**
 * Remove CT references from workflows if the CT is deleted
 */ async function migrateDeletedCTInWorkflows({ oldContentTypes, contentTypes }) {
    const deletedContentTypes = difference(keys(oldContentTypes), keys(contentTypes)) ?? [];
    if (deletedContentTypes.length) {
        await async.map(deletedContentTypes, async (deletedContentTypeUID)=>{
            const workflow = await strapi.db.query(WORKFLOW_MODEL_UID).findOne({
                select: [
                    'id',
                    'contentTypes'
                ],
                where: {
                    contentTypes: getWorkflowContentTypeFilter({
                        strapi
                    }, deletedContentTypeUID)
                }
            });
            if (workflow) {
                await strapi.db.query(WORKFLOW_MODEL_UID).update({
                    where: {
                        id: workflow.id
                    },
                    data: {
                        contentTypes: workflow.contentTypes.filter((contentTypeUID)=>contentTypeUID !== deletedContentTypeUID)
                    }
                });
            }
        });
    }
}

export { migrateDeletedCTInWorkflows as default };
//# sourceMappingURL=handle-deleted-ct-in-workflows.mjs.map
