'use strict';

var fp = require('lodash/fp');

const CSP_DEFAULTS = {
    'connect-src': [
        "'self'",
        'https:'
    ],
    'img-src': [
        "'self'",
        'data:',
        'blob:',
        'https://market-assets.strapi.io'
    ],
    'media-src': [
        "'self'",
        'data:',
        'blob:'
    ]
};
/**
 * Utility to extend Strapi middleware configuration. Mainly used to extend the CSP directives from the security middleware.
 *
 * @param middlewares - Array of middleware configurations
 * @param middleware - Middleware configuration to merge/add
 * @returns Modified middlewares array with the new configuration merged
 */ const extendMiddlewareConfiguration = (middlewares, middleware)=>{
    return middlewares.map((currentMiddleware)=>{
        if (typeof currentMiddleware === 'string' && currentMiddleware === middleware.name) {
            // Use the new config object if the middleware has no config property yet
            return middleware;
        }
        if (typeof currentMiddleware === 'object' && currentMiddleware.name === middleware.name) {
            // Deep merge (+ concat arrays) the new config with the current middleware config
            return fp.mergeWith((objValue, srcValue)=>{
                if (Array.isArray(objValue)) {
                    return Array.from(new Set(objValue.concat(srcValue)));
                }
                return undefined;
            }, currentMiddleware, middleware);
        }
        return currentMiddleware;
    });
};

exports.CSP_DEFAULTS = CSP_DEFAULTS;
exports.extendMiddlewareConfiguration = extendMiddlewareConfiguration;
//# sourceMappingURL=security.js.map
