import require$$0 from 'lodash';
import require$$1 from '@strapi/utils';
import { __require as requireUtils } from '../utils/index.mjs';
import { __require as requireUser } from './validation/user.mjs';

var role;
var hasRequiredRole;
function requireRole() {
    if (hasRequiredRole) return role;
    hasRequiredRole = 1;
    const _ = require$$0;
    const { async, errors } = require$$1;
    const { getService } = requireUtils();
    const { validateDeleteRoleBody } = requireUser();
    const { ApplicationError, ValidationError } = errors;
    const sanitizeOutput = async (role)=>{
        const { sanitizeLocalizationFields } = strapi.plugin('i18n').service('sanitize');
        const schema = strapi.getModel('plugin::users-permissions.role');
        return async.pipe(sanitizeLocalizationFields(schema))(role);
    };
    role = {
        /**
	   * Default action.
	   *
	   * @return {Object}
	   */ async createRole (ctx) {
            if (_.isEmpty(ctx.request.body)) {
                throw new ValidationError('Request body cannot be empty');
            }
            await getService('role').createRole(ctx.request.body);
            ctx.send({
                ok: true
            });
        },
        async findOne (ctx) {
            const { id } = ctx.params;
            const role = await getService('role').findOne(id);
            if (!role) {
                return ctx.notFound();
            }
            const safeRole = await sanitizeOutput(role);
            ctx.send({
                role: safeRole
            });
        },
        async find (ctx) {
            const roles = await getService('role').find();
            const safeRoles = await Promise.all(roles.map(sanitizeOutput));
            ctx.send({
                roles: safeRoles
            });
        },
        async updateRole (ctx) {
            const roleID = ctx.params.role;
            if (_.isEmpty(ctx.request.body)) {
                throw new ValidationError('Request body cannot be empty');
            }
            await getService('role').updateRole(roleID, ctx.request.body);
            ctx.send({
                ok: true
            });
        },
        async deleteRole (ctx) {
            const roleID = ctx.params.role;
            if (!roleID) {
                await validateDeleteRoleBody(ctx.params);
            }
            // Fetch public role.
            const publicRole = await strapi.db.query('plugin::users-permissions.role').findOne({
                where: {
                    type: 'public'
                }
            });
            const publicRoleID = publicRole.id;
            // Prevent from removing the public role.
            if (roleID.toString() === publicRoleID.toString()) {
                throw new ApplicationError('Cannot delete public role');
            }
            await getService('role').deleteRole(roleID, publicRoleID);
            ctx.send({
                ok: true
            });
        }
    };
    return role;
}

export { requireRole as __require };
//# sourceMappingURL=role.mjs.map
