import { jsx, jsxs } from 'react/jsx-runtime';
import { Box, Flex, Typography } from '@strapi/design-system';
import { Check } from '@strapi/icons';
import { useIntl } from 'react-intl';
import { getTrad } from '../utils/getTrad.mjs';

const CloudFree = ()=>{
    const { formatMessage } = useIntl();
    const features = [
        {
            id: 'api',
            message: '2.5K API requests'
        },
        {
            id: 'storage',
            message: '10 GB storage'
        },
        {
            id: 'bandwidth',
            message: '10 GB asset bandwidth'
        },
        {
            id: 'cdn',
            message: 'Global CDN'
        },
        {
            id: 'pushToDeploy',
            message: 'Push to deploy'
        }
    ];
    return /*#__PURE__*/ jsx(Box, {
        children: /*#__PURE__*/ jsx(Box, {
            paddingBottom: 10,
            children: /*#__PURE__*/ jsx(Flex, {
                direction: "column",
                children: /*#__PURE__*/ jsx(Flex, {
                    direction: "row",
                    wrap: "wrap",
                    children: features.map(({ id, message })=>/*#__PURE__*/ jsxs(Flex, {
                            paddingRight: 5,
                            children: [
                                /*#__PURE__*/ jsx(Check, {
                                    fill: "primary500"
                                }),
                                /*#__PURE__*/ jsx(Typography, {
                                    variant: "omega",
                                    paddingLeft: 1,
                                    children: formatMessage({
                                        id: getTrad(`Homepage.freePlan.${id}`),
                                        defaultMessage: message
                                    })
                                })
                            ]
                        }, id))
                })
            })
        })
    });
};

export { CloudFree };
//# sourceMappingURL=CloudFree.mjs.map
