'use strict';

var jsxRuntime = require('react/jsx-runtime');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var reactIntl = require('react-intl');
var getTrad = require('../utils/getTrad.js');

const CloudFree = ()=>{
    const { formatMessage } = reactIntl.useIntl();
    const features = [
        {
            id: 'api',
            message: '2.5K API requests'
        },
        {
            id: 'storage',
            message: '10 GB storage'
        },
        {
            id: 'bandwidth',
            message: '10 GB asset bandwidth'
        },
        {
            id: 'cdn',
            message: 'Global CDN'
        },
        {
            id: 'pushToDeploy',
            message: 'Push to deploy'
        }
    ];
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
            paddingBottom: 10,
            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                direction: "column",
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                    direction: "row",
                    wrap: "wrap",
                    children: features.map(({ id, message })=>/*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                            paddingRight: 5,
                            children: [
                                /*#__PURE__*/ jsxRuntime.jsx(icons.Check, {
                                    fill: "primary500"
                                }),
                                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                    variant: "omega",
                                    paddingLeft: 1,
                                    children: formatMessage({
                                        id: getTrad.getTrad(`Homepage.freePlan.${id}`),
                                        defaultMessage: message
                                    })
                                })
                            ]
                        }, id))
                })
            })
        })
    });
};

exports.CloudFree = CloudFree;
//# sourceMappingURL=CloudFree.js.map
