'use strict';

var debug$1 = require('../../utils/debug.js');
require('node:crypto');
require('zod/v4');
var abstract = require('./abstract.js');

const debug = debug$1.createDebugger('routes:provider:plugins');
/**
 * Class providing routes from Strapi plugins.
 *
 * This class extracts and consolidates routes registered by Strapi plugins,
 * accommodating different ways plugins may define their routes.
 *
 * @extends {@link AbstractRoutesProvider}
 */ class PluginRoutesProvider extends abstract.AbstractRoutesProvider {
    /**
   * Retrieves all routes registered in the Strapi plugins.
   *
   * It handles two cases:
   * - The plugin's routes are directly provided as a {@link Core.Route}[].
   * - The plugin's routes are defined as a record of routers which contain their own list of routes.
   *
   * @returns An array of {@link Core.Route} objects.
   */ get routes() {
        const { plugins } = this._strapi;
        const routes = Object.values(plugins).flatMap((plugin)=>{
            const { routes } = plugin;
            return Array.isArray(routes) ? routes : Object.values(routes).flatMap((router)=>router.routes);
        });
        debug('found %o routes in Strapi plugins', routes.length);
        return routes;
    }
}

exports.PluginRoutesProvider = PluginRoutesProvider;
//# sourceMappingURL=plugin.js.map
