import type { SVGProps } from 'react';
import { Ref, forwardRef } from 'react';
const SvgEmptyData = (props: SVGProps<SVGSVGElement>, ref: Ref<SVGSVGElement>) => (
  <svg xmlns="http://www.w3.org/2000/svg" width={16} height={16} fill="none" viewBox="0 0 217 121" ref={ref} {...props}>
    <g clipPath="url(#EmptyData_svg__a)">
      <path
        stroke="#EEEEFA"
        strokeDasharray="3.93 4.91"
        strokeLinecap="round"
        strokeWidth={0.982}
        d="M1.158 99.652h215.018M1.158 80.015h215.018M1.158 59.397h215.018M1.158 38.779h215.018M1.158 20.124h215.018"
      />
      <path
        fill="#D9D8FF"
        fillOpacity={0.8}
        fillRule="evenodd"
        d="M182.63 25.086c4.112 0 7.446 3.279 7.446 7.323s-3.334 7.324-7.446 7.324h-42.545c4.112 0 7.445 3.279 7.445 7.323s-3.333 7.324-7.445 7.324h23.4c4.112 0 7.445 3.278 7.445 7.323 0 4.044-3.333 7.323-7.445 7.323h-10.821c-5.185 0-9.388 3.28-9.388 7.324q0 2.847 3.162 5.314c1.968 1.536 4.676 1.736 6.861 2.943 2.27 1.255 3.804 3.646 3.804 6.39 0 4.044-3.333 7.323-7.445 7.323H61.376c-4.112 0-7.446-3.279-7.446-7.323s3.334-7.324 7.446-7.324H19.894c-4.112 0-7.445-3.279-7.445-7.323s3.333-7.324 7.445-7.324H62.44c4.112 0 7.445-3.278 7.445-7.323s-3.334-7.324-7.446-7.324H35.85c-4.112 0-7.446-3.278-7.446-7.323 0-4.044 3.334-7.323 7.446-7.323h42.545c-4.112 0-7.445-3.28-7.445-7.324s3.333-7.323 7.445-7.323zm0 29.294c4.112 0 7.446 3.278 7.446 7.323 0 4.044-3.334 7.323-7.446 7.323s-7.445-3.278-7.445-7.323 3.333-7.324 7.445-7.324"
        clipRule="evenodd"
      />
      <rect
        width={27}
        height={79.036}
        x={109.403}
        y={33.133}
        fill="#fff"
        stroke="#7B79FF"
        strokeWidth={2.455}
        rx={4.173}
      />
      <rect width={27} height={102.6} x={74.058} y={9.57} fill="#fff" stroke="#7B79FF" strokeWidth={2.455} rx={4.173} />
      <rect
        width={27}
        height={58.418}
        x={39.203}
        y={53.26}
        fill="#fff"
        stroke="#7B79FF"
        strokeWidth={2.455}
        rx={4.173}
      />
      <rect
        width={27}
        height={55.473}
        x={144.748}
        y={56.697}
        fill="#fff"
        stroke="#7B79FF"
        strokeWidth={2.455}
        rx={4.173}
      />
      <rect width={21.6} height={53.018} x={41.903} y={55.961} fill="#EEEEFA" rx={1.964} />
      <rect width={21.6} height={73.636} x={112.103} y={35.833} fill="#EEEEFA" rx={1.964} />
    </g>
    <defs>
      <clipPath id="EmptyData_svg__a">
        <path fill="#fff" d="M.667.797h216v120h-216z" />
      </clipPath>
    </defs>
  </svg>
);
const ForwardRef = forwardRef(SvgEmptyData);
export default ForwardRef;
