import type { LocaleService } from '../services/locales';
import type { PermissionsService } from '../services/permissions';
import type { ContentTypesService } from '../services/content-types';
import type { MetricsService } from '../services/metrics';
import type { ISOLocalesService } from '../services/iso-locales';
import type { LocalizationsService } from '../services/localizations';
import type { SanitizeService } from '../services/sanitize';
import type { SettingsService } from '../services/settings';
import type { createAILocalizationsService } from '../services/ai-localizations';
import type { createAILocalizationJobsService } from '../services/ai-localization-jobs';
type S = {
    permissions: PermissionsService;
    metrics: MetricsService;
    locales: LocaleService;
    localizations: LocalizationsService;
    settings: SettingsService;
    ['iso-locales']: ISOLocalesService;
    ['content-types']: ContentTypesService;
    sanitize: SanitizeService;
    ['ai-localizations']: ReturnType<typeof createAILocalizationsService>;
    'ai-localization-jobs': ReturnType<typeof createAILocalizationJobsService>;
};
declare const getCoreStore: () => {
    get(params?: Partial<{
        key: string;
        type?: string | undefined;
        environment?: string | undefined;
        name?: string | undefined;
        tag?: string | undefined;
    }> | undefined): Promise<unknown>;
    set(params?: Partial<{
        key: string;
        value: unknown;
        type?: string | undefined;
        environment?: string | undefined;
        name?: string | undefined;
        tag?: string | undefined;
    }> | undefined): Promise<void>;
    delete(params?: Partial<{
        key: string;
        type?: string | undefined;
        environment?: string | undefined;
        name?: string | undefined;
        tag?: string | undefined;
    }> | undefined): Promise<void>;
};
declare const getService: <T extends keyof S>(name: T) => S[T] extends (...args: any) => any ? ReturnType<S[T]> : S[T];
export { getService, getCoreStore };
//# sourceMappingURL=index.d.ts.map