import type { Core, Modules, UID } from '@strapi/types';
declare const createAILocalizationsService: ({ strapi }: {
    strapi: Core.Strapi;
}) => {
    isEnabled(): Promise<boolean>;
    /**
     * Checks if there are localizations that need to be generated for the given document,
     * and if so, calls the AI service and saves the results to the database.
     * Works for both single and collection types, on create and update.
     */
    generateDocumentLocalizations({ model, document, }: {
        model: UID.ContentType;
        document: Modules.Documents.AnyDocument;
    }): Promise<void>;
    setupMiddleware(): void;
};
export { createAILocalizationsService };
//# sourceMappingURL=ai-localizations.d.ts.map