import type { Core } from '@strapi/types';
import type { AILocalizationJobs } from '../../../shared/contracts/ai-localization-jobs';
export declare const createAILocalizationJobsService: ({ strapi }: {
    strapi: Core.Strapi;
}) => {
    /**
     * Create a new AI localizations job or update an existing one for a document
     * Ensures only one job exists per document
     */
    upsertJobForDocument({ documentId, contentType, sourceLocale, targetLocales, status, }: {
        documentId: string;
        contentType: string;
        sourceLocale: string;
        targetLocales: string[];
        status?: AILocalizationJobs['status'];
    }): Promise<any>;
    /**
     * Get job by document ID
     */
    getJobByDocument(contentType: string, documentId: string): Promise<any>;
    /**
     * Get job by content type
     */
    getJobByContentType(contentType: string): Promise<any>;
};
//# sourceMappingURL=ai-localization-jobs.d.ts.map